/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.system.impl;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.command.Command;
import com.taobao.arthas.core.shell.command.internal.RedirectHandler;
import com.taobao.arthas.core.shell.command.internal.StdoutHandler;
import com.taobao.arthas.core.shell.command.internal.TermHandler;
import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.impl.ShellImpl;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.JobController;
import com.taobao.arthas.core.shell.system.Process;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import com.taobao.arthas.core.shell.system.impl.JobImpl;
import com.taobao.arthas.core.shell.system.impl.ProcessImpl;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.util.Constants;
import com.taobao.arthas.core.util.TokenUtils;
import io.termd.core.function.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class JobControllerImpl
implements JobController {
    private final SortedMap<Integer, JobImpl> jobs = new TreeMap<Integer, JobImpl>();
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private boolean closed = false;

    @Override
    public synchronized Set<Job> jobs() {
        return new HashSet<Job>(this.jobs.values());
    }

    @Override
    public synchronized Job getJob(int id) {
        return (Job)this.jobs.get(id);
    }

    synchronized boolean removeJob(int id) {
        return this.jobs.remove(id) != null;
    }

    @Override
    public Job createJob(InternalCommandManager commandManager, List<CliToken> tokens, ShellImpl shell) {
        int jobId = this.idGenerator.incrementAndGet();
        StringBuilder line = new StringBuilder();
        for (CliToken arg : tokens) {
            line.append(arg.raw());
        }
        boolean runInBackground = this.runInBackground(tokens);
        Process process = this.createProcess(tokens, commandManager, jobId, shell.term());
        process.setJobId(jobId);
        JobImpl job = new JobImpl(jobId, this, process, line.toString(), runInBackground, shell);
        this.jobs.put(jobId, job);
        return job;
    }

    private int getRedirectJobCount() {
        int count = 0;
        for (Job job : this.jobs.values()) {
            if (job.process() == null || job.process().cacheLocation() == null) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(final Handler<Void> completionHandler) {
        List<JobImpl> jobs;
        JobControllerImpl jobControllerImpl = this;
        synchronized (jobControllerImpl) {
            if (this.closed) {
                jobs = Collections.emptyList();
            } else {
                jobs = new ArrayList<JobImpl>(this.jobs.values());
                this.closed = true;
            }
        }
        if (jobs.isEmpty()) {
            if (completionHandler != null) {
                completionHandler.handle(null);
            }
        } else {
            final AtomicInteger count = new AtomicInteger(jobs.size());
            for (JobImpl job : jobs) {
                job.terminateFuture.setHandler(new Handler<Future<Void>>(){

                    @Override
                    public void handle(Future<Void> v) {
                        if (count.decrementAndGet() == 0 && completionHandler != null) {
                            completionHandler.handle(null);
                        }
                    }
                });
                job.terminate();
            }
        }
    }

    private Process createProcess(List<CliToken> line, InternalCommandManager commandManager, int jobId, Term term) {
        try {
            ListIterator<CliToken> tokens = line.listIterator();
            while (tokens.hasNext()) {
                CliToken token = tokens.next();
                if (!token.isText()) continue;
                Command command = commandManager.getCommand(token.value());
                if (command != null) {
                    return this.createCommandProcess(command, tokens, jobId, term);
                }
                throw new IllegalArgumentException(token.value() + ": command not found");
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean runInBackground(List<CliToken> tokens) {
        boolean runInBackground = false;
        CliToken last = TokenUtils.findLastTextToken(tokens);
        if (last != null && "&".equals(last.value())) {
            runInBackground = true;
            tokens.remove(last);
        }
        return runInBackground;
    }

    private Process createCommandProcess(Command command, ListIterator<CliToken> tokens, int jobId, Term term) {
        ArrayList<CliToken> remaining = new ArrayList<CliToken>();
        ArrayList<CliToken> pipelineTokens = new ArrayList<CliToken>();
        boolean isPipeline = false;
        RedirectHandler redirectHandler = null;
        ArrayList<Function<String, String>> stdoutHandlerChain = new ArrayList<Function<String, String>>();
        String cacheLocation = null;
        while (tokens.hasNext()) {
            CliToken remainingToken = tokens.next();
            if (remainingToken.isText()) {
                String tokenValue = remainingToken.value();
                if ("|".equals(tokenValue)) {
                    isPipeline = true;
                    this.injectHandler(stdoutHandlerChain, pipelineTokens);
                    continue;
                }
                if (">>".equals(tokenValue) || ">".equals(tokenValue)) {
                    String name = this.getRedirectFileName(tokens);
                    if (name == null) {
                        name = Constants.PID + File.separator + jobId;
                        cacheLocation = Constants.CACHE_ROOT + File.separator + name;
                        if (this.getRedirectJobCount() == 8) {
                            throw new IllegalStateException("The amount of async command that saving result to file can't > 8");
                        }
                    }
                    redirectHandler = new RedirectHandler(name);
                    break;
                }
            }
            if (isPipeline) {
                pipelineTokens.add(remainingToken);
                continue;
            }
            remaining.add(remainingToken);
        }
        this.injectHandler(stdoutHandlerChain, pipelineTokens);
        if (redirectHandler != null) {
            stdoutHandlerChain.add(redirectHandler);
        } else {
            stdoutHandlerChain.add(new TermHandler(term));
            if (GlobalOptions.isSaveResult) {
                stdoutHandlerChain.add(new RedirectHandler());
            }
        }
        ProcessImpl.ProcessOutput ProcessOutput2 = new ProcessImpl.ProcessOutput(stdoutHandlerChain, cacheLocation, term);
        return new ProcessImpl(command, remaining, command.processHandler(), ProcessOutput2);
    }

    private String getRedirectFileName(ListIterator<CliToken> tokens) {
        while (tokens.hasNext()) {
            CliToken token = tokens.next();
            if (!token.isText()) continue;
            return token.value();
        }
        return null;
    }

    private void injectHandler(List<Function<String, String>> stdoutHandlerChain, List<CliToken> pipelineTokens) {
        if (!pipelineTokens.isEmpty()) {
            StdoutHandler handler = StdoutHandler.inject(pipelineTokens);
            if (handler != null) {
                stdoutHandlerChain.add(handler);
            }
            pipelineTokens.clear();
        }
    }

    @Override
    public void close() {
        this.close(null);
    }
}

