/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.advisor.ReflectAdviceListenerAdapter;
import com.taobao.arthas.core.command.monitor200.MonitorCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ArthasCheckUtils;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

class MonitorAdviceListener
extends ReflectAdviceListenerAdapter {
    private Timer timer;
    private ConcurrentHashMap<Key, AtomicReference<Data>> monitorData = new ConcurrentHashMap();
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();
    private MonitorCommand command;
    private CommandProcess process;

    MonitorAdviceListener(MonitorCommand command, CommandProcess process) {
        this.command = command;
        this.process = process;
    }

    @Override
    public synchronized void create() {
        if (this.timer == null) {
            this.timer = new Timer("Timer-for-arthas-monitor-" + this.process.session().getSessionId(), true);
            this.timer.scheduleAtFixedRate((TimerTask)new MonitorTimer(this.monitorData, this.process, this.command.getNumberOfLimit()), 0L, (long)(this.command.getCycle() * 1000));
        }
    }

    @Override
    public synchronized void destroy() {
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.threadLocalWatch.start();
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        this.finishing(clazz, method, false);
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) {
        this.finishing(clazz, method, true);
    }

    private void finishing(Class<?> clazz, ArthasMethod method, boolean isThrowing) {
        Data nData;
        Data oData;
        AtomicReference<Data> value;
        double cost = this.threadLocalWatch.costInMillis();
        Key key = new Key(clazz.getName(), method.getName());
        while (null == (value = this.monitorData.get(key))) {
            this.monitorData.putIfAbsent(key, new AtomicReference<Data>(new Data()));
        }
        do {
            oData = value.get();
            nData = new Data();
            nData.setCost(oData.getCost() + cost);
            if (isThrowing) {
                nData.setFailed(oData.getFailed() + 1);
                nData.setSuccess(oData.getSuccess());
            } else {
                nData.setFailed(oData.getFailed());
                nData.setSuccess(oData.getSuccess() + 1);
            }
            nData.setTotal(oData.getTotal() + 1);
        } while (!value.compareAndSet(oData, nData));
    }

    private static class Data {
        private int total;
        private int success;
        private int failed;
        private double cost;

        private Data() {
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public int getSuccess() {
            return this.success;
        }

        public void setSuccess(int success) {
            this.success = success;
        }

        public int getFailed() {
            return this.failed;
        }

        public void setFailed(int failed) {
            this.failed = failed;
        }

        public double getCost() {
            return this.cost;
        }

        public void setCost(double cost) {
            this.cost = cost;
        }
    }

    private static class Key {
        private final String className;
        private final String methodName;

        Key(String className, String behaviorName) {
            this.className = className;
            this.methodName = behaviorName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public int hashCode() {
            return this.className.hashCode() + this.methodName.hashCode();
        }

        public boolean equals(Object obj) {
            if (null == obj || !(obj instanceof Key)) {
                return false;
            }
            Key okey = (Key)obj;
            return ArthasCheckUtils.isEquals(okey.className, this.className) && ArthasCheckUtils.isEquals(okey.methodName, this.methodName);
        }
    }

    private class MonitorTimer
    extends TimerTask {
        private Map<Key, AtomicReference<Data>> monitorData;
        private CommandProcess process;
        private int limit;

        MonitorTimer(Map<Key, AtomicReference<Data>> monitorData, CommandProcess process, int limit) {
            this.monitorData = monitorData;
            this.process = process;
            this.limit = limit;
        }

        @Override
        public void run() {
            if (this.monitorData.isEmpty()) {
                return;
            }
            if (this.process.times().getAndIncrement() >= this.limit) {
                this.cancel();
                MonitorAdviceListener.this.abortProcess(this.process, this.limit);
                return;
            }
            TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
            table.row(true, new Element[]{Element.label((String)"timestamp").style(Decoration.bold.bold()), Element.label((String)"class").style(Decoration.bold.bold()), Element.label((String)"method").style(Decoration.bold.bold()), Element.label((String)"total").style(Decoration.bold.bold()), Element.label((String)"success").style(Decoration.bold.bold()), Element.label((String)"fail").style(Decoration.bold.bold()), Element.label((String)"avg-rt(ms)").style(Decoration.bold.bold()), Element.label((String)"fail-rate").style(Decoration.bold.bold())});
            for (Map.Entry<Key, AtomicReference<Data>> entry : this.monitorData.entrySet()) {
                Data data;
                AtomicReference<Data> value = entry.getValue();
                while (!value.compareAndSet(data = value.get(), new Data())) {
                }
                if (null == data) continue;
                DecimalFormat df = new DecimalFormat("0.00");
                table.row(new String[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), entry.getKey().getClassName(), entry.getKey().getMethodName(), "" + data.getTotal(), "" + data.getSuccess(), "" + data.getFailed(), df.format(this.div(data.getCost(), data.getTotal())), df.format(100.0 * this.div(data.getFailed(), data.getTotal())) + "%"});
            }
            this.process.write(RenderUtil.render((Element)table, (int)this.process.width()) + "\n");
        }

        private double div(double a, double b) {
            if (b == 0.0) {
                return 0.0;
            }
            return a / b;
        }
    }
}

