/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.Enhancer;
import com.taobao.arthas.core.advisor.InvokeTraceable;
import com.taobao.arthas.core.command.monitor200.AbstractTraceAdviceListener;
import com.taobao.arthas.core.command.monitor200.CompleteContext;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.command.CommandInterruptHandler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.annotations.CLIConfigurator;
import com.taobao.middleware.logger.Logger;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class EnhancerCommand
extends AnnotatedCommand {
    private static final Logger logger = LogUtil.getArthasLogger();
    private static final int SIZE_LIMIT = 50;
    private static final int MINIMAL_COMPLETE_SIZE = 3;
    protected static final List<String> EMPTY = Collections.emptyList();
    private static final String[] EXPRESS_EXAMPLES = new String[]{"params", "returnObj", "throwExp", "target", "clazz", "method", "{params,returnObj}", "params[0]"};
    protected Matcher classNameMatcher;
    protected Matcher methodNameMatcher;

    protected abstract Matcher getClassNameMatcher();

    protected abstract Matcher getMethodNameMatcher();

    protected abstract AdviceListener getAdviceListener(CommandProcess var1);

    @Override
    public void process(CommandProcess process) {
        process.interruptHandler(new CommandInterruptHandler(process));
        this.enhance(process);
    }

    @Override
    public void complete(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        CliToken lastToken = tokens.get(tokens.size() - 1);
        CompleteContext completeContext = this.getCompleteContext(completion);
        if (completeContext == null) {
            this.completeDefault(completion, lastToken);
            return;
        }
        switch (completeContext.getState()) {
            case INIT: {
                if (!this.completeClassName(completion)) break;
                completeContext.setState(CompleteContext.CompleteState.CLASS_COMPLETED);
                break;
            }
            case CLASS_COMPLETED: {
                if (!this.completeMethodName(completion)) break;
                completeContext.setState(CompleteContext.CompleteState.METHOD_COMPLETED);
                break;
            }
            case METHOD_COMPLETED: {
                if (!this.completeExpress(completion)) break;
                completeContext.setState(CompleteContext.CompleteState.EXPRESS_COMPLETED);
                break;
            }
            case EXPRESS_COMPLETED: {
                if (!this.completeConditionExpress(completion)) break;
                completeContext.setState(CompleteContext.CompleteState.CONDITION_EXPRESS_COMPLETED);
                break;
            }
            case CONDITION_EXPRESS_COMPLETED: {
                completion.complete(EMPTY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enhance(CommandProcess process) {
        Session session = process.session();
        if (!session.tryLock()) {
            process.write("someone else is enhancing classes, pls. wait.\n");
            process.end();
            return;
        }
        int lock = session.getLock();
        try {
            EnhancerAffect effect;
            Instrumentation inst = session.getInstrumentation();
            AdviceListener listener = this.getAdviceListener(process);
            if (listener == null) {
                EnhancerCommand.warn(process, "advice listener is null");
                return;
            }
            boolean skipJDKTrace = false;
            if (listener instanceof AbstractTraceAdviceListener) {
                skipJDKTrace = ((AbstractTraceAdviceListener)listener).getCommand().isSkipJDKTrace();
            }
            if ((effect = Enhancer.enhance(inst, lock, listener instanceof InvokeTraceable, skipJDKTrace, this.getClassNameMatcher(), this.getMethodNameMatcher())).cCnt() == 0 || effect.mCnt() == 0) {
                process.write("No class or method is affected, try:\n1. sm CLASS_NAME METHOD_NAME to make sure the method you are tracing actually exists (it might be in your parent class).\n2. reset CLASS_NAME and try again, your method body might be too large.\n3. visit https://github.com/alibaba/arthas/issues/47 for more details.\n");
                process.end();
                return;
            }
            if (session.getLock() == lock) {
                process.register(lock, listener);
                if (process.isForeground()) {
                    process.echoTips("Press Ctrl+C to abort.\n");
                }
            }
            process.write(effect + "\n");
        }
        catch (UnmodifiableClassException e) {
            logger.error(null, "error happens when enhancing class", (Throwable)e);
        }
        finally {
            if (session.getLock() == lock) {
                process.session().unLock();
            }
        }
    }

    protected boolean completeClassName(Completion completion) {
        CliToken lastToken = completion.lineTokens().get(completion.lineTokens().size() - 1);
        if (lastToken.value().length() >= 3) {
            Set<Class<?>> results = SearchUtils.searchClassOnly(completion.session().getInstrumentation(), "*" + lastToken.value() + "*", 50);
            if (results.size() >= 50) {
                Iterator<Class<?>> it = results.iterator();
                ArrayList<String> res = new ArrayList<String>(50);
                while (it.hasNext()) {
                    res.add(it.next().getName());
                }
                res.add("and possibly more...");
                completion.complete(res);
            } else {
                if (results.size() == 1) {
                    Class<?> clazz = results.iterator().next();
                    completion.complete(clazz.getName().substring(lastToken.value().length()), true);
                    return true;
                }
                ArrayList<String> res = new ArrayList<String>(results.size());
                for (Class<?> clazz : results) {
                    res.add(clazz.getName());
                }
                completion.complete(res);
            }
        } else {
            completion.complete(Collections.singletonList("Too many classes to display, please try to input at least 3 characters to get auto complete working."));
        }
        return false;
    }

    protected boolean completeMethodName(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        CliToken lastToken = completion.lineTokens().get(tokens.size() - 1);
        String className = " ".equals(lastToken.value()) ? tokens.get(tokens.size() - 2).value() : tokens.get(tokens.size() - 3).value();
        Set<Class<?>> results = SearchUtils.searchClassOnly(completion.session().getInstrumentation(), className, 2);
        if (results.isEmpty() || results.size() > 1) {
            completion.complete(EMPTY);
            return false;
        }
        Class<?> clazz = results.iterator().next();
        ArrayList<String> res = new ArrayList<String>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (" ".equals(lastToken.value())) {
                res.add(method.getName());
                continue;
            }
            if (!method.getName().contains(lastToken.value())) continue;
            res.add(method.getName());
        }
        if (res.size() == 1) {
            completion.complete(((String)res.get(0)).substring(lastToken.value().length()), true);
            return true;
        }
        completion.complete(res);
        return false;
    }

    protected boolean completeExpress(Completion completion) {
        return CompletionUtils.complete(completion, Arrays.asList(EXPRESS_EXAMPLES));
    }

    protected boolean completeConditionExpress(Completion completion) {
        completion.complete(EMPTY);
        return true;
    }

    protected void completeDefault(Completion completion, CliToken lastToken) {
        CLI cli = CLIConfigurator.define(this.getClass());
        List options = cli.getOptions();
        if (lastToken == null || lastToken.isBlank()) {
            CompletionUtils.completeUsage(completion, cli);
        } else if (lastToken.value().startsWith("--")) {
            CompletionUtils.completeLongOption(completion, lastToken, options);
        } else if (lastToken.value().startsWith("-")) {
            CompletionUtils.completeShortOption(completion, lastToken, options);
        } else {
            completion.complete(EMPTY);
        }
    }

    private CompleteContext getCompleteContext(Completion completion) {
        CompleteContext completeContext = new CompleteContext();
        List<CliToken> tokens = completion.lineTokens();
        CliToken lastToken = tokens.get(tokens.size() - 1);
        if (lastToken.value().startsWith("-") || lastToken.value().startsWith("--")) {
            return null;
        }
        int tokenCount = 0;
        for (CliToken token : tokens) {
            if (" ".equals(token.value()) || token.value().startsWith("-") || token.value().startsWith("--")) continue;
            ++tokenCount;
        }
        for (CompleteContext.CompleteState state : CompleteContext.CompleteState.values()) {
            if (tokenCount != state.ordinal() && (tokenCount != state.ordinal() + 1 || " ".equals(lastToken.value()))) continue;
            completeContext.setState(state);
            return completeContext;
        }
        return completeContext;
    }

    private static void warn(CommandProcess process, String message) {
        logger.error(null, message);
        process.write("cannot operate the current command, pls. check arthas.log\n");
        if (process.isForeground()) {
            process.echoTips("Press Ctrl+C to abort.\n");
        }
    }
}

