/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.advisor.ReflectAdviceListenerAdapter;
import com.taobao.arthas.core.command.monitor200.TraceCommand;
import com.taobao.arthas.core.command.monitor200.TraceEntity;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.ThreadLocalWatch;

public class AbstractTraceAdviceListener
extends ReflectAdviceListenerAdapter {
    protected final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();
    protected TraceCommand command;
    protected CommandProcess process;
    protected final ThreadLocal<TraceEntity> threadBoundEntity = new ThreadLocal<TraceEntity>(){

        @Override
        protected TraceEntity initialValue() {
            return new TraceEntity();
        }
    };

    public AbstractTraceAdviceListener(TraceCommand command, CommandProcess process) {
        this.command = command;
        this.process = process;
    }

    @Override
    public void destroy() {
        this.threadBoundEntity.remove();
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.threadBoundEntity.get().view.begin(clazz.getName() + ":" + method.getName() + "()");
        ++this.threadBoundEntity.get().deep;
        this.threadLocalWatch.start();
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        this.threadBoundEntity.get().view.end();
        Advice advice = Advice.newForAfterRetuning(loader, clazz, method, target, args, returnObject);
        this.finishing(advice);
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) throws Throwable {
        this.threadBoundEntity.get().view.begin("throw:" + throwable.getClass().getName() + "()").end().end();
        Advice advice = Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable);
        this.finishing(advice);
    }

    public TraceCommand getCommand() {
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishing(Advice advice) {
        double cost = this.threadLocalWatch.costInMillis();
        if (--this.threadBoundEntity.get().deep == 0) {
            try {
                if (this.isConditionMet(this.command.getConditionExpress(), advice, cost)) {
                    if (this.isLimitExceeded(this.command.getNumberOfLimit(), this.process.times().get())) {
                        this.abortProcess(this.process, this.command.getNumberOfLimit());
                    } else {
                        this.process.times().incrementAndGet();
                        this.process.write(this.threadBoundEntity.get().view.draw() + "\n");
                    }
                }
            }
            catch (Throwable e) {
                LogUtil.getArthasLogger().warn("trace failed.", e);
                this.process.write("trace failed, condition is: " + this.command.getConditionExpress() + ", " + e.getMessage() + ", visit " + LogUtil.LOGGER_FILE + " for more details.\n");
                this.process.end();
            }
            finally {
                this.threadBoundEntity.remove();
            }
        }
    }
}

