/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.matcher.RegexMatcher;
import com.taobao.arthas.core.util.matcher.WildcardMatcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

@Name(value="sm")
@Summary(value="Search the method of classes loaded by JVM")
@Description(value="\nEXAMPLES:\n  sm -Ed org\\\\.apache\\\\.commons\\\\.lang\\.StringUtils .*\n  sm org.apache.commons.????.StringUtils *\n  sm -d org.apache.commons.lang.StringUtils\n  sm -d org/apache/commons/lang/StringUtils\n  sm *String????s *\n\nWIKI:\n  https://alibaba.github.io/arthas/sm")
public class SearchMethodCommand
extends AnnotatedCommand {
    private String classPattern;
    private String methodPattern;
    private boolean isDetail = false;
    private boolean isRegEx = false;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(argName="method-pattern", index=1, required=false)
    @Description(value="Method name pattern")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Option(shortName="d", longName="details", flag=true)
    @Description(value="Display the details of method")
    public void setDetail(boolean detail) {
        this.isDetail = detail;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        Instrumentation inst = process.session().getInstrumentation();
        Matcher<String> methodNameMatcher = this.methodNameMatcher();
        Set<Class<?>> matchedClasses = SearchUtils.searchClass(inst, this.classPattern, this.isRegEx);
        for (Class<?> clazz : matchedClasses) {
            String line;
            HashSet<String> methodNames = new HashSet<String>();
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (!methodNameMatcher.matching("<init>")) continue;
                if (this.isDetail) {
                    process.write(RenderUtil.render((Element)this.renderConstructor(constructor), (int)process.width()) + "\n");
                } else {
                    if (methodNames.contains("<init>")) continue;
                    methodNames.add("<init>");
                    line = String.format("%s->%s%n", clazz.getName(), "<init>");
                    process.write(line);
                }
                affect.rCnt(1);
            }
            for (Executable executable : clazz.getDeclaredMethods()) {
                if (!methodNameMatcher.matching(((Method)executable).getName())) continue;
                if (this.isDetail) {
                    process.write(RenderUtil.render((Element)this.renderMethod((Method)executable), (int)process.width()) + "\n");
                } else {
                    if (methodNames.contains(((Method)executable).getName())) continue;
                    methodNames.add(((Method)executable).getName());
                    line = String.format("%s->%s%n", clazz.getName(), ((Method)executable).getName());
                    process.write(line);
                }
                affect.rCnt(1);
            }
        }
        process.write(affect + "\n");
        process.end();
    }

    private Matcher<String> methodNameMatcher() {
        if (StringUtils.isBlank(this.methodPattern)) {
            this.methodPattern = this.isRegEx ? ".*" : "*";
        }
        return this.isRegEx ? new RegexMatcher(this.methodPattern) : new WildcardMatcher(this.methodPattern);
    }

    private Element renderMethod(Method method) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{Element.label((String)"declaring-class").style(Decoration.bold.bold()), Element.label((String)method.getDeclaringClass().getName())}).row(new Element[]{Element.label((String)"method-name").style(Decoration.bold.bold()), Element.label((String)method.getName()).style(Decoration.bold.bold())}).row(new Element[]{Element.label((String)"modifier").style(Decoration.bold.bold()), Element.label((String)StringUtils.modifier(method.getModifiers(), ','))}).row(new Element[]{Element.label((String)"annotation").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawAnnotation(method))}).row(new Element[]{Element.label((String)"parameters").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawParameters(method))}).row(new Element[]{Element.label((String)"return").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawReturn(method))}).row(new Element[]{Element.label((String)"exceptions").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawExceptions(method))});
        return table;
    }

    private Element renderConstructor(Constructor constructor) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{Element.label((String)"declaring-class").style(Decoration.bold.bold()), Element.label((String)constructor.getDeclaringClass().getName())}).row(new Element[]{Element.label((String)"constructor-name").style(Decoration.bold.bold()), Element.label((String)"<init>").style(Decoration.bold.bold())}).row(new Element[]{Element.label((String)"modifier").style(Decoration.bold.bold()), Element.label((String)StringUtils.modifier(constructor.getModifiers(), ','))}).row(new Element[]{Element.label((String)"annotation").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawAnnotation(constructor.getDeclaredAnnotations()))}).row(new Element[]{Element.label((String)"parameters").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawParameters(constructor))}).row(new Element[]{Element.label((String)"exceptions").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawExceptions(constructor))});
        return table;
    }
}

