/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.express.ExpressFactory;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ArthasCheckUtils;
import com.taobao.arthas.core.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.objectweb.asm.Type;

public abstract class ReflectAdviceListenerAdapter
implements AdviceListener {
    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    private ClassLoader toClassLoader(ClassLoader loader) {
        return null != loader ? loader : AdviceListener.class.getClassLoader();
    }

    private Class<?> toClass(ClassLoader loader, String className) throws ClassNotFoundException {
        return Class.forName(StringUtils.normalizeClassName(className), true, this.toClassLoader(loader));
    }

    private ArthasMethod toMethod(ClassLoader loader, Class<?> clazz, String methodName, String methodDesc) throws ClassNotFoundException, NoSuchMethodException {
        Type asmType = Type.getMethodType((String)methodDesc);
        Class[] argsClasses = new Class[asmType.getArgumentTypes().length];
        for (int index = 0; index < argsClasses.length; ++index) {
            Class<Object> argumentClass;
            Type argumentAsmType = asmType.getArgumentTypes()[index];
            switch (argumentAsmType.getSort()) {
                case 1: {
                    argumentClass = Boolean.TYPE;
                    break;
                }
                case 2: {
                    argumentClass = Character.TYPE;
                    break;
                }
                case 3: {
                    argumentClass = Byte.TYPE;
                    break;
                }
                case 4: {
                    argumentClass = Short.TYPE;
                    break;
                }
                case 5: {
                    argumentClass = Integer.TYPE;
                    break;
                }
                case 6: {
                    argumentClass = Float.TYPE;
                    break;
                }
                case 7: {
                    argumentClass = Long.TYPE;
                    break;
                }
                case 8: {
                    argumentClass = Double.TYPE;
                    break;
                }
                case 9: {
                    argumentClass = this.toClass(loader, argumentAsmType.getInternalName());
                    break;
                }
                case 0: {
                    argumentClass = Void.TYPE;
                    break;
                }
                default: {
                    argumentClass = this.toClass(loader, argumentAsmType.getClassName());
                }
            }
            argsClasses[index] = argumentClass;
        }
        if (ArthasCheckUtils.isEquals(methodName, "<init>")) {
            return ArthasMethod.newInit(this.toConstructor(clazz, argsClasses));
        }
        return ArthasMethod.newMethod(this.toMethod(clazz, methodName, argsClasses));
    }

    private Method toMethod(Class<?> clazz, String methodName, Class<?>[] argClasses) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(methodName, argClasses);
    }

    private Constructor<?> toConstructor(Class<?> clazz, Class<?>[] argClasses) throws NoSuchMethodException {
        return clazz.getDeclaredConstructor(argClasses);
    }

    @Override
    public final void before(ClassLoader loader, String className, String methodName, String methodDesc, Object target, Object[] args) throws Throwable {
        Class<?> clazz = this.toClass(loader, className);
        this.before(loader, clazz, this.toMethod(loader, clazz, methodName, methodDesc), target, args);
    }

    @Override
    public final void afterReturning(ClassLoader loader, String className, String methodName, String methodDesc, Object target, Object[] args, Object returnObject) throws Throwable {
        Class<?> clazz = this.toClass(loader, className);
        this.afterReturning(loader, clazz, this.toMethod(loader, clazz, methodName, methodDesc), target, args, returnObject);
    }

    @Override
    public final void afterThrowing(ClassLoader loader, String className, String methodName, String methodDesc, Object target, Object[] args, Throwable throwable) throws Throwable {
        Class<?> clazz = this.toClass(loader, className);
        this.afterThrowing(loader, clazz, this.toMethod(loader, clazz, methodName, methodDesc), target, args, throwable);
    }

    public abstract void before(ClassLoader var1, Class<?> var2, ArthasMethod var3, Object var4, Object[] var5) throws Throwable;

    public abstract void afterReturning(ClassLoader var1, Class<?> var2, ArthasMethod var3, Object var4, Object[] var5, Object var6) throws Throwable;

    public abstract void afterThrowing(ClassLoader var1, Class<?> var2, ArthasMethod var3, Object var4, Object[] var5, Throwable var6) throws Throwable;

    protected boolean isConditionMet(String conditionExpress, Advice advice, double cost) throws ExpressException {
        return StringUtils.isEmpty(conditionExpress) || ExpressFactory.newExpress(advice).bind("cost", cost).is(conditionExpress);
    }

    protected Object getExpressionResult(String express, Advice advice, double cost) throws ExpressException {
        return ExpressFactory.newExpress(advice).bind("cost", cost).get(express);
    }

    protected boolean isLimitExceeded(int limit, int currentTimes) {
        return currentTimes >= limit;
    }

    protected void abortProcess(CommandProcess process, int limit) {
        process.write("Command execution times exceed limit: " + limit + ", so command will exit. You can set it with -n option.\n");
        process.end();
    }
}

