/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.taobao.arthas.core.advisor.CodeLock;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.AdviceAdapter;

public class AsmCodeLock
implements CodeLock,
Opcodes {
    private final AdviceAdapter aa;
    private boolean isLook;
    private final int[] beginCodeArray;
    private final int[] endCodeArray;
    private int index = 0;

    public AsmCodeLock(AdviceAdapter aa, int[] beginCodeArray, int[] endCodeArray) {
        if (null == beginCodeArray || null == endCodeArray || beginCodeArray.length != endCodeArray.length) {
            throw new IllegalArgumentException();
        }
        this.aa = aa;
        this.beginCodeArray = beginCodeArray;
        this.endCodeArray = endCodeArray;
    }

    @Override
    public void code(int code) {
        int[] codes;
        int[] nArray = codes = this.isLock() ? this.endCodeArray : this.beginCodeArray;
        if (this.index >= codes.length) {
            this.reset();
            return;
        }
        if (codes[this.index] != code) {
            this.reset();
            return;
        }
        if (++this.index == codes.length) {
            this.isLook = !this.isLook;
            this.reset();
        }
    }

    private void reset() {
        this.index = 0;
    }

    private void asm(int opcode) {
        this.aa.visitInsn(opcode);
    }

    private void lock() {
        for (int op : this.beginCodeArray) {
            this.asm(op);
        }
    }

    private void unLock() {
        for (int op : this.endCodeArray) {
            this.asm(op);
        }
    }

    @Override
    public boolean isLock() {
        return this.isLook;
    }

    @Override
    public void lock(CodeLock.Block block) {
        this.lock();
        try {
            block.code();
        }
        finally {
            this.unLock();
        }
    }
}

