/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.taobao.arthas.core.advisor.Enhancer;
import com.taobao.arthas.core.command.klass100.ClassDumpTransformer;
import com.taobao.arthas.core.command.klass100.SearchClassCommand;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.FileUtils;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.middleware.logger.Logger;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.lang.LangRenderUtil;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.benf.cfr.reader.Main;
import org.objectweb.asm.Type;

@Name(value="jad")
@Summary(value="Decompile class")
@Description(value="\nEXAMPLES:\n  jad -c 39eb305e org.apache.log4j.Logger\n  jad -c 39eb305e org/apache/log4j/Logger\n  jad -c 39eb305e -E org\\\\.apache\\\\.*\\\\.StringUtils\n\nWIKI:\n  https://alibaba.github.io/arthas/jad")
public class JadCommand
extends AnnotatedCommand {
    private static final Logger logger = LogUtil.getArthasLogger();
    private static Pattern pattern = Pattern.compile("(?m)^/\\*\\s*\\*/\\s*$" + System.getProperty("line.separator"));
    private static final String OUTPUTOPTION = "--outputdir";
    private static final String COMMENTS = "--comments";
    private static final String DecompilePath = new File(LogUtil.LOGGER_FILE).getParent() + File.separator + "decompile";
    private String classPattern;
    private String methodName;
    private String code = null;
    private boolean isRegEx = false;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(argName="method-name", index=1, required=false)
    @Description(value="method name pattern, decompile a specific method instead of the whole class")
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Option(shortName="c", longName="code")
    @Description(value="The hash code of the special class's classLoader")
    public void setCode(String code) {
        this.code = code;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        Instrumentation inst = process.session().getInstrumentation();
        Set<Class<?>> matchedClasses = SearchUtils.searchClassOnly(inst, this.classPattern, this.isRegEx, this.code);
        try {
            if (matchedClasses == null || matchedClasses.isEmpty()) {
                this.processNoMatch(process);
            } else if (matchedClasses.size() > 1) {
                this.processMatches(process, matchedClasses);
            } else {
                Set<Class<?>> withInnerClasses = SearchUtils.searchClassOnly(inst, this.classPattern + "(?!.*\\$\\$Lambda\\$).*", true, this.code);
                this.processExactMatch(process, affect, inst, matchedClasses, withInnerClasses);
            }
        }
        finally {
            process.write(affect + "\n");
            process.end();
        }
    }

    private void processExactMatch(CommandProcess process, RowAffect affect, Instrumentation inst, Set<Class<?>> matchedClasses, Set<Class<?>> withInnerClasses) {
        Class<?> c = matchedClasses.iterator().next();
        matchedClasses = withInnerClasses;
        try {
            ClassDumpTransformer transformer = new ClassDumpTransformer(matchedClasses);
            Enhancer.enhance(inst, transformer, matchedClasses);
            Map<Class<?>, File> classFiles = transformer.getDumpResult();
            File classFile = classFiles.get(c);
            String source = this.decompileWithCFR(classFile.getAbsolutePath(), c, this.methodName);
            source = source != null ? pattern.matcher(source).replaceAll("") : "unknown";
            process.write("\n");
            process.write(RenderUtil.render((Element)new LabelElement("ClassLoader: ").style(Decoration.bold.fg(Color.red)), (int)process.width()));
            process.write(RenderUtil.render((Element)TypeRenderUtils.drawClassLoader(c), (int)process.width()) + "\n");
            process.write(RenderUtil.render((Element)new LabelElement("Location: ").style(Decoration.bold.fg(Color.red)), (int)process.width()));
            process.write(RenderUtil.render((Element)new LabelElement(SearchClassCommand.getCodeSource(c.getProtectionDomain().getCodeSource())).style(Decoration.bold.fg(Color.blue)), (int)process.width()) + "\n");
            process.write(LangRenderUtil.render((String)source) + "\n");
            process.write("");
            affect.rCnt(classFiles.keySet().size());
        }
        catch (Throwable t) {
            logger.error(null, "jad: fail to decompile class: " + c.getName(), t);
        }
    }

    private void processMatches(CommandProcess process, Set<Class<?>> matchedClasses) {
        LabelElement usage = new LabelElement("jad -c <hashcode> " + this.classPattern).style(Decoration.bold.fg(Color.blue));
        process.write("\n Found more than one class for: " + this.classPattern + ", Please use " + RenderUtil.render((Element)usage, (int)process.width()));
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{new LabelElement("HASHCODE").style(Decoration.bold.bold()), new LabelElement("CLASSLOADER").style(Decoration.bold.bold())});
        for (Class<?> c : matchedClasses) {
            ClassLoader classLoader = c.getClassLoader();
            table.row(new Element[]{Element.label((String)Integer.toHexString(classLoader.hashCode())).style(Decoration.bold.fg(Color.red)), TypeRenderUtils.drawClassLoader(c)});
        }
        process.write(RenderUtil.render((Element)table, (int)process.width()) + "\n");
    }

    private void processNoMatch(CommandProcess process) {
        process.write("No class found for: " + this.classPattern + "\n");
    }

    private String decompileWithCFR(String classPath, Class<?> clazz, String methodName) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(classPath);
        if (methodName != null) {
            options.add(methodName);
        }
        options.add(OUTPUTOPTION);
        options.add(DecompilePath);
        options.add(COMMENTS);
        options.add("false");
        String[] args = new String[options.size()];
        options.toArray(args);
        Main.main(args);
        String outputFilePath = DecompilePath + File.separator + Type.getInternalName(clazz) + ".java";
        File outputFile = new File(outputFilePath);
        if (outputFile.exists()) {
            try {
                return FileUtils.readFileToString(outputFile, Charset.defaultCharset());
            }
            catch (IOException e) {
                logger.error(null, "error read decompile result in: " + outputFilePath, (Throwable)e);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String[] names = new String[]{"com.taobao.container.web.arthas.mvc.AppInfoController", "com.taobao.container.web.arthas.mvc.AppInfoController$1$$Lambda$19/381016128", "com.taobao.container.web.arthas.mvc.AppInfoController$$Lambda$16/17741163", "com.taobao.container.web.arthas.mvc.AppInfoController$1", "com.taobao.container.web.arthas.mvc.AppInfoController$123", "com.taobao.container.web.arthas.mvc.AppInfoController$A", "com.taobao.container.web.arthas.mvc.AppInfoController$ABC"};
        String pattern = "com.taobao.container.web.arthas.mvc.AppInfoController(?!.*\\$\\$Lambda\\$).*";
        for (String name : names) {
            System.out.println(name + "    " + Pattern.matches(pattern, name));
        }
    }
}

