/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.ui.TreeElement;
import com.taobao.text.util.RenderUtil;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

@Name(value="classloader")
@Summary(value="Show classloader info")
@Description(value="\nEXAMPLES:\n  classloader\n  classloader -t\n  classloader -c 327a647b\n  classloader -c 327a647b -r META-INF/MANIFEST.MF\n  classloader -a\n  classloader -a -c 327a647b\n\nWIKI:\n  https://alibaba.github.io/arthas/classloader")
public class ClassLoaderCommand
extends AnnotatedCommand {
    private boolean isTree = false;
    private String hashCode;
    private boolean all = false;
    private String resource;
    private boolean includeReflectionClassLoader = true;
    private boolean listClassLoader = false;

    @Option(shortName="t", longName="tree", flag=true)
    @Description(value="Display ClassLoader tree")
    public void setTree(boolean tree) {
        this.isTree = tree;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="Display ClassLoader urls")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(shortName="a", longName="all", flag=true)
    @Description(value="Display all classes loaded by ClassLoader")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Option(shortName="r", longName="resource")
    @Description(value="Use ClassLoader to find resources, won't work without -c specified")
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Option(shortName="i", longName="include-reflection-classloader", flag=true)
    @Description(value="Include sun.reflect.DelegatingClassLoader")
    public void setIncludeReflectionClassLoader(boolean includeReflectionClassLoader) {
        this.includeReflectionClassLoader = includeReflectionClassLoader;
    }

    @Option(shortName="l", longName="list-classloader", flag=true)
    @Description(value="Display statistics info by classloader instance")
    public void setListClassLoader(boolean listClassLoader) {
        this.listClassLoader = listClassLoader;
    }

    @Override
    public void process(CommandProcess process) {
        Instrumentation inst = process.session().getInstrumentation();
        if (this.all) {
            this.processAllClasses(process, inst);
        } else if (this.hashCode != null && this.resource != null) {
            this.processResources(process, inst);
        } else if (this.hashCode != null) {
            this.processClassloader(process, inst);
        } else if (this.listClassLoader || this.isTree) {
            this.processClassloaders(process, inst);
        } else {
            this.processClassLoaderStats(process, inst);
        }
    }

    private void processClassLoaderStats(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        List<ClassLoaderInfo> classLoaderInfos = ClassLoaderCommand.getAllClassLoaderInfo(inst, new Filter[0]);
        HashMap<String, ClassLoaderStat> classLoaderStats = new HashMap<String, ClassLoaderStat>();
        for (ClassLoaderInfo info : classLoaderInfos) {
            String name = info.classLoader == null ? "BootstrapClassLoader" : info.classLoader.getClass().getName();
            ClassLoaderStat stat = (ClassLoaderStat)classLoaderStats.get(name);
            if (null == stat) {
                stat = new ClassLoaderStat();
                classLoaderStats.put(name, stat);
            }
            stat.addLoadedCount(info.loadedClassCount);
            stat.addNumberOfInstance(1);
        }
        TreeMap<String, ClassLoaderStat> sorted = new TreeMap<String, ClassLoaderStat>(new ValueComparator(classLoaderStats));
        sorted.putAll(classLoaderStats);
        TableElement element = ClassLoaderCommand.renderStat(sorted);
        process.write(RenderUtil.render((Element)element, (int)process.width())).write("");
        affect.rCnt(sorted.keySet().size());
        process.write(affect + "\n");
        process.end();
    }

    private void processClassloaders(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        List<ClassLoaderInfo> classLoaderInfos = this.includeReflectionClassLoader ? ClassLoaderCommand.getAllClassLoaderInfo(inst, new Filter[0]) : ClassLoaderCommand.getAllClassLoaderInfo(inst, new SunReflectionClassLoaderFilter());
        Element element = this.isTree ? ClassLoaderCommand.renderTree(classLoaderInfos) : ClassLoaderCommand.renderTable(classLoaderInfos);
        process.write(RenderUtil.render((Element)element, (int)process.width())).write("");
        affect.rCnt(classLoaderInfos.size());
        process.write(affect + "\n");
        process.end();
    }

    private void processClassloader(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        Set<ClassLoader> allClassLoader = ClassLoaderCommand.getAllClassLoader(inst, new Filter[0]);
        for (ClassLoader cl : allClassLoader) {
            if (!Integer.toHexString(cl.hashCode()).equals(this.hashCode)) continue;
            process.write(RenderUtil.render((Element)ClassLoaderCommand.renderClassLoaderUrls(cl), (int)process.width()));
        }
        process.write("");
        affect.rCnt(allClassLoader.size());
        process.write(affect + "\n");
        process.end();
    }

    private void processResources(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        int rowCount = 0;
        Set<ClassLoader> allClassLoader = this.includeReflectionClassLoader ? ClassLoaderCommand.getAllClassLoader(inst, new Filter[0]) : ClassLoaderCommand.getAllClassLoader(inst, new SunReflectionClassLoaderFilter());
        for (ClassLoader cl : allClassLoader) {
            if (!Integer.toHexString(cl.hashCode()).equals(this.hashCode)) continue;
            TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
            try {
                Enumeration<URL> urls = cl.getResources(this.resource);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    table.row(new String[]{url.toString()});
                    ++rowCount;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            process.write(RenderUtil.render((Element)table, (int)process.width()) + "\n");
        }
        process.write("");
        process.write(affect.rCnt(rowCount) + "\n");
        process.end();
    }

    private void processAllClasses(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        process.write(RenderUtil.render((Element)ClassLoaderCommand.renderClasses(this.hashCode, inst), (int)process.width()));
        process.write(affect + "\n");
        process.end();
    }

    private static Element renderClasses(String hashCode, Instrumentation inst) {
        int hashCodeInt = -1;
        if (hashCode != null) {
            hashCodeInt = Integer.valueOf(hashCode, 16);
        }
        TreeSet<Class> bootstrapClassSet = new TreeSet<Class>(new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Class[] allLoadedClasses = inst.getAllLoadedClasses();
        HashMap<ClassLoader, TreeSet<Class>> classLoaderClassMap = new HashMap<ClassLoader, TreeSet<Class>>();
        for (Class clazz : allLoadedClasses) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                if (hashCode != null) continue;
                bootstrapClassSet.add(clazz);
                continue;
            }
            if (hashCode != null && classLoader.hashCode() != hashCodeInt) continue;
            TreeSet<Class> classSet = (TreeSet<Class>)classLoaderClassMap.get(classLoader);
            if (classSet == null) {
                classSet = new TreeSet<Class>(new Comparator<Class>(){

                    @Override
                    public int compare(Class o1, Class o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                classLoaderClassMap.put(classLoader, classSet);
            }
            classSet.add(clazz);
        }
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        if (!bootstrapClassSet.isEmpty()) {
            table.row(new Element[]{new LabelElement("hash:null, BootstrapClassLoader").style(Decoration.bold.bold())});
            for (Class clazz : bootstrapClassSet) {
                table.row(new Element[]{new LabelElement(clazz.getName())});
            }
            table.row(new Element[]{new LabelElement(" ")});
        }
        for (Map.Entry entry : classLoaderClassMap.entrySet()) {
            ClassLoader classLoader = (ClassLoader)entry.getKey();
            SortedSet classSet = (SortedSet)entry.getValue();
            table.row(new Element[]{new LabelElement("hash:" + classLoader.hashCode() + ", " + classLoader.toString()).style(Decoration.bold.bold())});
            for (Class clazz : classSet) {
                table.row(new Element[]{new LabelElement(clazz.getName())});
            }
            table.row(new Element[]{new LabelElement(" ")});
        }
        return table;
    }

    private static Element renderClassLoaderUrls(ClassLoader classLoader) {
        StringBuilder sb = new StringBuilder();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader cl = (URLClassLoader)classLoader;
            URL[] urls = cl.getURLs();
            if (urls != null) {
                for (URL url : urls) {
                    sb.append(url.toString() + "\n");
                }
                return new LabelElement(sb.toString());
            }
            return new LabelElement("urls is empty.");
        }
        return new LabelElement("not a URLClassLoader.\n");
    }

    private static Element renderTree(List<ClassLoaderInfo> classLoaderInfos) {
        TreeElement root = new TreeElement();
        ArrayList<ClassLoaderInfo> parentNullClassLoaders = new ArrayList<ClassLoaderInfo>();
        ArrayList<ClassLoaderInfo> parentNotNullClassLoaders = new ArrayList<ClassLoaderInfo>();
        for (ClassLoaderInfo info : classLoaderInfos) {
            if (info.parent() == null) {
                parentNullClassLoaders.add(info);
                continue;
            }
            parentNotNullClassLoaders.add(info);
        }
        for (ClassLoaderInfo info : parentNullClassLoaders) {
            if (info.parent() != null) continue;
            TreeElement parent = new TreeElement(info.getName());
            ClassLoaderCommand.renderParent(parent, info, parentNotNullClassLoaders);
            root.addChild((Element)parent);
        }
        return root;
    }

    private static TableElement renderTable(List<ClassLoaderInfo> classLoaderInfos) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.bold()).add(new String[]{"name", "loadedCount", "hash", "parent"}));
        for (ClassLoaderInfo info : classLoaderInfos) {
            table.row(new String[]{info.getName(), "" + info.loadedClassCount(), info.hashCodeStr(), info.parentStr()});
        }
        return table;
    }

    private static TableElement renderStat(Map<String, ClassLoaderStat> classLoaderStats) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.bold()).add(new String[]{"name", "numberOfInstances", "loadedCountTotal"}));
        for (Map.Entry<String, ClassLoaderStat> entry : classLoaderStats.entrySet()) {
            table.row(new String[]{entry.getKey(), "" + entry.getValue().getNumberOfInstance(), "" + entry.getValue().getLoadedCount()});
        }
        return table;
    }

    private static void renderParent(TreeElement node, ClassLoaderInfo parent, List<ClassLoaderInfo> classLoaderInfos) {
        for (ClassLoaderInfo info : classLoaderInfos) {
            if (info.parent() != parent.classLoader) continue;
            TreeElement child = new TreeElement(info.getName());
            node.addChild((Element)child);
            ClassLoaderCommand.renderParent(child, info, classLoaderInfos);
        }
    }

    private static Set<ClassLoader> getAllClassLoader(Instrumentation inst, Filter ... filters) {
        HashSet<ClassLoader> classLoaderSet = new HashSet<ClassLoader>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null || !ClassLoaderCommand.shouldInclude(classLoader, filters)) continue;
            classLoaderSet.add(classLoader);
        }
        return classLoaderSet;
    }

    private static List<ClassLoaderInfo> getAllClassLoaderInfo(Instrumentation inst, Filter ... filters) {
        ClassLoader classLoader;
        ClassLoaderInfo bootstrapInfo = new ClassLoaderInfo(null);
        HashMap<ClassLoader, ClassLoaderInfo> loaderInfos = new HashMap<ClassLoader, ClassLoaderInfo>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                bootstrapInfo.increase();
                continue;
            }
            if (!ClassLoaderCommand.shouldInclude(classLoader, filters)) continue;
            ClassLoaderInfo loaderInfo = (ClassLoaderInfo)loaderInfos.get(classLoader);
            if (loaderInfo == null) {
                loaderInfo = new ClassLoaderInfo(classLoader);
                loaderInfos.put(classLoader, loaderInfo);
                for (ClassLoader parent = classLoader.getParent(); parent != null; parent = parent.getParent()) {
                    ClassLoaderInfo parentLoaderInfo = (ClassLoaderInfo)loaderInfos.get(parent);
                    if (parentLoaderInfo != null) continue;
                    parentLoaderInfo = new ClassLoaderInfo(parent);
                    loaderInfos.put(parent, parentLoaderInfo);
                }
            }
            loaderInfo.increase();
        }
        ArrayList sunClassLoaderList = new ArrayList();
        ArrayList otherClassLoaderList = new ArrayList();
        for (Map.Entry entry : loaderInfos.entrySet()) {
            classLoader = (ClassLoader)entry.getKey();
            if (classLoader.getClass().getName().startsWith("sun.")) {
                sunClassLoaderList.add(entry.getValue());
                continue;
            }
            otherClassLoaderList.add(entry.getValue());
        }
        Collections.sort(sunClassLoaderList);
        Collections.sort(otherClassLoaderList);
        ArrayList<ClassLoaderInfo> result = new ArrayList<ClassLoaderInfo>();
        result.add(bootstrapInfo);
        result.addAll(otherClassLoaderList);
        result.addAll(sunClassLoaderList);
        return result;
    }

    private static boolean shouldInclude(ClassLoader classLoader, Filter ... filters) {
        if (filters == null) {
            return true;
        }
        for (Filter filter : filters) {
            if (filter.accept(classLoader)) continue;
            return false;
        }
        return true;
    }

    private static class ValueComparator
    implements Comparator<String> {
        private Map<String, ClassLoaderStat> unsortedStats;

        ValueComparator(Map<String, ClassLoaderStat> stats) {
            this.unsortedStats = stats;
        }

        @Override
        public int compare(String o1, String o2) {
            if (null == this.unsortedStats) {
                return -1;
            }
            if (!this.unsortedStats.containsKey(o1)) {
                return 1;
            }
            if (!this.unsortedStats.containsKey(o2)) {
                return -1;
            }
            return this.unsortedStats.get(o2).getLoadedCount() - this.unsortedStats.get(o1).getLoadedCount();
        }
    }

    private static class ClassLoaderStat {
        private int loadedCount;
        private int numberOfInstance;

        private ClassLoaderStat() {
        }

        void addLoadedCount(int count) {
            this.loadedCount += count;
        }

        void addNumberOfInstance(int count) {
            this.numberOfInstance += count;
        }

        int getLoadedCount() {
            return this.loadedCount;
        }

        int getNumberOfInstance() {
            return this.numberOfInstance;
        }
    }

    private static class SunReflectionClassLoaderFilter
    implements Filter {
        private static final String REFLECTION_CLASSLOADER = "sun.reflect.DelegatingClassLoader";

        private SunReflectionClassLoaderFilter() {
        }

        @Override
        public boolean accept(ClassLoader classLoader) {
            return !REFLECTION_CLASSLOADER.equals(classLoader.getClass().getName());
        }
    }

    private static interface Filter {
        public boolean accept(ClassLoader var1);
    }

    private static class ClassLoaderInfo
    implements Comparable<ClassLoaderInfo> {
        private ClassLoader classLoader;
        private int loadedClassCount = 0;

        ClassLoaderInfo(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public String getName() {
            if (this.classLoader != null) {
                return this.classLoader.toString();
            }
            return "BootstrapClassLoader";
        }

        String hashCodeStr() {
            if (this.classLoader != null) {
                return "" + Integer.toHexString(this.classLoader.hashCode());
            }
            return "null";
        }

        void increase() {
            ++this.loadedClassCount;
        }

        int loadedClassCount() {
            return this.loadedClassCount;
        }

        ClassLoader parent() {
            return this.classLoader == null ? null : this.classLoader.getParent();
        }

        String parentStr() {
            if (this.classLoader == null) {
                return "null";
            }
            ClassLoader parent = this.classLoader.getParent();
            if (parent == null) {
                return "null";
            }
            return parent.toString();
        }

        @Override
        public int compareTo(ClassLoaderInfo other) {
            if (other == null) {
                return -1;
            }
            if (other.classLoader == null) {
                return -1;
            }
            if (this.classLoader == null) {
                return -1;
            }
            return this.classLoader.getClass().getName().compareTo(other.classLoader.getClass().getName());
        }
    }
}

