/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class IPUtils {
    public static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    public static String getLocalIP() {
        String sIP = null;
        InetAddress ip = null;
        try {
            if (IPUtils.isWindowsOS()) {
                ip = InetAddress.getLocalHost();
            } else if (!InetAddress.getLocalHost().isLoopbackAddress()) {
                ip = InetAddress.getLocalHost();
            } else {
                boolean bFindIP = false;
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                block2: while (netInterfaces.hasMoreElements() && !bFindIP) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        ip = ips.nextElement();
                        if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                        bFindIP = true;
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ip != null) {
            sIP = ip.getHostAddress();
        }
        return sIP;
    }

    public static void main(String[] args) {
        System.out.println(IPUtils.getLocalIP());
    }
}

