/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.core.shell.ShellServerOptions;
import com.taobao.arthas.core.util.IOUtils;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.middleware.logger.Logger;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.io.IOException;

public class ArthasBanner {
    private static final String LOGO_LOCATION = "/com/taobao/arthas/core/res/logo.txt";
    private static final String CREDIT_LOCATION = "/com/taobao/arthas/core/res/thanks.txt";
    private static final String VERSION_LOCATION = "/com/taobao/arthas/core/res/version";
    private static final String WIKI = "middleware-container/arthas/wikis/home";
    private static String LOGO = "Welcome to Arthas";
    private static String VERSION = "unknown";
    private static String THANKS = "";
    private static final Logger logger = LogUtil.getArthasLogger();

    public static String wiki() {
        return WIKI;
    }

    public static String credit() {
        return THANKS;
    }

    public static String version() {
        return VERSION;
    }

    public static String logo() {
        return LOGO;
    }

    public static String plainTextLogo() {
        return RenderUtil.ansiToPlainText((String)LOGO);
    }

    public static String welcome() {
        logger.info("arthas version: " + ArthasBanner.version());
        return ArthasBanner.logo() + "\nwiki: " + ArthasBanner.wiki() + "\nversion: " + ArthasBanner.version();
    }

    static {
        try {
            String logoText = IOUtils.toString(ShellServerOptions.class.getResourceAsStream(LOGO_LOCATION));
            THANKS = IOUtils.toString(ShellServerOptions.class.getResourceAsStream(CREDIT_LOCATION));
            VERSION = IOUtils.toString(ShellServerOptions.class.getResourceAsStream(VERSION_LOCATION));
            StringBuilder sb = new StringBuilder();
            String[] LOGOS = new String[6];
            int i = 0;
            int j = 0;
            for (String line : logoText.split("\n")) {
                sb.append(line);
                sb.append("\n");
                if (i++ != 4) continue;
                LOGOS[j++] = sb.toString();
                i = 0;
                sb.setLength(0);
            }
            TableElement logoTable = new TableElement();
            logoTable.row(new Element[]{Element.label((String)LOGOS[0]).style(Decoration.bold.fg(Color.red)), Element.label((String)LOGOS[1]).style(Decoration.bold.fg(Color.yellow)), Element.label((String)LOGOS[2]).style(Decoration.bold.fg(Color.cyan)), Element.label((String)LOGOS[3]).style(Decoration.bold.fg(Color.magenta)), Element.label((String)LOGOS[4]).style(Decoration.bold.fg(Color.green)), Element.label((String)LOGOS[5]).style(Decoration.bold.fg(Color.blue))});
            LOGO = RenderUtil.render((Element)logoTable);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

