/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.cli;

import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.term.Tty;
import com.taobao.arthas.core.util.usage.StyledUsageFormatter;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.annotations.CLIConfigurator;
import io.termd.core.util.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CompletionUtils {
    public static String findLongestCommonPrefix(Collection<String> values) {
        LinkedList<int[]> entries = new LinkedList<int[]>();
        for (String value : values) {
            int[] entry = Helper.toCodePoints((String)value);
            entries.add(entry);
        }
        return Helper.fromCodePoints((int[])io.termd.core.readline.Completion.findLongestCommonPrefix(entries));
    }

    public static void complete(Completion completion, Class<?> clazz) {
        List<CliToken> tokens = completion.lineTokens();
        CliToken lastToken = tokens.get(tokens.size() - 1);
        CLI cli = CLIConfigurator.define(clazz);
        List options = cli.getOptions();
        if (lastToken == null || lastToken.isBlank()) {
            CompletionUtils.completeUsage(completion, cli);
        } else if (lastToken.value().startsWith("--")) {
            CompletionUtils.completeLongOption(completion, lastToken, options);
        } else if (lastToken.value().startsWith("-")) {
            CompletionUtils.completeShortOption(completion, lastToken, options);
        } else {
            completion.complete(Collections.<String>emptyList());
        }
    }

    public static boolean complete(Completion completion, Collection<String> searchScope) {
        List<CliToken> tokens = completion.lineTokens();
        CliToken lastToken = tokens.get(tokens.size() - 1);
        ArrayList<String> candidates = new ArrayList<String>();
        for (String name : searchScope) {
            if (!" ".equals(lastToken.value()) && !name.startsWith(lastToken.value())) continue;
            candidates.add(name);
        }
        if (candidates.size() == 1) {
            completion.complete(((String)candidates.get(0)).substring(lastToken.value().length()), true);
            return true;
        }
        completion.complete(candidates);
        return false;
    }

    public static void completeShortOption(Completion completion, CliToken lastToken, List<Option> options) {
        String prefix = lastToken.value().substring(1);
        ArrayList<String> candidates = new ArrayList<String>();
        for (Option option : options) {
            if (!option.getShortName().startsWith(prefix)) continue;
            candidates.add(option.getShortName());
        }
        CompletionUtils.complete(completion, prefix, candidates);
    }

    public static void completeLongOption(Completion completion, CliToken lastToken, List<Option> options) {
        String prefix = lastToken.value().substring(2);
        ArrayList<String> candidates = new ArrayList<String>();
        for (Option option : options) {
            if (!option.getLongName().startsWith(prefix)) continue;
            candidates.add(option.getLongName());
        }
        CompletionUtils.complete(completion, prefix, candidates);
    }

    public static void completeUsage(Completion completion, CLI cli) {
        Tty tty = (Tty)completion.session().get("tty");
        String usage = StyledUsageFormatter.styledUsage(cli, tty.width());
        completion.complete(Collections.singletonList(usage));
    }

    private static void complete(Completion completion, String prefix, List<String> candidates) {
        if (candidates.size() == 1) {
            completion.complete(candidates.get(0).substring(prefix.length()), true);
        } else {
            String commonPrefix = CompletionUtils.findLongestCommonPrefix(candidates);
            if (commonPrefix.length() > 0) {
                completion.complete(commonPrefix, false);
            } else {
                completion.complete(candidates);
            }
        }
    }
}

