/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core;

import com.taobao.arthas.core.config.Configure;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CLIs;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.TypedOption;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class Arthas {
    private static final String DEFAULT_TELNET_PORT = "3658";
    private static final String DEFAULT_HTTP_PORT = "8563";

    private Arthas(String[] args) throws Exception {
        this.attachAgent(this.parse(args));
    }

    private Configure parse(String[] args) {
        TypedOption pid = new TypedOption().setType(Integer.class).setShortName("pid").setRequired(true);
        TypedOption core = new TypedOption().setType(String.class).setShortName("core").setRequired(true);
        TypedOption agent = new TypedOption().setType(String.class).setShortName("agent").setRequired(true);
        TypedOption target = new TypedOption().setType(String.class).setShortName("target-ip");
        TypedOption telnetPort = new TypedOption().setType(Integer.class).setShortName("telnet-port").setDefaultValue(DEFAULT_TELNET_PORT);
        TypedOption httpPort = new TypedOption().setType(Integer.class).setShortName("http-port").setDefaultValue(DEFAULT_HTTP_PORT);
        CLI cli = CLIs.create((String)"arthas").addOption((Option)pid).addOption((Option)core).addOption((Option)agent).addOption((Option)target).addOption((Option)telnetPort).addOption((Option)httpPort);
        CommandLine commandLine = cli.parse(Arrays.asList(args));
        Configure configure = new Configure();
        configure.setJavaPid((Integer)commandLine.getOptionValue("pid"));
        configure.setArthasAgent((String)commandLine.getOptionValue("agent"));
        configure.setArthasCore((String)commandLine.getOptionValue("core"));
        if (commandLine.getOptionValue("target-ip") == null) {
            throw new IllegalStateException("as.sh is too old to support web console, please run the following command to upgrade to latest version:\ncurl -sLk http://arthas.io/arthas/install.sh | sh");
        }
        configure.setIp((String)commandLine.getOptionValue("target-ip"));
        configure.setTelnetPort((Integer)commandLine.getOptionValue("telnet-port"));
        configure.setHttpPort((Integer)commandLine.getOptionValue("http-port"));
        return configure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void attachAgent(Configure configure) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> vmdClass = loader.loadClass("com.sun.tools.attach.VirtualMachineDescriptor");
        Class<?> vmClass = loader.loadClass("com.sun.tools.attach.VirtualMachine");
        Object attachVmdObj = null;
        for (Object obj : (List)vmClass.getMethod("list", null).invoke(null, (Object[])null)) {
            Object pid = vmdClass.getMethod("id", null).invoke(obj, (Object[])null);
            if (!pid.equals(Integer.toString(configure.getJavaPid()))) continue;
            attachVmdObj = obj;
        }
        Object vmObj = null;
        try {
            vmObj = null == attachVmdObj ? vmClass.getMethod("attach", String.class).invoke(null, "" + configure.getJavaPid()) : vmClass.getMethod("attach", vmdClass).invoke(null, attachVmdObj);
            Method loadAgent = vmClass.getMethod("loadAgent", String.class, String.class);
            loadAgent.invoke(vmObj, configure.getArthasAgent(), configure.getArthasCore() + ";" + configure.toString());
            if (null == vmObj) return;
        }
        catch (Throwable throwable) {
            if (null == vmObj) throw throwable;
            vmClass.getMethod("detach", null).invoke(vmObj, (Object[])null);
            throw throwable;
        }
        vmClass.getMethod("detach", null).invoke(vmObj, (Object[])null);
    }

    public static void main(String[] args) {
        try {
            new Arthas(args);
        }
        catch (Throwable t) {
            System.err.println("Start arthas failed, exception stack trace: ");
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

