/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.common;

import com.taobao.arthas.common.ExecutingCommand;
import com.taobao.arthas.common.OSUtils;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ServerSocketFactory;

public class SocketUtils {
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    private static final Random random = new Random(System.currentTimeMillis());

    private SocketUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long findTcpListenProcess(final int port) {
        int TIMEOUT_SECONDS = 5;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Long> future = executor.submit(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return SocketUtils.doFindTcpListenProcess(port);
                }
            });
            try {
                long l = future.get(5L, TimeUnit.SECONDS);
                return l;
            }
            catch (TimeoutException e) {
                future.cancel(true);
                long l = -1L;
                executor.shutdownNow();
                return l;
            }
            catch (Exception e) {
                long l = -1L;
                executor.shutdownNow();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                return l;
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static long doFindTcpListenProcess(int port) {
        try {
            if (OSUtils.isWindows()) {
                return SocketUtils.findTcpListenProcessOnWindows(port);
            }
            if (OSUtils.isLinux() || OSUtils.isMac()) {
                return SocketUtils.findTcpListenProcessOnUnix(port);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    private static long findTcpListenProcessOnWindows(int port) {
        String[] command = new String[]{"netstat", "-ano", "-p", "TCP"};
        List<String> lines = ExecutingCommand.runNative(command);
        for (String line : lines) {
            String[] strings;
            if (!line.contains("LISTENING") || (strings = line.trim().split("\\s+")).length != 5 || !strings[1].endsWith(":" + port)) continue;
            return Long.parseLong(strings[4]);
        }
        return -1L;
    }

    private static long findTcpListenProcessOnUnix(int port) {
        String pid = ExecutingCommand.getFirstAnswer("lsof -t -s TCP:LISTEN -i TCP:" + port);
        if (pid != null && !pid.trim().isEmpty()) {
            try {
                return Long.parseLong(pid.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static boolean isTcpPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static int findAvailableTcpPort() {
        return SocketUtils.findAvailableTcpPort(1024);
    }

    public static int findAvailableTcpPort(int minPort) {
        return SocketUtils.findAvailableTcpPort(minPort, 65535);
    }

    public static int findAvailableTcpPort(int minPort, int maxPort) {
        return SocketUtils.findAvailablePort(minPort, maxPort);
    }

    private static int findAvailablePort(int minPort, int maxPort) {
        int candidatePort;
        int portRange = maxPort - minPort;
        int searchCounter = 0;
        do {
            if (searchCounter > portRange) {
                throw new IllegalStateException(String.format("Could not find an available tcp port in the range [%d, %d] after %d attempts", minPort, maxPort, searchCounter));
            }
            candidatePort = SocketUtils.findRandomPort(minPort, maxPort);
            ++searchCounter;
        } while (!SocketUtils.isTcpPortAvailable(candidatePort));
        return candidatePort;
    }

    private static int findRandomPort(int minPort, int maxPort) {
        int portRange = maxPort - minPort;
        return minPort + random.nextInt(portRange + 1);
    }
}

