/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IOUtils {
    public static String toString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static IOException close(InputStream input) {
        return IOUtils.close((Closeable)input);
    }

    public static IOException close(OutputStream output) {
        return IOUtils.close((Closeable)output);
    }

    public static IOException close(Reader input) {
        return IOUtils.close((Closeable)input);
    }

    public static IOException close(Writer output) {
        return IOUtils.close((Closeable)output);
    }

    public static IOException close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            return ioe;
        }
        return null;
    }

    public static IOException close(ZipFile zip) {
        try {
            if (zip != null) {
                zip.close();
            }
        }
        catch (IOException ioe) {
            return ioe;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(String zipFile, String extractFolder) throws IOException {
        File file = new File(zipFile);
        ZipFile zip = null;
        try {
            int BUFFER = 8192;
            zip = new ZipFile(file);
            String newPath = extractFolder;
            new File(newPath).mkdir();
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(newPath, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = null;
                BufferedOutputStream dest = null;
                try {
                    int currentByte;
                    is = new BufferedInputStream(zip.getInputStream(entry));
                    byte[] data = new byte[BUFFER];
                    FileOutputStream fos = new FileOutputStream(destFile);
                    dest = new BufferedOutputStream(fos, BUFFER);
                    while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                        dest.write(data, 0, currentByte);
                    }
                    dest.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.close(dest);
                    IOUtils.close(is);
                    throw throwable;
                }
                IOUtils.close(dest);
                IOUtils.close(is);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(zip);
            throw throwable;
        }
        IOUtils.close(zip);
    }
}

