/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.client;

import com.taobao.middleware.cli.Argument;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CLIs;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.TypedOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;

public class TelnetConsole {
    private static final String PROMPT = "$";
    private static final String DEFAULT_TELNET_PORT = "3658";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final String DEFAULT_WINDOW_WIDTH = "120";
    private static final String DEFAULT_WINDOW_HEIGHT = "40";
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private TelnetClient telnet = new TelnetClient();
    private String address;
    private int port;
    private InputStream in;
    private PrintStream out;

    public TelnetConsole(String address, int port, int width, int height) {
        this.address = address;
        this.port = port;
        try {
            this.telnet.addOptionHandler(new WindowSizeOptionHandler(width, height, true, false, true, false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.telnet.setConnectTimeout(5000);
    }

    public void connect() {
        try {
            this.telnet.connect(this.address, this.port);
            this.in = this.telnet.getInputStream();
            this.out = new PrintStream(this.telnet.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String readUntil(String prompt) {
        try {
            StringBuilder sBuffer = new StringBuilder();
            byte[] b = new byte[1024];
            while (true) {
                int size;
                if (-1 == (size = this.in.read(b))) {
                    continue;
                }
                sBuffer.append(new String(b, 0, size));
                String data = sBuffer.toString();
                if (data.trim().endsWith(prompt)) break;
            }
            return sBuffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String readUntilPrompt() {
        return this.readUntil(PROMPT);
    }

    public void write(String value) {
        try {
            this.out.println(value);
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCommand(String command) {
        try {
            this.write(command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        try {
            this.telnet.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void batchModeRun(File batchFile) {
        if (batchFile == null || !batchFile.exists()) {
            return;
        }
        this.batchModeRun(this.readLines(batchFile));
    }

    private void batchModeRun(List<String> commands) {
        for (String command : commands) {
            this.sendCommand(command + " | plaintext");
            String response = this.readUntilPrompt();
            System.out.print(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readLines(File batchFile) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(batchFile));
            String line = br.readLine();
            while (line != null) {
                list.add(line);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    public static void main(String[] args) {
        try {
            String filePath;
            if (args.length < 1) {
                System.err.println("Usage: TelnetConsole <target-ip> [-p PORT] [-c COMMAND] [-f BATCH_FILE] [-w WIDTH] [-h HEIGHT]");
                System.exit(1);
            }
            CommandLine commandLine = TelnetConsole.parseArguments(args);
            TelnetConsole console = new TelnetConsole((String)commandLine.getArgumentValue("target-ip"), (Integer)commandLine.getOptionValue("p"), (Integer)commandLine.getOptionValue("w"), (Integer)commandLine.getOptionValue("h"));
            console.connect();
            String logo = console.readUntilPrompt();
            System.out.print(logo);
            String cmd = (String)commandLine.getOptionValue("c");
            if (cmd != null) {
                ArrayList<String> cmds = new ArrayList<String>();
                for (String c : cmd.split(";")) {
                    cmds.add(c.trim());
                }
                console.batchModeRun(cmds);
            }
            if ((filePath = (String)commandLine.getOptionValue("f")) != null) {
                File batchFile = new File(filePath);
                console.batchModeRun(batchFile);
            }
            console.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static CommandLine parseArguments(String[] args) {
        Argument addr = new Argument().setArgName("target-ip").setIndex(0).setRequired(true);
        TypedOption port = new TypedOption().setType(Integer.class).setShortName("p").setDefaultValue(DEFAULT_TELNET_PORT);
        TypedOption command = new TypedOption().setType(String.class).setShortName("c");
        TypedOption batchFileOption = new TypedOption().setType(String.class).setShortName("f");
        TypedOption width = new TypedOption().setType(Integer.class).setShortName("w").setDefaultValue(DEFAULT_WINDOW_WIDTH);
        TypedOption height = new TypedOption().setType(Integer.class).setShortName("h").setDefaultValue(DEFAULT_WINDOW_HEIGHT);
        CLI cli = CLIs.create((String)"TelnetConsole").addArgument(addr).addOption((Option)port).addOption((Option)command).addOption((Option)batchFileOption).addOption((Option)width).addOption((Option)height);
        return cli.parse(Arrays.asList(args));
    }
}

