/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.boot;

import com.taobao.arthas.boot.DownloadUtils;
import com.taobao.arthas.boot.ProcessUtils;
import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.JavaVersionUtils;
import com.taobao.arthas.common.SocketUtils;
import com.taobao.arthas.common.UsageRender;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.UsageMessageFormatter;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.CLIConfigurator;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.InputMismatchException;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

@Name(value="arthas-boot")
@Summary(value="Bootstrap Arthas")
@Description(value="EXAMPLES:\n  java -jar arthas-boot.jar <pid>\n  java -jar arthas-boot.jar --target-ip 0.0.0.0\n  java -jar arthas-boot.jar --telnet-port 9999 --http-port -1\n  java -jar arthas-boot.jar -c 'sysprop; thread' <pid>\n  java -jar arthas-boot.jar -f batch.as <pid>\n  java -jar arthas-boot.jar --use-version 3.1.2\n  java -jar arthas-boot.jar --versions\n  java -jar arthas-boot.jar --session-timeout 3600\n  java -jar arthas-boot.jar --attach-only\n  java -jar arthas-boot.jar --repo-mirror aliyun --use-http\nWIKI:\n  https://alibaba.github.io/arthas\n")
public class Bootstrap {
    private static final int DEFAULT_TELNET_PORT = 3658;
    private static final int DEFAULT_HTTP_PORT = 8563;
    private static final String DEFAULT_TARGET_IP = "127.0.0.1";
    private static File ARTHAS_LIB_DIR = new File(System.getProperty("user.home") + File.separator + ".arthas" + File.separator + "lib");
    private boolean help = false;
    private int pid = -1;
    private String targetIp = "127.0.0.1";
    private int telnetPort = 3658;
    private int httpPort = 8563;
    private Long sessionTimeout;
    private Integer height = null;
    private Integer width = null;
    private boolean verbose = false;
    private String arthasHome;
    private String useVersion;
    private boolean versions;
    private String repoMirror;
    private boolean useHttp = false;
    private boolean attachOnly = false;
    private String command;
    private String batchFile;
    private String tunnelServer;
    private String agentId;

    @Argument(argName="pid", index=0, required=false)
    @Description(value="Target pid")
    public void setPid(int pid) {
        this.pid = pid;
    }

    @Option(shortName="h", longName="help", flag=true)
    @Description(value="Print usage")
    public void setHelp(boolean help) {
        this.help = help;
    }

    @Option(longName="target-ip")
    @Description(value="The target jvm listen ip, default 127.0.0.1")
    public void setTargetIp(String targetIp) {
        this.targetIp = targetIp;
    }

    @Option(longName="telnet-port")
    @Description(value="The target jvm listen telnet port, default 3658")
    public void setTelnetPort(int telnetPort) {
        this.telnetPort = telnetPort;
    }

    @Option(longName="http-port")
    @Description(value="The target jvm listen http port, default 8563")
    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    @Option(longName="session-timeout")
    @Description(value="The session timeout seconds, default 1800 (30min)")
    public void setSessionTimeout(Long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Option(longName="arthas-home")
    @Description(value="The arthas home")
    public void setArthasHome(String arthasHome) {
        this.arthasHome = arthasHome;
    }

    @Option(longName="use-version")
    @Description(value="Use special version arthas")
    public void setUseVersion(String useVersion) {
        this.useVersion = useVersion;
    }

    @Option(longName="repo-mirror")
    @Description(value="Use special maven repository mirror, value is center/aliyun or http repo url.")
    public void setRepoMirror(String repoMirror) {
        this.repoMirror = repoMirror;
    }

    @Option(longName="versions", flag=true)
    @Description(value="List local and remote arthas versions")
    public void setVersions(boolean versions) {
        this.versions = versions;
    }

    @Option(longName="use-http", flag=true)
    @Description(value="Enforce use http to download, default use https")
    public void setuseHttp(boolean useHttp) {
        this.useHttp = useHttp;
    }

    @Option(longName="attach-only", flag=true)
    @Description(value="Attach target process only, do not connect")
    public void setAttachOnly(boolean attachOnly) {
        this.attachOnly = attachOnly;
    }

    @Option(shortName="c", longName="command")
    @Description(value="Command to execute, multiple commands separated by ;")
    public void setCommand(String command) {
        this.command = command;
    }

    @Option(shortName="f", longName="batch-file")
    @Description(value="The batch file to execute")
    public void setBatchFile(String batchFile) {
        this.batchFile = batchFile;
    }

    @Option(longName="height")
    @Description(value="arthas-client terminal height")
    public void setHeight(int height) {
        this.height = height;
    }

    @Option(longName="width")
    @Description(value="arthas-client terminal width")
    public void setWidth(int width) {
        this.width = width;
    }

    @Option(shortName="v", longName="verbose", flag=true)
    @Description(value="Verbose, print debug info.")
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Option(longName="tunnel-server")
    @Description(value="The tunnel server url")
    public void setTunnelServer(String tunnelServer) {
        this.tunnelServer = tunnelServer;
    }

    @Option(longName="agent-id")
    @Description(value="The agent id register to tunnel server")
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        CodeSource codeSource;
        int pid;
        String arthasBootVersion;
        Package bootstrapPackage = Bootstrap.class.getPackage();
        if (bootstrapPackage != null && (arthasBootVersion = bootstrapPackage.getImplementationVersion()) != null) {
            AnsiLog.info((String)("arthas-boot version: " + arthasBootVersion));
        }
        String mavenMetaData = null;
        Bootstrap bootstrap = new Bootstrap();
        CLI cli = CLIConfigurator.define(Bootstrap.class);
        CommandLine commandLine = cli.parse(Arrays.asList(args));
        try {
            CLIConfigurator.inject((CommandLine)commandLine, (Object)bootstrap);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(Bootstrap.usage(cli));
            System.exit(1);
        }
        if (bootstrap.isVerbose()) {
            AnsiLog.level((Level)Level.ALL);
        }
        if (bootstrap.isHelp()) {
            System.out.println(Bootstrap.usage(cli));
            System.exit(0);
        }
        if (bootstrap.getRepoMirror() == null || bootstrap.getRepoMirror().trim().isEmpty()) {
            bootstrap.setRepoMirror("center");
            if (TimeUnit.MILLISECONDS.toHours(TimeZone.getDefault().getOffset(System.currentTimeMillis())) == 8L) {
                bootstrap.setRepoMirror("aliyun");
            }
        }
        AnsiLog.debug((String)("Repo mirror:" + bootstrap.getRepoMirror()));
        if (bootstrap.isVersions()) {
            if (mavenMetaData == null) {
                mavenMetaData = DownloadUtils.readMavenMetaData(bootstrap.getRepoMirror(), bootstrap.isuseHttp());
            }
            System.out.println(UsageRender.render((String)Bootstrap.listVersions(mavenMetaData)));
            System.exit(0);
        }
        if (JavaVersionUtils.isJava6() || JavaVersionUtils.isJava7()) {
            bootstrap.setuseHttp(true);
            AnsiLog.debug((String)"Java version is {}, only support http, set useHttp to true.", (Object[])new Object[]{JavaVersionUtils.javaVersionStr()});
        }
        int telnetPortPid = -1;
        int httpPortPid = -1;
        if (bootstrap.getTelnetPort() > 0 && (telnetPortPid = SocketUtils.findTcpListenProcess((int)bootstrap.getTelnetPort())) > 0) {
            AnsiLog.info((String)"Process {} already using port {}", (Object[])new Object[]{telnetPortPid, bootstrap.getTelnetPort()});
        }
        if (bootstrap.getHttpPort() > 0 && (httpPortPid = SocketUtils.findTcpListenProcess((int)bootstrap.getHttpPort())) > 0) {
            AnsiLog.info((String)"Process {} already using port {}", (Object[])new Object[]{httpPortPid, bootstrap.getHttpPort()});
        }
        if ((pid = bootstrap.getPid()) < 0) {
            try {
                pid = ProcessUtils.select(bootstrap.isVerbose(), telnetPortPid);
            }
            catch (InputMismatchException e) {
                System.out.println("Please input an integer to select pid.");
                System.exit(1);
            }
            if (pid < 0) {
                System.out.println("Please select an available pid.");
                System.exit(1);
            }
        }
        if (telnetPortPid > 0 && pid != telnetPortPid) {
            AnsiLog.error((String)"Target process {} is not the process using port {}, you will connect to an unexpected process.", (Object[])new Object[]{pid, bootstrap.getTelnetPort()});
            AnsiLog.error((String)"1. Try to restart arthas-boot, select process {}, shutdown it first with running the 'shutdown' command.", (Object[])new Object[]{telnetPortPid});
            AnsiLog.error((String)"2. Or try to use different telnet port, for example: java -jar arthas-boot.jar --telnet-port 9998 --http-port -1");
            System.exit(1);
        }
        if (httpPortPid > 0 && pid != httpPortPid) {
            AnsiLog.error((String)"Target process {} is not the process using port {}, you will connect to an unexpected process.", (Object[])new Object[]{pid, bootstrap.getHttpPort()});
            AnsiLog.error((String)"1. Try to restart arthas-boot, select process {}, shutdown it first with running the 'shutdown' command.", (Object[])new Object[]{httpPortPid});
            AnsiLog.error((String)"2. Or try to use different http port, for example: java -jar arthas-boot.jar --telnet-port 9998 --http-port 9999", (Object[])new Object[]{httpPortPid});
            System.exit(1);
        }
        File arthasHomeDir = null;
        if (bootstrap.getArthasHome() != null) {
            Bootstrap.verifyArthasHome(bootstrap.getArthasHome());
            arthasHomeDir = new File(bootstrap.getArthasHome());
        }
        if (arthasHomeDir == null && bootstrap.getUseVersion() != null) {
            File specialVersionDir = new File(System.getProperty("user.home"), ".arthas" + File.separator + "lib" + File.separator + bootstrap.getUseVersion() + File.separator + "arthas");
            if (!specialVersionDir.exists()) {
                DownloadUtils.downArthasPackaging(bootstrap.getRepoMirror(), bootstrap.isuseHttp(), bootstrap.getUseVersion(), ARTHAS_LIB_DIR.getAbsolutePath());
            }
            Bootstrap.verifyArthasHome(specialVersionDir.getAbsolutePath());
            arthasHomeDir = specialVersionDir;
        }
        if (arthasHomeDir == null && (codeSource = Bootstrap.class.getProtectionDomain().getCodeSource()) != null) {
            try {
                File bootJarPath = new File(codeSource.getLocation().toURI().getSchemeSpecificPart());
                Bootstrap.verifyArthasHome(bootJarPath.getParent());
                arthasHomeDir = bootJarPath.getParentFile();
            }
            catch (Throwable bootJarPath) {
                // empty catch block
            }
        }
        if (arthasHomeDir == null) {
            boolean checkFile;
            boolean bl = checkFile = ARTHAS_LIB_DIR.exists() || ARTHAS_LIB_DIR.mkdirs();
            if (!checkFile) {
                AnsiLog.error((String)"cannot create directory {}: maybe permission denied", (Object[])new Object[]{ARTHAS_LIB_DIR.getAbsolutePath()});
                System.exit(1);
            }
            List<String> versionList = Bootstrap.listNames(ARTHAS_LIB_DIR);
            Collections.sort(versionList);
            String localLastestVersion = null;
            if (!versionList.isEmpty()) {
                localLastestVersion = versionList.get(versionList.size() - 1);
            }
            if (mavenMetaData == null) {
                mavenMetaData = DownloadUtils.readMavenMetaData(bootstrap.getRepoMirror(), bootstrap.isuseHttp());
            }
            String remoteLastestVersion = DownloadUtils.readMavenReleaseVersion(mavenMetaData);
            boolean needDownload = false;
            if (localLastestVersion == null) {
                if (remoteLastestVersion == null) {
                    AnsiLog.error((String)"Can not find Arthas under local: {} and remote: {}", (Object[])new Object[]{ARTHAS_LIB_DIR, bootstrap.getRepoMirror()});
                    System.exit(1);
                } else {
                    needDownload = true;
                }
            } else if (remoteLastestVersion != null && localLastestVersion.compareTo(remoteLastestVersion) < 0) {
                AnsiLog.info((String)"local lastest version: {}, remote lastest version: {}, try to download from remote.", (Object[])new Object[]{localLastestVersion, remoteLastestVersion});
                needDownload = true;
            }
            if (needDownload) {
                DownloadUtils.downArthasPackaging(bootstrap.getRepoMirror(), bootstrap.isuseHttp(), remoteLastestVersion, ARTHAS_LIB_DIR.getAbsolutePath());
                localLastestVersion = remoteLastestVersion;
            }
            arthasHomeDir = new File(ARTHAS_LIB_DIR, localLastestVersion + File.separator + "arthas");
        }
        Bootstrap.verifyArthasHome(arthasHomeDir.getAbsolutePath());
        AnsiLog.info((String)("arthas home: " + arthasHomeDir));
        if (telnetPortPid > 0 && pid == telnetPortPid) {
            AnsiLog.info((String)"The target process already listen port {}, skip attach.", (Object[])new Object[]{bootstrap.getTelnetPort()});
        } else {
            ArrayList<String> attachArgs = new ArrayList<String>();
            attachArgs.add("-jar");
            attachArgs.add(new File(arthasHomeDir, "arthas-core.jar").getAbsolutePath());
            attachArgs.add("-pid");
            attachArgs.add("" + pid);
            attachArgs.add("-target-ip");
            attachArgs.add(bootstrap.getTargetIp());
            attachArgs.add("-telnet-port");
            attachArgs.add("" + bootstrap.getTelnetPort());
            attachArgs.add("-http-port");
            attachArgs.add("" + bootstrap.getHttpPort());
            attachArgs.add("-core");
            attachArgs.add(new File(arthasHomeDir, "arthas-core.jar").getAbsolutePath());
            attachArgs.add("-agent");
            attachArgs.add(new File(arthasHomeDir, "arthas-agent.jar").getAbsolutePath());
            if (bootstrap.getSessionTimeout() != null) {
                attachArgs.add("-session-timeout");
                attachArgs.add("" + bootstrap.getSessionTimeout());
            }
            if (bootstrap.getTunnelServer() != null) {
                attachArgs.add("-tunnel-server");
                attachArgs.add(bootstrap.getTunnelServer());
            }
            if (bootstrap.getAgentId() != null) {
                attachArgs.add("-agent-id");
                attachArgs.add(bootstrap.getAgentId());
            }
            AnsiLog.info((String)("Try to attach process " + pid));
            AnsiLog.debug((String)("Start arthas-core.jar args: " + attachArgs));
            ProcessUtils.startArthasCore(pid, attachArgs);
            AnsiLog.info((String)"Attach process {} success.", (Object[])new Object[]{pid});
        }
        if (bootstrap.isAttachOnly()) {
            System.exit(0);
        }
        URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(arthasHomeDir, "arthas-client.jar").toURI().toURL()});
        Class<?> telnetConsoleClas = classLoader.loadClass("com.taobao.arthas.client.TelnetConsole");
        Method mainMethod = telnetConsoleClas.getMethod("main", String[].class);
        ArrayList<String> telnetArgs = new ArrayList<String>();
        if (bootstrap.getCommand() != null) {
            telnetArgs.add("-c");
            telnetArgs.add(bootstrap.getCommand());
        }
        if (bootstrap.getBatchFile() != null) {
            telnetArgs.add("-f");
            telnetArgs.add(bootstrap.getBatchFile());
        }
        if (bootstrap.getHeight() != null) {
            telnetArgs.add("--height");
            telnetArgs.add("" + bootstrap.getHeight());
        }
        if (bootstrap.getWidth() != null) {
            telnetArgs.add("--width");
            telnetArgs.add("" + bootstrap.getWidth());
        }
        telnetArgs.add(bootstrap.getTargetIp());
        telnetArgs.add("" + bootstrap.getTelnetPort());
        AnsiLog.info((String)"arthas-client connect {} {}", (Object[])new Object[]{bootstrap.getTargetIp(), bootstrap.getTelnetPort()});
        AnsiLog.debug((String)("Start arthas-client.jar args: " + telnetArgs));
        mainMethod.invoke(null, new Object[]{telnetArgs.toArray(new String[0])});
    }

    private static String listVersions(String mavenMetaData) {
        StringBuilder result = new StringBuilder(1024);
        List<String> versionList = Bootstrap.listNames(ARTHAS_LIB_DIR);
        Collections.sort(versionList);
        result.append("Local versions:\n");
        for (String version : versionList) {
            result.append(" " + version).append('\n');
        }
        result.append("Remote versions:\n");
        if (mavenMetaData != null) {
            List<String> remoteVersions = DownloadUtils.readAllMavenVersion(mavenMetaData);
            Collections.reverse(remoteVersions);
            for (String version : remoteVersions) {
                result.append(" " + version).append('\n');
            }
        }
        return result.toString();
    }

    private static List<String> listNames(File dir) {
        ArrayList<String> names = new ArrayList<String>();
        if (!dir.exists()) {
            return names;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return names;
        }
        for (File file : files) {
            String name = file.getName();
            if (name.startsWith(".") || file.isFile()) continue;
            names.add(name);
        }
        return names;
    }

    private static void verifyArthasHome(String arthasHome) {
        File home = new File(arthasHome);
        if (home.isDirectory()) {
            String[] fileList;
            for (String fileName : fileList = new String[]{"arthas-core.jar", "arthas-agent.jar", "arthas-spy.jar"}) {
                if (new File(home, fileName).exists()) continue;
                throw new IllegalArgumentException(fileName + " do not exist, arthas home: " + home.getAbsolutePath());
            }
            return;
        }
        throw new IllegalArgumentException("illegal arthas home: " + home.getAbsolutePath());
    }

    private static String usage(CLI cli) {
        StringBuilder usageStringBuilder = new StringBuilder();
        UsageMessageFormatter usageMessageFormatter = new UsageMessageFormatter();
        usageMessageFormatter.setOptionComparator(null);
        cli.usage(usageStringBuilder, usageMessageFormatter);
        return UsageRender.render((String)usageStringBuilder.toString());
    }

    public String getArthasHome() {
        return this.arthasHome;
    }

    public String getUseVersion() {
        return this.useVersion;
    }

    public String getRepoMirror() {
        return this.repoMirror;
    }

    public boolean isuseHttp() {
        return this.useHttp;
    }

    public String getTargetIp() {
        return this.targetIp;
    }

    public int getTelnetPort() {
        return this.telnetPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getCommand() {
        return this.command;
    }

    public String getBatchFile() {
        return this.batchFile;
    }

    public boolean isAttachOnly() {
        return this.attachOnly;
    }

    public int getPid() {
        return this.pid;
    }

    public boolean isHelp() {
        return this.help;
    }

    public Long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isVersions() {
        return this.versions;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getWidth() {
        return this.width;
    }

    public String getTunnelServer() {
        return this.tunnelServer;
    }

    public String getAgentId() {
        return this.agentId;
    }

    static {
        try {
            ARTHAS_LIB_DIR.mkdirs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!ARTHAS_LIB_DIR.exists()) {
            ARTHAS_LIB_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + ".arthas" + File.separator + "lib");
            try {
                ARTHAS_LIB_DIR.mkdirs();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!ARTHAS_LIB_DIR.exists()) {
            System.err.println("Can not find directory to save arthas lib. please try to set user home by -Duser.home=");
        }
    }
}

