/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.agent;

import com.taobao.arthas.agent.ArthasClassloader;
import java.arthas.Spy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.jar.JarFile;

public class AgentBootstrap {
    private static final String ADVICEWEAVER = "com.taobao.arthas.core.advisor.AdviceWeaver";
    private static final String ON_BEFORE = "methodOnBegin";
    private static final String ON_RETURN = "methodOnReturnEnd";
    private static final String ON_THROWS = "methodOnThrowingEnd";
    private static final String BEFORE_INVOKE = "methodOnInvokeBeforeTracing";
    private static final String AFTER_INVOKE = "methodOnInvokeAfterTracing";
    private static final String THROW_INVOKE = "methodOnInvokeThrowTracing";
    private static final String RESET = "resetArthasClassLoader";
    private static final String ARTHAS_SPY_JAR = "arthas-spy.jar";
    private static final String ARTHAS_CONFIGURE = "com.taobao.arthas.core.config.Configure";
    private static final String ARTHAS_BOOTSTRAP = "com.taobao.arthas.core.server.ArthasBootstrap";
    private static final String TO_CONFIGURE = "toConfigure";
    private static final String GET_JAVA_PID = "getJavaPid";
    private static final String GET_INSTANCE = "getInstance";
    private static final String IS_BIND = "isBind";
    private static final String BIND = "bind";
    private static PrintStream ps = System.err;
    private static volatile ClassLoader arthasClassLoader;

    public static void premain(String args, Instrumentation inst) {
        AgentBootstrap.main(args, inst);
    }

    public static void agentmain(String args, Instrumentation inst) {
        AgentBootstrap.main(args, inst);
    }

    public static synchronized void resetArthasClassLoader() {
        arthasClassLoader = null;
    }

    private static ClassLoader getClassLoader(Instrumentation inst, File spyJarFile, File agentJarFile) throws Throwable {
        inst.appendToBootstrapClassLoaderSearch(new JarFile(spyJarFile));
        return AgentBootstrap.loadOrDefineClassLoader(agentJarFile);
    }

    private static ClassLoader loadOrDefineClassLoader(File agentJar) throws Throwable {
        if (arthasClassLoader == null) {
            arthasClassLoader = new ArthasClassloader(new URL[]{agentJar.toURI().toURL()});
        }
        return arthasClassLoader;
    }

    private static void initSpy(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> adviceWeaverClass = classLoader.loadClass(ADVICEWEAVER);
        Method onBefore = adviceWeaverClass.getMethod(ON_BEFORE, Integer.TYPE, ClassLoader.class, String.class, String.class, String.class, Object.class, Object[].class);
        Method onReturn = adviceWeaverClass.getMethod(ON_RETURN, Object.class);
        Method onThrows = adviceWeaverClass.getMethod(ON_THROWS, Throwable.class);
        Method beforeInvoke = adviceWeaverClass.getMethod(BEFORE_INVOKE, Integer.TYPE, String.class, String.class, String.class);
        Method afterInvoke = adviceWeaverClass.getMethod(AFTER_INVOKE, Integer.TYPE, String.class, String.class, String.class);
        Method throwInvoke = adviceWeaverClass.getMethod(THROW_INVOKE, Integer.TYPE, String.class, String.class, String.class);
        Method reset = AgentBootstrap.class.getMethod(RESET, new Class[0]);
        Spy.initForAgentLauncher((ClassLoader)classLoader, (Method)onBefore, (Method)onReturn, (Method)onThrows, (Method)beforeInvoke, (Method)afterInvoke, (Method)throwInvoke, (Method)reset);
    }

    private static synchronized void main(String args, final Instrumentation inst) {
        try {
            ps.println("Arthas server agent start...");
            int index = args.indexOf(59);
            String agentJar = args.substring(0, index);
            final String agentArgs = args.substring(index, args.length());
            File agentJarFile = new File(agentJar);
            if (!agentJarFile.exists()) {
                ps.println("Agent jar file does not exist: " + agentJarFile);
                return;
            }
            File spyJarFile = new File(agentJarFile.getParentFile(), ARTHAS_SPY_JAR);
            if (!spyJarFile.exists()) {
                ps.println("Spy jar file does not exist: " + spyJarFile);
                return;
            }
            final ClassLoader agentLoader = AgentBootstrap.getClassLoader(inst, spyJarFile, agentJarFile);
            AgentBootstrap.initSpy(agentLoader);
            Thread bindingThread = new Thread(){

                @Override
                public void run() {
                    try {
                        AgentBootstrap.bind(inst, agentLoader, agentArgs);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(ps);
                    }
                }
            };
            bindingThread.setName("arthas-binding-thread");
            bindingThread.start();
            bindingThread.join();
        }
        catch (Throwable t) {
            t.printStackTrace(ps);
            try {
                if (ps != System.err) {
                    ps.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(t);
        }
    }

    private static void bind(Instrumentation inst, ClassLoader agentLoader, String args) throws Throwable {
        Class<?> classOfConfigure = agentLoader.loadClass(ARTHAS_CONFIGURE);
        Object configure = classOfConfigure.getMethod(TO_CONFIGURE, String.class).invoke(null, args);
        int javaPid = (Integer)classOfConfigure.getMethod(GET_JAVA_PID, new Class[0]).invoke(configure, new Object[0]);
        Class<?> bootstrapClass = agentLoader.loadClass(ARTHAS_BOOTSTRAP);
        Object bootstrap = bootstrapClass.getMethod(GET_INSTANCE, Integer.TYPE, Instrumentation.class).invoke(null, javaPid, inst);
        boolean isBind = (Boolean)bootstrapClass.getMethod(IS_BIND, new Class[0]).invoke(bootstrap, new Object[0]);
        if (!isBind) {
            try {
                ps.println("Arthas start to bind...");
                bootstrapClass.getMethod(BIND, classOfConfigure).invoke(bootstrap, configure);
                ps.println("Arthas server bind success.");
                return;
            }
            catch (Exception e) {
                ps.println("Arthas server port binding failed! Please check $HOME/logs/arthas/arthas.log for more details.");
                throw e;
            }
        }
        ps.println("Arthas server already bind.");
    }

    static {
        try {
            File log = new File(System.getProperty("user.home") + File.separator + "logs" + File.separator + ".arthas" + File.separator + "arthas.log");
            if (!log.exists()) {
                log.getParentFile().mkdir();
                log.createNewFile();
            }
            ps = new PrintStream(new FileOutputStream(log, true));
        }
        catch (Throwable t) {
            t.printStackTrace(ps);
        }
    }
}

