/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.ListComponentView;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import java.util.Stack;

class SimpleRecyclerView
extends WXRecyclerView
implements ListComponentView {
    private RecyclerViewBaseAdapter mAdapter = null;
    private Stack<View> headerViewStack = new Stack();
    private Stack<WXCell> headComponentStack = new Stack();

    public SimpleRecyclerView(Context context) {
        super(context);
    }

    @Override
    public WXRecyclerView getInnerView() {
        return this;
    }

    @Override
    public void setRecyclerViewBaseAdapter(RecyclerViewBaseAdapter adapter) {
        this.setAdapter(adapter);
        this.mAdapter = adapter;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyStickyShow(WXCell component) {
        if (component == null) {
            return;
        }
        if (this.headComponentStack.isEmpty()) {
            this.headComponentStack.push(component);
            this.showSticky();
            return;
        }
        WXCell oldCom = this.headComponentStack.pop();
        if (!oldCom.getRef().equals(component.getRef())) {
            this.headComponentStack.push(oldCom);
            this.headComponentStack.push(component);
            this.showSticky();
            return;
        }
        this.headComponentStack.push(oldCom);
    }

    @Override
    public void notifyStickyRemove(WXCell component) {
        if (component == null) {
            return;
        }
        if (!this.headComponentStack.isEmpty() && !this.headerViewStack.isEmpty()) {
            this.removeSticky(component);
        }
    }

    private void showSticky() {
        WXCell headComponent = this.headComponentStack.pop();
        this.headComponentStack.push(headComponent);
        ViewGroup headerView = headComponent.getRealView();
        if (headerView == null) {
            return;
        }
        this.headerViewStack.push((View)headerView);
        headComponent.removeSticky();
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null) {
            parent.post(WXThread.secure(new Runnable((View)headerView, parent){
                final /* synthetic */ View val$headerView;
                final /* synthetic */ ViewGroup val$parent;
                {
                    this.val$headerView = view;
                    this.val$parent = viewGroup;
                }

                @Override
                public void run() {
                    ViewGroup existedParent = (ViewGroup)this.val$headerView.getParent();
                    if (existedParent != null) {
                        existedParent.removeView(this.val$headerView);
                    }
                    this.val$parent.addView(this.val$headerView);
                }
            }));
        }
    }

    private void removeSticky(WXComponent component) {
        final WXCell headComponent = this.headComponentStack.pop();
        if (!component.getRef().equals(headComponent.getRef())) {
            this.headComponentStack.push(headComponent);
            return;
        }
        final View headerView = this.headerViewStack.pop();
        final ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null) {
            parent.post(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    parent.removeView(headerView);
                    headComponent.recoverySticky();
                }
            }));
        }
    }

    @Override
    public RecyclerViewBaseAdapter getRecyclerViewBaseAdapter() {
        return this.mAdapter;
    }
}

