/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.navigator;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.utils.WXLogUtils;

public class WXNavigatorModule
extends WXModule {
    public static final String MSG_SUCCESS = "WX_SUCCESS";
    public static final String MSG_FAILED = "WX_FAILED";
    public static final String MSG_PARAM_ERR = "WX_PARAM_ERR";
    public static final String CALLBACK_RESULT = "result";
    public static final String CALLBACK_MESSAGE = "message";
    private static final String INSTANCE_ID = "instanceId";
    private static final String TAG = "Navigator";
    private static final String WEEX = "com.taobao.android.intent.category.WEEX";
    private static final String URL = "url";

    @JSMethod(uiThread=true)
    public void open(JSONObject options, JSCallback success, JSCallback failure) {
        if (options != null) {
            String url = options.getString(URL);
            JSCallback callback = success;
            JSONObject result = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)url)) {
                Uri rawUri = Uri.parse((String)url);
                String scheme = rawUri.getScheme();
                if (TextUtils.isEmpty((CharSequence)scheme) || "http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                    this.push(options.toJSONString(), success);
                } else {
                    try {
                        Intent intent = new Intent("android.intent.action.VIEW", rawUri);
                        this.mWXSDKInstance.getContext().startActivity(intent);
                        result.put(CALLBACK_RESULT, (Object)MSG_SUCCESS);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        result.put(CALLBACK_RESULT, (Object)MSG_FAILED);
                        result.put(CALLBACK_MESSAGE, (Object)"open page failed");
                        callback = failure;
                    }
                }
            } else {
                result.put(CALLBACK_RESULT, (Object)MSG_PARAM_ERR);
                result.put(CALLBACK_MESSAGE, (Object)"param error");
                callback = failure;
            }
            if (callback != null) {
                callback.invoke(result);
            }
        }
    }

    @JSMethod(uiThread=true)
    public void close(JSONObject options, JSCallback success, JSCallback failure) {
        JSONObject result = new JSONObject();
        JSCallback callback = null;
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            callback = success;
            ((Activity)this.mWXSDKInstance.getContext()).finish();
        } else {
            result.put(CALLBACK_RESULT, (Object)MSG_FAILED);
            result.put(CALLBACK_MESSAGE, (Object)"close page failed");
            callback = failure;
        }
        if (callback != null) {
            callback.invoke(result);
        }
    }

    @JSMethod(uiThread=true)
    public void push(String param, JSCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)param)) {
            if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().push(param)) {
                callback.invoke(MSG_SUCCESS);
                return;
            }
            try {
                JSONObject jsonObject = JSON.parseObject((String)param);
                String url = jsonObject.getString(URL);
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    Uri rawUri = Uri.parse((String)url);
                    String scheme = rawUri.getScheme();
                    Uri.Builder builder = rawUri.buildUpon();
                    if (TextUtils.isEmpty((CharSequence)scheme)) {
                        builder.scheme("http");
                    }
                    Intent intent = new Intent("android.intent.action.VIEW", builder.build());
                    intent.addCategory(WEEX);
                    intent.putExtra(INSTANCE_ID, this.mWXSDKInstance.getInstanceId());
                    this.mWXSDKInstance.getContext().startActivity(intent);
                    callback.invoke(MSG_SUCCESS);
                }
            }
            catch (Exception e) {
                WXLogUtils.eTag(TAG, e);
                callback.invoke(MSG_FAILED);
            }
        }
        callback.invoke(MSG_FAILED);
    }

    @JSMethod(uiThread=true)
    public void pop(String param, JSCallback callback) {
        if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().pop(param)) {
            callback.invoke(MSG_SUCCESS);
            return;
        }
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            callback.invoke(MSG_SUCCESS);
            ((Activity)this.mWXSDKInstance.getContext()).finish();
        }
    }

    @JSMethod(uiThread=true)
    public void setNavBarRightItem(String param, JSCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)param) && WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().setNavBarRightItem(param)) {
            callback.invoke(MSG_SUCCESS);
            return;
        }
        callback.invoke(MSG_FAILED);
    }

    @JSMethod(uiThread=true)
    public void clearNavBarRightItem(String param, JSCallback callback) {
        if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().clearNavBarRightItem(param)) {
            callback.invoke(MSG_SUCCESS);
            return;
        }
        callback.invoke(MSG_FAILED);
    }

    @JSMethod(uiThread=true)
    public void setNavBarLeftItem(String param, JSCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)param) && WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().setNavBarLeftItem(param)) {
            callback.invoke(MSG_SUCCESS);
            return;
        }
        callback.invoke(MSG_FAILED);
    }

    @JSMethod(uiThread=true)
    public void clearNavBarLeftItem(String param, JSCallback callback) {
        if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().clearNavBarLeftItem(param)) {
            callback.invoke(MSG_SUCCESS);
            return;
        }
        callback.invoke(MSG_FAILED);
    }

    @JSMethod(uiThread=true)
    public void setNavBarMoreItem(String param, JSCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)param) && WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().setNavBarMoreItem(param)) {
            callback.invoke(MSG_SUCCESS);
            return;
        }
        callback.invoke(MSG_FAILED);
    }

    @JSMethod(uiThread=true)
    public void clearNavBarMoreItem(String param, JSCallback callback) {
        if (WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().clearNavBarMoreItem(param)) {
            callback.invoke(MSG_SUCCESS);
            return;
        }
        callback.invoke(MSG_FAILED);
    }

    @JSMethod(uiThread=true)
    public void setNavBarTitle(String param, JSCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)param) && WXSDKEngine.getActivityNavBarSetter() != null && WXSDKEngine.getActivityNavBarSetter().setNavBarTitle(param)) {
            callback.invoke(MSG_SUCCESS);
            return;
        }
        callback.invoke(MSG_FAILED);
    }

    @JSMethod
    public void setNavBarHidden(String param, String callback) {
        String message = MSG_FAILED;
        try {
            JSONObject jsObj = JSON.parseObject((String)param);
            int visibility = jsObj.getInteger("hidden");
            boolean success = this.changeVisibilityOfActionBar(this.mWXSDKInstance.getContext(), visibility);
            if (success) {
                message = MSG_SUCCESS;
            }
        }
        catch (JSONException e) {
            WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
        }
        WXBridgeManager.getInstance().callback(this.mWXSDKInstance.getInstanceId(), callback, message);
    }

    private boolean changeVisibilityOfActionBar(Context context, int visibility) {
        ActionBar actionbar;
        boolean result = false;
        boolean hasAppCompatActivity = false;
        try {
            Class.forName("android.support.v7.app.AppCompatActivity");
            hasAppCompatActivity = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (hasAppCompatActivity && this.mWXSDKInstance.getContext() instanceof AppCompatActivity) {
            android.support.v7.app.ActionBar actionbar2 = ((AppCompatActivity)this.mWXSDKInstance.getContext()).getSupportActionBar();
            if (actionbar2 != null) {
                switch (visibility) {
                    case 1: {
                        actionbar2.hide();
                        result = true;
                        break;
                    }
                    case 0: {
                        actionbar2.show();
                        result = true;
                    }
                }
            }
        } else if (this.mWXSDKInstance.getContext() instanceof Activity && (actionbar = ((Activity)this.mWXSDKInstance.getContext()).getActionBar()) != null) {
            switch (visibility) {
                case 1: {
                    actionbar.hide();
                    result = true;
                    break;
                }
                case 0: {
                    actionbar.show();
                    result = true;
                }
            }
        }
        return result;
    }
}

