/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.WXLogUtils;

public class WXUtils {
    public static final char PERCENT = '%';
    private static final int HUNDRED = 100;

    public static boolean isUiThread() {
        return Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
    }

    public static boolean isUndefined(float value) {
        return Float.isNaN(value);
    }

    public static float getFloat(Object value) {
        if (value == null) {
            return Float.NaN;
        }
        String temp = value.toString().trim();
        if (temp.endsWith("px")) {
            temp = temp.substring(0, temp.indexOf("px"));
        }
        float result = Float.NaN;
        try {
            result = Float.parseFloat(temp);
        }
        catch (NumberFormatException e) {
            WXLogUtils.e("Argument format error!");
        }
        return result;
    }

    public static Float getFloat(Object value, @Nullable Float df) {
        if (value == null) {
            return df;
        }
        try {
            String temp = value.toString().trim();
            temp = temp.replace("px", "");
            return Float.valueOf(Float.parseFloat(temp));
        }
        catch (Exception cce) {
            WXLogUtils.e("Argument error!");
            return df;
        }
    }

    public static float fastGetFloat(String raw, int precision) {
        if (!TextUtils.isEmpty((CharSequence)raw)) {
            char digit;
            boolean positive = true;
            int loc = 0;
            if (raw.charAt(0) == '-') {
                positive = false;
                ++loc;
            } else if (raw.charAt(0) == '+') {
                ++loc;
            }
            float result = 0.0f;
            while (loc < raw.length() && (digit = raw.charAt(loc)) >= '0' && digit <= '9') {
                result = result * 10.0f + (float)digit - 48.0f;
                ++loc;
            }
            if (loc < raw.length()) {
                if (raw.charAt(loc) == '.') {
                    ++loc;
                    int remainderLength = 10;
                    for (int counter = 0; loc < raw.length() && counter < precision && (digit = raw.charAt(loc)) >= '0' && digit <= '9'; ++loc, ++counter) {
                        result += (float)(digit - 48) / (float)remainderLength;
                        remainderLength *= 10;
                    }
                } else {
                    throw new NumberFormatException("Illegal separator");
                }
            }
            if (!positive) {
                result *= -1.0f;
            }
            return result;
        }
        throw new NumberFormatException("NullNumber");
    }

    public static float fastGetFloat(String raw) {
        return WXUtils.fastGetFloat(raw, Integer.MAX_VALUE);
    }

    public static int getInt(Object value) {
        if (value == null) {
            return 0;
        }
        String temp = value.toString().trim();
        if (temp.endsWith("px")) {
            temp = temp.substring(0, temp.indexOf("px"));
        }
        int result = 0;
        try {
            result = Integer.parseInt(temp);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static Integer getInteger(@Nullable Object value, @Nullable Integer df) {
        if (value == null) {
            return df;
        }
        try {
            return (Integer)value;
        }
        catch (ClassCastException cce) {
            String temp = value.toString().trim();
            if (temp.endsWith("px")) {
                temp = temp.substring(0, temp.indexOf("px"));
            }
            try {
                return Integer.parseInt(temp);
            }
            catch (NumberFormatException nfe) {
                WXLogUtils.e("Argument format error!");
            }
            catch (Exception e) {
                WXLogUtils.e("Argument error!");
            }
            return df;
        }
    }

    public static long getLong(Object value) {
        if (value == null) {
            return 0L;
        }
        String temp = value.toString().trim();
        if (temp.endsWith("px")) {
            temp = temp.substring(0, temp.indexOf("px"));
        }
        long result = 0L;
        try {
            result = Long.parseLong(temp);
        }
        catch (NumberFormatException e) {
            WXLogUtils.e("[WXUtils] getLong:", e);
        }
        return result;
    }

    public static double getDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        String temp = value.toString().trim();
        if (temp.endsWith("px")) {
            temp = temp.substring(0, temp.indexOf("px"));
        }
        double result = 0.0;
        try {
            result = Double.parseDouble(temp);
        }
        catch (NumberFormatException e) {
            WXLogUtils.e("[WXUtils] getDouble:", e);
        }
        return result;
    }

    public static boolean isTabletDevice() {
        try {
            return (WXEnvironment.getApplication().getResources().getConfiguration().screenLayout & 0xF) >= 3;
        }
        catch (Exception e) {
            WXLogUtils.e("[WXUtils] isTabletDevice:", e);
            return false;
        }
    }

    public static Boolean getBoolean(@Nullable Object value, @Nullable Boolean df) {
        if (value == null) {
            return df;
        }
        if (TextUtils.equals((CharSequence)"false", (CharSequence)value.toString())) {
            return false;
        }
        if (TextUtils.equals((CharSequence)"true", (CharSequence)value.toString())) {
            return true;
        }
        return df;
    }

    public static long getAvailMemory(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        WXLogUtils.w("app AvailMemory ---->>>" + mi.availMem / 0x100000L);
        return mi.availMem / 0x100000L;
    }

    public static String getString(@Nullable Object value, @Nullable String df) {
        if (value == null) {
            return df;
        }
        String originValue = value instanceof String ? (String)value : value.toString();
        return originValue;
    }

    public static int parseUnitOrPercent(String raw, int unit) {
        int suffix = raw.lastIndexOf(37);
        if (suffix != -1) {
            return WXUtils.parsePercent(raw.substring(0, suffix), unit);
        }
        return Integer.parseInt(raw);
    }

    private static int parsePercent(String raw, int unit) {
        return (int)(Float.parseFloat(raw) / 100.0f * (float)unit);
    }
}

