/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.graphics.Typeface;
import android.net.Uri;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.utils.WXLogUtils;

public class FontDO {
    private final String mFontFamilyName;
    private String mUrl = "";
    private int mType = 1;
    private Typeface mTypeface;
    private int mState = -1;
    public static final int STATE_INVALID = -1;
    public static final int STATE_INIT = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_SUCCESS = 2;
    public static final int STATE_FAILED = 3;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_NETWORK = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_LOCAL = 3;

    public FontDO(String fontFamilyName, String src, WXSDKInstance instance) {
        this.mFontFamilyName = fontFamilyName;
        this.parseSrc(src, instance);
    }

    public String getFontFamilyName() {
        return this.mFontFamilyName;
    }

    private void parseSrc(String src, WXSDKInstance instance) {
        String string2 = src = src != null ? src.trim() : "";
        if (src.isEmpty()) {
            this.mState = -1;
            WXLogUtils.e("TypefaceUtil", "font src is empty.");
            return;
        }
        if (src.matches("^url\\('.*'\\)$")) {
            String url = src.substring(5, src.length() - 2);
            Uri uri = Uri.parse((String)url);
            if (instance != null) {
                uri = instance.rewriteUri(uri, "font");
            }
            this.mUrl = uri.toString();
            try {
                String scheme = uri.getScheme();
                if ("http".equals(scheme) || "https".equals(scheme)) {
                    this.mType = 1;
                } else if ("file".equals(scheme)) {
                    this.mType = 2;
                    this.mUrl = uri.getPath();
                } else {
                    this.mType = "local".equals(scheme) ? 3 : 0;
                }
                this.mState = 0;
            }
            catch (Exception e) {
                this.mType = -1;
                WXLogUtils.e("TypefaceUtil", "URI.create(mUrl) failed mUrl: " + this.mUrl);
            }
        } else {
            this.mUrl = src;
            this.mState = -1;
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("TypefaceUtil", "src:" + src + ", mUrl:" + this.mUrl + ", mType:" + this.mType);
        }
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getType() {
        return this.mType;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int state) {
        this.mState = state;
    }
}

