/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.List;

public class WXCirclePageAdapter
extends PagerAdapter {
    private List<View> views = new ArrayList<View>();
    private List<View> shadow = new ArrayList<View>();
    private boolean needLoop = true;

    public WXCirclePageAdapter(List<View> views, boolean needLoop) {
        this.views = new ArrayList<View>(views);
        this.needLoop = needLoop;
    }

    public WXCirclePageAdapter() {
        this(true);
    }

    public WXCirclePageAdapter(boolean needLoop) {
        this.needLoop = needLoop;
    }

    public void addPageView(View view) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("onPageSelected >>>> addPageView");
        }
        this.views.add(view);
        this.ensureShadow();
    }

    public void removePageView(View view) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("onPageSelected >>>> removePageView");
        }
        this.views.remove(view);
        this.ensureShadow();
    }

    public void replacePageView(View oldView, View newView) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("onPageSelected >>>> replacePageView");
        }
        int index = this.views.indexOf(oldView);
        this.views.remove(index);
        this.views.add(index, newView);
        this.ensureShadow();
    }

    public int getCount() {
        return this.shadow.size();
    }

    public int getRealCount() {
        return this.views.size();
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View pageView = null;
        try {
            pageView = this.shadow.get(position);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("onPageSelected >>>> instantiateItem >>>>> position:" + position + ",position % getRealCount()" + position % this.getRealCount());
            }
            if (pageView.getParent() == null) {
                container.addView(pageView);
            } else {
                ((ViewGroup)pageView.getParent()).removeView(pageView);
                container.addView(pageView);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[CirclePageAdapter] instantiateItem: ", e);
        }
        return pageView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("onPageSelected >>>> destroyItem >>>>> position:" + position);
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public int getItemIndex(Object object) {
        if (object instanceof View) {
            return this.views.indexOf(object);
        }
        return -1;
    }

    public List<View> getViews() {
        return this.views;
    }

    private void ensureShadow() {
        ArrayList<View> temp = new ArrayList<View>();
        if (this.needLoop && this.views.size() > 2) {
            temp.add(0, this.views.get(this.views.size() - 1));
            for (View view : this.views) {
                temp.add(view);
            }
            temp.add(this.views.get(0));
        } else {
            temp.addAll(this.views);
        }
        this.shadow.clear();
        this.notifyDataSetChanged();
        this.shadow.addAll(temp);
        this.notifyDataSetChanged();
    }

    public int getRealPosition(int shadowPosition) {
        if (shadowPosition < 0 || shadowPosition >= this.shadow.size()) {
            return -1;
        }
        return this.getItemIndex(this.shadow.get(shadowPosition));
    }

    public int getFirst() {
        if (this.needLoop && this.views.size() > 2) {
            return 1;
        }
        return 0;
    }
}

