/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.Component;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.AppearanceHelper;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.helper.WXStickyHelper;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.ui.view.listview.adapter.IRecyclerAdapterListener;
import com.taobao.weex.ui.view.listview.adapter.ListBaseViewHolder;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.listview.adapter.TransformItemDecoration;
import com.taobao.weex.ui.view.listview.adapter.WXRecyclerViewOnScrollListener;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Component(lazyload=false)
public class WXListComponent
extends WXVContainer<BounceRecyclerView>
implements IRecyclerAdapterListener<ListBaseViewHolder>,
IOnLoadMoreListener,
Scrollable {
    public static final String TRANSFORM = "transform";
    public static final String LOADMOREOFFSET = "loadmoreoffset";
    private String TAG = "WXListComponent";
    private int mListCellCount = 0;
    private String mLoadMoreRetry = "";
    private ArrayList<ListBaseViewHolder> recycleViewList = new ArrayList();
    private static final Pattern transformPattern = Pattern.compile("([a-z]+)\\(([0-9\\.]+),?([0-9\\.]+)?\\)");
    private Map<String, AppearanceHelper> mAppearComponents = new HashMap<String, AppearanceHelper>();
    private ArrayMap<String, Long> mRefToViewType;
    private SparseArray<ArrayList<WXComponent>> mViewTypes;
    protected BounceRecyclerView bounceRecyclerView;
    private WXRecyclerViewOnScrollListener mViewOnScrollListener = new WXRecyclerViewOnScrollListener(this);
    private static final int MAX_VIEWTYPE_ALLOW_CACHE = 9;
    private static boolean mAllowCacheViewHolder = true;
    private static boolean mDownForBidCacheViewHolder = false;
    private Map<String, HashMap<String, WXComponent>> mStickyMap = new HashMap<String, HashMap<String, WXComponent>>();
    private WXStickyHelper stickyHelper = new WXStickyHelper(this);

    @Deprecated
    public WXListComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXListComponent(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        int screenH = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
        int weexH = WXViewUtils.getWeexHeight(this.getInstanceId());
        int outHeight = height > (weexH >= screenH ? screenH : weexH) ? weexH - this.mAbsoluteY : height;
        return super.measure(width, outHeight);
    }

    protected int getOrientation() {
        return 1;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mStickyMap != null) {
            this.mStickyMap.clear();
        }
        if (this.mViewTypes != null) {
            this.mViewTypes.clear();
        }
        if (this.mRefToViewType != null) {
            this.mRefToViewType.clear();
        }
    }

    private RecyclerView.ItemDecoration parseTransforms(String raw) {
        if (raw == null) {
            return null;
        }
        float scaleX = 0.0f;
        float scaleY = 0.0f;
        int translateX = 0;
        int translateY = 0;
        float opacity = 0.0f;
        int rotate = 0;
        Matcher matcher = transformPattern.matcher(raw);
        while (matcher.find()) {
            String match = matcher.group();
            String name = matcher.group(1);
            try {
                switch (name) {
                    case "scale": {
                        scaleX = Float.parseFloat(matcher.group(2));
                        scaleY = Float.parseFloat(matcher.group(3));
                        break;
                    }
                    case "translate": {
                        translateX = Integer.parseInt(matcher.group(2));
                        translateY = Integer.parseInt(matcher.group(3));
                        break;
                    }
                    case "opacity": {
                        opacity = Float.parseFloat(matcher.group(2));
                        break;
                    }
                    case "rotate": {
                        rotate = Integer.parseInt(matcher.group(2));
                        break;
                    }
                    default: {
                        WXLogUtils.e(this.TAG, "Invaild transform expression:" + match);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                WXLogUtils.e("", e);
                WXLogUtils.e(this.TAG, "Invaild transform expression:" + match);
            }
        }
        return new TransformItemDecoration(this.getOrientation() == 1, opacity, translateX, translateY, rotate, scaleX, scaleY);
    }

    @Override
    protected BounceRecyclerView initComponentHostView(@NonNull Context context) {
        this.bounceRecyclerView = new BounceRecyclerView(context, this.getOrientation());
        String transforms = (String)this.getDomObject().getAttrs().get(TRANSFORM);
        if (transforms != null) {
            ((WXRecyclerView)((Object)this.bounceRecyclerView.getInnerView())).addItemDecoration(this.parseTransforms(transforms));
        }
        RecyclerViewBaseAdapter recyclerViewBaseAdapter = new RecyclerViewBaseAdapter(this);
        recyclerViewBaseAdapter.setHasStableIds(true);
        this.bounceRecyclerView.setAdapter(recyclerViewBaseAdapter);
        this.bounceRecyclerView.setOverScrollMode(2);
        ((WXRecyclerView)((Object)this.bounceRecyclerView.getInnerView())).clearOnScrollListeners();
        ((WXRecyclerView)((Object)this.bounceRecyclerView.getInnerView())).addOnScrollListener(this.mViewOnScrollListener);
        ((WXRecyclerView)((Object)this.bounceRecyclerView.getInnerView())).addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                List<OnWXScrollListener> listeners;
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    for (ListBaseViewHolder holder : WXListComponent.this.recycleViewList) {
                        if (holder == null || holder.getComponent() == null || holder.getComponent().isUsing()) continue;
                        WXListComponent.this.recycleImage(holder.getView());
                    }
                    WXListComponent.this.recycleViewList.clear();
                }
                if ((listeners = WXListComponent.this.getInstance().getWXScrollListeners()) != null && listeners.size() > 0) {
                    for (OnWXScrollListener listener : listeners) {
                        View topView;
                        if (listener == null || (topView = recyclerView.getChildAt(0)) == null || listener == null) continue;
                        int y = topView.getTop();
                        listener.onScrollStateChanged((View)recyclerView, 0, y, newState);
                    }
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                List<OnWXScrollListener> listeners = WXListComponent.this.getInstance().getWXScrollListeners();
                if (listeners != null && listeners.size() > 0) {
                    for (OnWXScrollListener listener : listeners) {
                        if (listener == null) continue;
                        listener.onScrolled((View)recyclerView, dx, dy);
                    }
                }
            }
        });
        this.bounceRecyclerView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                WXListComponent.this.mViewOnScrollListener.onScrolled((RecyclerView)WXListComponent.this.bounceRecyclerView.getInnerView(), 0, 0);
                Object view = WXListComponent.this.getHostView();
                if (view == null) {
                    return;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        return this.bounceRecyclerView;
    }

    @Override
    public void bindStickStyle(WXComponent component) {
        this.stickyHelper.bindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void unbindStickStyle(WXComponent component) {
        this.stickyHelper.unbindStickStyle(component, this.mStickyMap);
    }

    @Nullable
    private WXComponent findDirectListChild(WXComponent comp) {
        WXVContainer parent;
        if (comp == null || (parent = comp.getParent()) == null) {
            return null;
        }
        if (parent instanceof WXListComponent) {
            return comp;
        }
        return this.findDirectListChild(parent);
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "loadmoreoffset": {
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    private void setAppearanceWatch(WXComponent component, int event, boolean enable) {
        WXComponent dChild;
        int index;
        AppearanceHelper item = this.mAppearComponents.get(component.getRef());
        if (item != null) {
            item.setWatchEvent(event, enable);
        } else if (enable && (index = this.mChildren.indexOf(dChild = this.findDirectListChild(component))) != -1) {
            item = new AppearanceHelper(component, index);
            item.setWatchEvent(event, true);
            this.mAppearComponents.put(component.getRef(), item);
        }
    }

    @Override
    public void bindAppearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 0, true);
    }

    @Override
    public void bindDisappearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 1, true);
    }

    @Override
    public void unbindAppearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 0, false);
    }

    @Override
    public void unbindDisappearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 1, false);
    }

    @Override
    public void scrollTo(WXComponent component, final int offset) {
        if (this.bounceRecyclerView == null) {
            return;
        }
        WXCell cell = null;
        for (WXComponent parent = component; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof WXCell)) continue;
            cell = (WXCell)parent;
            break;
        }
        if (cell != null) {
            int pos = this.mChildren.indexOf(cell);
            final WXRecyclerView view = (WXRecyclerView)((Object)this.bounceRecyclerView.getInnerView());
            view.scrollToPosition(pos);
            final WXCell cellComp = cell;
            view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (cellComp.getHostView() == null) {
                        return;
                    }
                    if (WXListComponent.this.getOrientation() == 1) {
                        int scrollY = cellComp.getHostView().getTop() + offset;
                        view.smoothScrollBy(0, scrollY);
                    } else {
                        int scrollX = cellComp.getHostView().getLeft() + offset;
                        view.smoothScrollBy(scrollX, 0);
                    }
                }
            }, 50L);
        }
    }

    private void onPostScrollToPosition(int pos) {
        if (pos < 0) {
            return;
        }
        this.checkLastSticky(pos);
    }

    public void checkLastSticky(int position) {
        this.bounceRecyclerView.clearSticky();
        for (int i = 0; i <= position; ++i) {
            WXComponent component = this.getChild(i);
            if (!component.isSticky() || !(component instanceof WXCell)) continue;
            if (component.getHostView() == null) {
                return;
            }
            this.bounceRecyclerView.notifyStickyShow((WXCell)component);
        }
    }

    @Override
    public void onBeforeScroll(int dx, int dy) {
        if (this.mStickyMap == null) {
            return;
        }
        HashMap<String, WXComponent> stickyMap = this.mStickyMap.get(this.getRef());
        if (stickyMap == null) {
            return;
        }
        for (Map.Entry<String, WXComponent> entry : stickyMap.entrySet()) {
            boolean removeSticky;
            WXComponent stickyComponent = entry.getValue();
            if (stickyComponent == null || stickyComponent.getDomObject() == null || !(stickyComponent instanceof WXCell)) continue;
            WXCell cell = (WXCell)stickyComponent;
            if (cell.getHostView() == null) {
                return;
            }
            boolean beforeFirstVisibleItem = false;
            RecyclerView.LayoutManager layoutManager = ((WXRecyclerView)((Object)((BounceRecyclerView)((Object)this.getHostView())).getInnerView())).getLayoutManager();
            if (layoutManager instanceof LinearLayoutManager) {
                int fVisible = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                int pos = this.mChildren.indexOf(cell);
                if (pos <= fVisible) {
                    beforeFirstVisibleItem = true;
                }
            }
            int[] location = new int[2];
            stickyComponent.getHostView().getLocationOnScreen(location);
            int[] parentLocation = new int[2];
            stickyComponent.getParentScroller().getView().getLocationOnScreen(parentLocation);
            int top = location[1] - parentLocation[1];
            boolean showSticky = beforeFirstVisibleItem && cell.getLocationFromStart() >= 0 && top <= 0 && dy >= 0;
            boolean bl = removeSticky = cell.getLocationFromStart() <= 0 && top > 0 && dy <= 0;
            if (showSticky) {
                this.bounceRecyclerView.notifyStickyShow(cell);
            } else if (removeSticky) {
                this.bounceRecyclerView.notifyStickyRemove(cell);
            }
            cell.setLocationFromStart(top);
        }
    }

    @Override
    public int getScrollY() {
        return this.bounceRecyclerView == null ? 0 : ((WXRecyclerView)((Object)this.bounceRecyclerView.getInnerView())).getScrollY();
    }

    @Override
    public int getScrollX() {
        return this.bounceRecyclerView == null ? 0 : ((WXRecyclerView)((Object)this.bounceRecyclerView.getInnerView())).getScrollX();
    }

    @Override
    public void addChild(WXComponent child) {
        this.addChild(child, -1);
    }

    @Override
    public void addChild(WXComponent child, int index) {
        if (child == null || index < -1) {
            return;
        }
        this.setRefreshOrLoading(child);
        int count = this.mChildren.size();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.mChildren.add(child);
        } else {
            this.mChildren.add(index, child);
        }
        this.bindViewType(child);
        int adapterPosition = index == -1 ? this.mChildren.size() - 1 : index;
        BounceRecyclerView view = (BounceRecyclerView)((Object)this.getHostView());
        if (view != null) {
            view.getAdapter().notifyItemInserted(adapterPosition);
        }
        this.relocateAppearanceHelper();
    }

    private void relocateAppearanceHelper() {
        for (Map.Entry<String, AppearanceHelper> item : this.mAppearComponents.entrySet()) {
            AppearanceHelper value = item.getValue();
            WXComponent dChild = this.findDirectListChild(value.getAwareChild());
            int index = this.mChildren.indexOf(dChild);
            value.setCellPosition(index);
        }
    }

    private boolean setRefreshOrLoading(final WXComponent child) {
        if (this.getHostView() == null) {
            WXLogUtils.e(this.TAG, "setRefreshOrLoading: HostView == null !!!!!! check list attr has append =tree");
            return true;
        }
        if (child instanceof WXRefresh) {
            ((BounceRecyclerView)((Object)this.getHostView())).setOnRefreshListener((WXRefresh)child);
            ((BounceRecyclerView)((Object)this.getHostView())).postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)((Object)WXListComponent.this.getHostView())).setHeaderView(child);
                }
            }, 100L);
            return true;
        }
        if (child instanceof WXLoading) {
            ((BounceRecyclerView)((Object)this.getHostView())).setOnLoadingListener((WXLoading)child);
            ((BounceRecyclerView)((Object)this.getHostView())).postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)((Object)WXListComponent.this.getHostView())).setFooterView(child);
                }
            }, 100L);
            return true;
        }
        return false;
    }

    @Override
    protected void addSubView(View child, int index) {
        BounceRecyclerView view = (BounceRecyclerView)((Object)this.getHostView());
        if (view == null) {
            return;
        }
    }

    @Override
    public void remove(WXComponent child) {
        this.remove(child, true);
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        int index = this.mChildren.indexOf(child);
        if (destroy) {
            child.detachViewAndClearPreInfo();
        }
        this.unBindViewType(child);
        BounceRecyclerView view = (BounceRecyclerView)((Object)this.getHostView());
        if (view == null) {
            return;
        }
        view.getAdapter().notifyItemRemoved(index);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "removeChild child at " + index);
        }
        super.remove(child, destroy);
    }

    @Override
    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        RecyclerView view = (RecyclerView)((BounceRecyclerView)((Object)this.getHostView())).getInnerView();
        pointF.set((float)view.computeHorizontalScrollOffset(), (float)view.computeVerticalScrollOffset());
    }

    @Override
    public void onViewRecycled(ListBaseViewHolder holder) {
        long begin = System.currentTimeMillis();
        holder.setComponentUsing(false);
        this.recycleViewList.add(holder);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "Recycle holder " + (System.currentTimeMillis() - begin) + "  Thread:" + Thread.currentThread().getName());
        }
    }

    @Override
    public void onBindViewHolder(ListBaseViewHolder holder, int position) {
        if (holder == null) {
            return;
        }
        holder.setComponentUsing(true);
        WXComponent component = this.getChild(position);
        if (component == null || component instanceof WXRefresh || component instanceof WXLoading || component.getDomObject() != null && component.getDomObject().isFixed()) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(this.TAG, "Bind WXRefresh & WXLoading " + (Object)((Object)holder));
            }
            return;
        }
        if (component != null && holder.getComponent() != null && holder.getComponent() instanceof WXCell) {
            holder.getComponent().bindData(component);
        }
    }

    @Override
    public ListBaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mChildren != null) {
            if (this.mViewTypes == null) {
                return this.createVHForFakeComponent(viewType);
            }
            ArrayList mTypes = (ArrayList)this.mViewTypes.get(viewType);
            this.checkRecycledViewPool(viewType);
            if (mTypes == null) {
                return this.createVHForFakeComponent(viewType);
            }
            for (int i = 0; i < mTypes.size(); ++i) {
                WXComponent component = (WXComponent)mTypes.get(i);
                if (component == null || component.isUsing()) continue;
                if (component.getDomObject() != null && component.getDomObject().isFixed()) {
                    return this.createVHForFakeComponent(viewType);
                }
                if (component instanceof WXCell) {
                    if (component.getRealView() != null) {
                        return new ListBaseViewHolder(component, viewType);
                    }
                    ((WXCell)component).lazy(false);
                    component.createView(this, -1);
                    component.applyLayoutAndEvent(component);
                    return new ListBaseViewHolder(component, viewType);
                }
                if (component instanceof WXBaseRefresh) {
                    return this.createVHForRefreshComponent(viewType);
                }
                WXLogUtils.e(this.TAG, "List cannot include element except cell\u3001header\u3001fixed\u3001refresh and loading");
                return this.createVHForFakeComponent(viewType);
            }
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.e(this.TAG, "Cannot find request viewType: " + viewType);
        }
        return this.createVHForFakeComponent(viewType);
    }

    private void checkRecycledViewPool(int viewType) {
        try {
            if (this.mViewTypes.size() > 9) {
                mAllowCacheViewHolder = false;
            }
            if (mDownForBidCacheViewHolder && this.getHostView() != null && ((BounceRecyclerView)((Object)this.getHostView())).getInnerView() != null) {
                ((WXRecyclerView)((Object)((BounceRecyclerView)((Object)this.getHostView())).getInnerView())).getRecycledViewPool().setMaxRecycledViews(viewType, 0);
            }
            if (!mDownForBidCacheViewHolder && !mAllowCacheViewHolder && this.getHostView() != null && ((BounceRecyclerView)((Object)this.getHostView())).getInnerView() != null) {
                for (int i = 0; i < this.mViewTypes.size(); ++i) {
                    ((WXRecyclerView)((Object)((BounceRecyclerView)((Object)this.getHostView())).getInnerView())).getRecycledViewPool().setMaxRecycledViews(this.mViewTypes.keyAt(i), 0);
                }
                mDownForBidCacheViewHolder = true;
            }
        }
        catch (Exception e) {
            WXLogUtils.e(this.TAG, "Clear recycledViewPool error!");
        }
    }

    @Override
    public int getItemViewType(int position) {
        return this.generateViewType(this.getChild(position));
    }

    private void bindViewType(WXComponent component) {
        ArrayList<WXComponent> mTypes;
        int id = this.generateViewType(component);
        if (this.mViewTypes == null) {
            this.mViewTypes = new SparseArray();
        }
        if ((mTypes = (ArrayList<WXComponent>)this.mViewTypes.get(id)) == null) {
            mTypes = new ArrayList<WXComponent>();
            this.mViewTypes.put(id, mTypes);
        }
        mTypes.add(component);
    }

    private void unBindViewType(WXComponent component) {
        int id = this.generateViewType(component);
        if (this.mViewTypes == null) {
            return;
        }
        ArrayList mTypes = (ArrayList)this.mViewTypes.get(id);
        if (mTypes == null) {
            return;
        }
        mTypes.remove(component);
    }

    private int generateViewType(WXComponent component) {
        long id;
        try {
            id = Integer.parseInt(component.getDomObject().getRef());
            String type = component.getDomObject().getAttrs().getScope();
            if (!TextUtils.isEmpty((CharSequence)type)) {
                if (this.mRefToViewType == null) {
                    this.mRefToViewType = new ArrayMap();
                }
                if (!this.mRefToViewType.containsKey((Object)type)) {
                    this.mRefToViewType.put((Object)type, (Object)id);
                }
                id = (Long)this.mRefToViewType.get((Object)type);
            }
        }
        catch (RuntimeException e) {
            WXLogUtils.eTag(this.TAG, e);
            id = -1L;
            WXLogUtils.e(this.TAG, "getItemViewType: NO ID, this will crash the whole render system of WXListRecyclerView");
        }
        return (int)id;
    }

    @Override
    public int getItemCount() {
        if (this.mChildren != null) {
            return this.mChildren.size();
        }
        return 0;
    }

    @Override
    public boolean onFailedToRecycleView(ListBaseViewHolder holder) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "Failed to recycle " + (Object)((Object)holder));
        }
        return false;
    }

    @Override
    public long getItemId(int position) {
        long id;
        try {
            id = Long.parseLong(this.getChild(position).getDomObject().getRef());
        }
        catch (RuntimeException e) {
            WXLogUtils.e(this.TAG, WXLogUtils.getStackTrace(e));
            id = -1L;
        }
        return id;
    }

    @Override
    public void onLoadMore(int offScreenY) {
        try {
            String offset = this.getDomObject().getAttrs().getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                offset = "0";
            }
            if (offScreenY < Integer.parseInt(offset)) {
                String loadMoreRetry = this.getDomObject().getAttrs().getLoadMoreRetry();
                if (loadMoreRetry == null) {
                    loadMoreRetry = this.mLoadMoreRetry;
                }
                if (this.mListCellCount != this.mChildren.size() || this.mLoadMoreRetry == null || !this.mLoadMoreRetry.equals(loadMoreRetry)) {
                    this.getInstance().fireEvent(this.getDomObject().getRef(), "loadmore");
                    this.mListCellCount = this.mChildren.size();
                    this.mLoadMoreRetry = loadMoreRetry;
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.d(this.TAG + "onLoadMore :", e);
        }
    }

    @Override
    public void notifyAppearStateChange(int firstVisible, int lastVisible, int directionX, int directionY) {
        String direction;
        Iterator<AppearanceHelper> it = this.mAppearComponents.values().iterator();
        String string2 = direction = directionY > 0 ? "up" : "down";
        if (this.getOrientation() == 0) {
            String string3 = direction = directionX > 0 ? "left" : "right";
        }
        while (it.hasNext()) {
            boolean outOfVisibleRange;
            AppearanceHelper item = it.next();
            WXComponent component = item.getAwareChild();
            if (!item.isWatch()) continue;
            boolean bl = outOfVisibleRange = item.getCellPositionINScollable() < firstVisible || item.getCellPositionINScollable() > lastVisible;
            Object view = component.getHostView();
            if (view == null) continue;
            boolean visible = !outOfVisibleRange && item.isViewVisible();
            int result = item.setAppearStatus(visible);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("appear", "item " + item.getCellPositionINScollable() + " result " + result);
            }
            if (result == 0) continue;
            component.notifyAppearStateChange(result == 1 ? "appear" : "disappear", direction);
        }
    }

    private void recycleImage(View view) {
        if (view instanceof ImageView) {
            if (this.getInstance().getImgLoaderAdapter() != null) {
                this.getInstance().getImgLoaderAdapter().setImage(null, (ImageView)view, null, null);
            } else {
                if (WXEnvironment.isApkDebugable()) {
                    throw new WXRuntimeException("getImgLoaderAdapter() == null");
                }
                WXLogUtils.e("Error getImgLoaderAdapter() == null");
            }
        } else if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                this.recycleImage(((ViewGroup)view).getChildAt(i));
            }
        }
    }

    @NonNull
    private ListBaseViewHolder createVHForFakeComponent(int viewType) {
        FrameLayout view = new FrameLayout(this.getContext());
        view.setBackgroundColor(-1);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
        return new ListBaseViewHolder((View)view, viewType);
    }

    @JSMethod
    public void resetLoadmore() {
        this.mLoadMoreRetry = "";
    }

    private ListBaseViewHolder createVHForRefreshComponent(int viewType) {
        FrameLayout view = new FrameLayout(this.getContext());
        view.setBackgroundColor(-1);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, 1));
        view.setVisibility(8);
        return new ListBaseViewHolder((View)view, viewType);
    }
}

