/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.Component;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.IWebView;
import com.taobao.weex.ui.view.WXWebView;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;

@Component(lazyload=false)
public class WXWeb
extends WXComponent {
    protected IWebView mWebView;

    @Deprecated
    public WXWeb(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXWeb(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent, isLazy);
        this.createView();
    }

    protected void createView() {
        this.mWebView = new WXWebView(this.getContext());
    }

    protected View initComponentHostView(@NonNull Context context) {
        this.mWebView.setOnErrorListener(new IWebView.OnErrorListener(){

            @Override
            public void onError(String type, Object message) {
                WXWeb.this.fireEvent(type, message);
            }
        });
        this.mWebView.setOnPageListener(new IWebView.OnPageListener(){

            @Override
            public void onReceivedTitle(String title) {
                if (WXWeb.this.getDomObject().getEvents().contains("receivedtitle")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("title", title);
                    WXWeb.this.getInstance().fireEvent(WXWeb.this.getRef(), "receivedtitle", params);
                }
            }

            @Override
            public void onPageStart(String url) {
                if (WXWeb.this.getDomObject().getEvents().contains("pagestart")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("url", url);
                    WXWeb.this.getInstance().fireEvent(WXWeb.this.getRef(), "pagestart", params);
                }
            }

            @Override
            public void onPageFinish(String url, boolean canGoBack, boolean canGoForward) {
                if (WXWeb.this.getDomObject().getEvents().contains("pagefinish")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("url", url);
                    params.put("canGoBack", canGoBack);
                    params.put("canGoForward", canGoForward);
                    WXWeb.this.getInstance().fireEvent(WXWeb.this.getRef(), "pagefinish", params);
                }
            }
        });
        return this.mWebView.getView();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.getWebView().destroy();
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "show-loading": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setShowLoading(result);
                }
                return true;
            }
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setUrl(src);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="show-loading")
    public void setShowLoading(boolean showLoading) {
        this.getWebView().setShowLoading(showLoading);
    }

    @WXComponentProp(name="src")
    public void setUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url) || this.getHostView() == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.loadUrl(this.getInstance().rewriteUri(Uri.parse((String)url), "web").toString());
        }
    }

    public void setAction(String action) {
        if (!TextUtils.isEmpty((CharSequence)action)) {
            if (action.equals("goBack")) {
                this.goBack();
            } else if (action.equals("goForward")) {
                this.goForward();
            } else if (action.equals("reload")) {
                this.reload();
            }
        }
    }

    private void fireEvent(String type, Object message) {
        if (this.getDomObject().getEvents().contains("error")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", type);
            params.put("errorMsg", message);
            this.getInstance().fireEvent(this.getRef(), "error", params);
        }
    }

    private void loadUrl(String url) {
        this.getWebView().loadUrl(url);
    }

    private void reload() {
        this.getWebView().reload();
    }

    private void goForward() {
        this.getWebView().goForward();
    }

    private void goBack() {
        this.getWebView().goBack();
    }

    private IWebView getWebView() {
        return this.mWebView;
    }
}

