/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.WXDomHandler;
import com.taobao.weex.dom.WXDomStatement;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class WXDomManager {
    private WXThread mDomThread;
    Handler mDomHandler;
    private WXRenderManager mWXRenderManager;
    private ConcurrentHashMap<String, WXDomStatement> mDomRegistries;

    public WXDomManager(WXRenderManager renderManager) {
        this.mWXRenderManager = renderManager;
        this.mDomRegistries = new ConcurrentHashMap();
        this.mDomThread = new WXThread("WeeXDomThread", new WXDomHandler(this));
        this.mDomHandler = this.mDomThread.getHandler();
    }

    public void sendEmptyMessageDelayed(int what, long delayMillis) {
        if (this.mDomHandler == null || this.mDomThread == null || !this.mDomThread.isWXThreadAlive() || this.mDomThread.getLooper() == null) {
            return;
        }
        this.mDomHandler.sendEmptyMessageDelayed(what, delayMillis);
    }

    public void sendMessage(Message msg) {
        if (msg == null || this.mDomHandler == null || this.mDomThread == null || !this.mDomThread.isWXThreadAlive() || this.mDomThread.getLooper() == null) {
            return;
        }
        this.mDomHandler.sendMessage(msg);
    }

    public void removeDomStatement(String instanceId) {
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXDomManager] removeDomStatement");
        }
        final WXDomStatement statement = this.mDomRegistries.remove(instanceId);
        if (statement != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    statement.destroy();
                }
            });
        }
    }

    public void post(Runnable task) {
        if (this.mDomHandler == null || task == null || this.mDomThread == null || !this.mDomThread.isWXThreadAlive() || this.mDomThread.getLooper() == null) {
            return;
        }
        this.mDomHandler.post(WXThread.secure(task));
    }

    public void destroy() {
        if (this.mDomThread != null && this.mDomThread.isWXThreadAlive()) {
            this.mDomThread.quit();
        }
        if (this.mDomRegistries != null) {
            this.mDomRegistries.clear();
        }
        this.mDomHandler = null;
        this.mDomThread = null;
    }

    void createBody(String instanceId, JSONObject element) {
        this.throwIfNotDomThread();
        WXDomStatement statement = new WXDomStatement(instanceId, this.mWXRenderManager);
        this.mDomRegistries.put(instanceId, statement);
        statement.createBody(element);
    }

    private boolean isDomThread() {
        return !WXEnvironment.isApkDebugable() || Thread.currentThread().getId() == this.mDomThread.getId();
    }

    void batch() {
        this.throwIfNotDomThread();
        Iterator<Map.Entry<String, WXDomStatement>> iterator = this.mDomRegistries.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().batch();
        }
    }

    void addDom(String instanceId, String parentRef, JSONObject element, int index) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.addDom(element, parentRef, index);
    }

    void invokeMethod(String instanceId, String ref, String method, JSONArray args) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.invokeMethod(ref, method, args);
    }

    private void throwIfNotDomThread() {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("dom operation must be done in dom thread");
        }
    }

    void removeDom(String instanceId, String ref) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.removeDom(ref);
    }

    void moveDom(String instanceId, String ref, String parentRef, int index) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.moveDom(ref, parentRef, index);
    }

    void updateAttrs(String instanceId, String ref, JSONObject attr) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.updateAttrs(ref, attr);
    }

    void updateStyle(String instanceId, String ref, JSONObject style) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.updateStyle(ref, style);
    }

    void addEvent(String instanceId, String ref, String type) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.addEvent(ref, type);
    }

    void removeEvent(String instanceId, String ref, String type) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.removeEvent(ref, type);
    }

    void scrollToDom(String instanceId, String ref, JSONObject options) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.scrollToDom(ref, options);
    }

    void createFinish(String instanceId) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.createFinish();
    }

    void refreshFinish(String instanceId) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.refreshFinish();
    }

    void updateFinish(String instanceId) {
        this.throwIfNotDomThread();
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.updateFinish();
    }

    void startAnimation(@NonNull String instanceId, @NonNull String ref, @NonNull String animation, @Nullable String callBack) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("RefreshFinish operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.startAnimation(ref, animation, callBack);
    }

    public void addRule(String instanceId, String type, JSONObject jsonObject) {
        FontDO fontDO;
        if ("fontFace".equals(type) && (fontDO = this.parseFontDO(jsonObject, this.mWXRenderManager.getWXSDKInstance(instanceId))) != null && !TextUtils.isEmpty((CharSequence)fontDO.getFontFamilyName())) {
            FontDO cacheFontDO = TypefaceUtil.getFontDO(fontDO.getFontFamilyName());
            if (cacheFontDO == null || !TextUtils.equals((CharSequence)cacheFontDO.getUrl(), (CharSequence)fontDO.getUrl())) {
                TypefaceUtil.putFontDO(fontDO);
                TypefaceUtil.loadTypeface(fontDO);
            } else {
                TypefaceUtil.loadTypeface(cacheFontDO);
            }
        }
    }

    private FontDO parseFontDO(JSONObject jsonObject, WXSDKInstance instance) {
        if (jsonObject == null) {
            return null;
        }
        String src = jsonObject.getString("src");
        String name = jsonObject.getString("fontFamily");
        return new FontDO(name, src, instance);
    }

    public void getComponentSize(String instanceId, String ref, String callback) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("getComponentSize operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("result", false);
            options.put("errMsg", "Component does not exist");
            WXSDKManager.getInstance().callback(instanceId, callback, options);
            return;
        }
        statement.getComponentSize(ref, callback);
    }
}

