/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.content.Intent;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.JSCallbackCreator;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.WXDomModule;
import com.taobao.weex.ui.module.WXTimerModule;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WXModuleManager {
    private static Map<String, ModuleFactory> sModuleFactoryMap = new HashMap<String, ModuleFactory>();
    private static Map<String, WXModule> sGlobalModuleMap = new HashMap<String, WXModule>();
    private static Map<String, HashMap<String, WXModule>> sInstanceModuleMap = new HashMap<String, HashMap<String, WXModule>>();

    public static boolean registerModule(final String moduleName, final ModuleFactory factory, final boolean global) throws WXException {
        if (moduleName == null || factory == null) {
            return false;
        }
        if (TextUtils.equals((CharSequence)moduleName, (CharSequence)"dom")) {
            WXLogUtils.e("Cannot registered module with name 'dom'.");
            return false;
        }
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (sModuleFactoryMap.containsKey(moduleName)) {
                    WXLogUtils.w("WXComponentRegistry Duplicate the Module name: " + moduleName);
                }
                if (global) {
                    try {
                        Object wxModule = factory.buildInstance();
                        sGlobalModuleMap.put(moduleName, wxModule);
                    }
                    catch (Exception e) {
                        WXLogUtils.e(moduleName + " class must have a default constructor without params. ", e);
                    }
                }
                try {
                    WXModuleManager.registerNativeModule(moduleName, factory);
                }
                catch (WXException e) {
                    WXLogUtils.e("", e);
                }
                WXModuleManager.registerJSModule(moduleName, factory);
            }
        });
        return true;
    }

    static boolean registerNativeModule(String moduleName, ModuleFactory factory) throws WXException {
        if (factory == null) {
            return false;
        }
        try {
            sModuleFactoryMap.put(moduleName, factory);
        }
        catch (ArrayStoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    static boolean registerJSModule(String moduleName, ModuleFactory factory) {
        HashMap<String, Object> modules = new HashMap<String, Object>();
        modules.put(moduleName, factory.getMethodNames());
        WXSDKManager.getInstance().registerModules(modules);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean callModuleMethod(final String instanceId, String moduleStr, String methodStr, JSONArray args) {
        ModuleFactory factory = sModuleFactoryMap.get(moduleStr);
        if (factory == null) {
            WXLogUtils.e("[WXModuleManager] module factory not found.");
            return false;
        }
        final WXModule wxModule = WXModuleManager.findModule(instanceId, moduleStr, factory);
        if (wxModule == null) {
            return false;
        }
        wxModule.mWXSDKInstance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        Map<String, Invoker> methodsMap = factory.getMethodMap();
        if (methodsMap == null) {
            WXLogUtils.e("[WXModuleManager] callModuleMethod methodsMap is null.");
            return false;
        }
        final Invoker invoker = methodsMap.get(methodStr);
        try {
            final Object[] params = WXReflectionUtils.prepareArguments(invoker.getParameterTypes(), args, new JSCallbackCreator(){

                @Override
                public JSCallback create(String callbackId) {
                    return new SimpleJSCallback(instanceId, callbackId);
                }
            });
            if (invoker.isRunInUIThread()) {
                WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            invoker.invoke(wxModule, params);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, 0L);
            } else {
                invoker.invoke(wxModule, params);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("callModuleMethod >>> invoke module:" + moduleStr + ", method:" + methodStr + " failed. ", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (wxModule instanceof WXDomModule || wxModule instanceof WXTimerModule) {
                wxModule.mWXSDKInstance = null;
            }
        }
        return true;
    }

    private static WXModule findModule(String instanceId, String moduleStr, ModuleFactory factory) {
        WXModule wxModule = sGlobalModuleMap.get(moduleStr);
        if (wxModule == null) {
            HashMap<String, WXModule> moduleMap = sInstanceModuleMap.get(instanceId);
            if (moduleMap == null) {
                moduleMap = new HashMap();
                sInstanceModuleMap.put(instanceId, moduleMap);
            }
            if ((wxModule = moduleMap.get(moduleStr)) == null) {
                try {
                    wxModule = factory.buildInstance();
                }
                catch (Exception e) {
                    WXLogUtils.e(moduleStr + " module build instace failed.", e);
                    return null;
                }
                moduleMap.put(moduleStr, wxModule);
            }
        }
        return wxModule;
    }

    public static void onActivityResult(String instanceId, int requestCode, int resultCode, Intent data) {
        HashMap<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        for (String key : modules.keySet()) {
            WXModule module = modules.get(key);
            if (module != null) {
                module.onActivityResult(requestCode, resultCode, data);
                continue;
            }
            WXLogUtils.w("onActivityResult can not find the " + key + " module");
        }
    }

    public static void destroyInstanceModules(String instanceId) {
        HashMap<String, WXModule> moduleMap = sInstanceModuleMap.remove(instanceId);
        if (moduleMap == null || moduleMap.size() < 1) {
            return;
        }
        for (Map.Entry<String, WXModule> entry : moduleMap.entrySet()) {
            WXModule module = entry.getValue();
            if (!(module instanceof Destroyable)) continue;
            ((Destroyable)((Object)module)).destroy();
        }
    }

    public static void reload() {
        if (sModuleFactoryMap != null) {
            Set<String> keys = sModuleFactoryMap.keySet();
            for (String key : keys) {
                WXModuleManager.registerJSModule(key, sModuleFactoryMap.get(key));
            }
        }
    }
}

