/**
 *
 *                                  Apache License
 *                            Version 2.0, January 2004
 *                         http://www.apache.org/licenses/
 *
 *    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 *
 *    1. Definitions.
 *
 *       "License" shall mean the terms and conditions for use, reproduction,
 *       and distribution as defined by Sections 1 through 9 of this document.
 *
 *       "Licensor" shall mean the copyright owner or entity authorized by
 *       the copyright owner that is granting the License.
 *
 *       "Legal Entity" shall mean the union of the acting entity and all
 *       other entities that control, are controlled by, or are under common
 *       control with that entity. For the purposes of this definition,
 *       "control" means (i) the power, direct or indirect, to cause the
 *       direction or management of such entity, whether by contract or
 *       otherwise, or (ii) ownership of fifty percent (50%) or more of the
 *       outstanding shares, or (iii) beneficial ownership of such entity.
 *
 *       "You" (or "Your") shall mean an individual or Legal Entity
 *       exercising permissions granted by this License.
 *
 *       "Source" form shall mean the preferred form for making modifications,
 *       including but not limited to software source code, documentation
 *       source, and configuration files.
 *
 *       "Object" form shall mean any form resulting from mechanical
 *       transformation or translation of a Source form, including but
 *       not limited to compiled object code, generated documentation,
 *       and conversions to other media types.
 *
 *       "Work" shall mean the work of authorship, whether in Source or
 *       Object form, made available under the License, as indicated by a
 *       copyright notice that is included in or attached to the work
 *       (an example is provided in the Appendix below).
 *
 *       "Derivative Works" shall mean any work, whether in Source or Object
 *       form, that is based on (or derived from) the Work and for which the
 *       editorial revisions, annotations, elaborations, or other modifications
 *       represent, as a whole, an original work of authorship. For the purposes
 *       of this License, Derivative Works shall not include works that remain
 *       separable from, or merely link (or bind by name) to the interfaces of,
 *       the Work and Derivative Works thereof.
 *
 *       "Contribution" shall mean any work of authorship, including
 *       the original version of the Work and any modifications or additions
 *       to that Work or Derivative Works thereof, that is intentionally
 *       submitted to Licensor for inclusion in the Work by the copyright owner
 *       or by an individual or Legal Entity authorized to submit on behalf of
 *       the copyright owner. For the purposes of this definition, "submitted"
 *       means any form of electronic, verbal, or written communication sent
 *       to the Licensor or its representatives, including but not limited to
 *       communication on electronic mailing lists, source code control systems,
 *       and issue tracking systems that are managed by, or on behalf of, the
 *       Licensor for the purpose of discussing and improving the Work, but
 *       excluding communication that is conspicuously marked or otherwise
 *       designated in writing by the copyright owner as "Not a Contribution."
 *
 *       "Contributor" shall mean Licensor and any individual or Legal Entity
 *       on behalf of whom a Contribution has been received by Licensor and
 *       subsequently incorporated within the Work.
 *
 *    2. Grant of Copyright License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       copyright license to reproduce, prepare Derivative Works of,
 *       publicly display, publicly perform, sublicense, and distribute the
 *       Work and such Derivative Works in Source or Object form.
 *
 *    3. Grant of Patent License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       (except as stated in this section) patent license to make, have made,
 *       use, offer to sell, sell, import, and otherwise transfer the Work,
 *       where such license applies only to those patent claims licensable
 *       by such Contributor that are necessarily infringed by their
 *       Contribution(s) alone or by combination of their Contribution(s)
 *       with the Work to which such Contribution(s) was submitted. If You
 *       institute patent litigation against any entity (including a
 *       cross-claim or counterclaim in a lawsuit) alleging that the Work
 *       or a Contribution incorporated within the Work constitutes direct
 *       or contributory patent infringement, then any patent licenses
 *       granted to You under this License for that Work shall terminate
 *       as of the date such litigation is filed.
 *
 *    4. Redistribution. You may reproduce and distribute copies of the
 *       Work or Derivative Works thereof in any medium, with or without
 *       modifications, and in Source or Object form, provided that You
 *       meet the following conditions:
 *
 *       (a) You must give any other recipients of the Work or
 *           Derivative Works a copy of this License; and
 *
 *       (b) You must cause any modified files to carry prominent notices
 *           stating that You changed the files; and
 *
 *       (c) You must retain, in the Source form of any Derivative Works
 *           that You distribute, all copyright, patent, trademark, and
 *           attribution notices from the Source form of the Work,
 *           excluding those notices that do not pertain to any part of
 *           the Derivative Works; and
 *
 *       (d) If the Work includes a "NOTICE" text file as part of its
 *           distribution, then any Derivative Works that You distribute must
 *           include a readable copy of the attribution notices contained
 *           within such NOTICE file, excluding those notices that do not
 *           pertain to any part of the Derivative Works, in at least one
 *           of the following places: within a NOTICE text file distributed
 *           as part of the Derivative Works; within the Source form or
 *           documentation, if provided along with the Derivative Works; or,
 *           within a display generated by the Derivative Works, if and
 *           wherever such third-party notices normally appear. The contents
 *           of the NOTICE file are for informational purposes only and
 *           do not modify the License. You may add Your own attribution
 *           notices within Derivative Works that You distribute, alongside
 *           or as an addendum to the NOTICE text from the Work, provided
 *           that such additional attribution notices cannot be construed
 *           as modifying the License.
 *
 *       You may add Your own copyright statement to Your modifications and
 *       may provide additional or different license terms and conditions
 *       for use, reproduction, or distribution of Your modifications, or
 *       for any such Derivative Works as a whole, provided Your use,
 *       reproduction, and distribution of the Work otherwise complies with
 *       the conditions stated in this License.
 *
 *    5. Submission of Contributions. Unless You explicitly state otherwise,
 *       any Contribution intentionally submitted for inclusion in the Work
 *       by You to the Licensor shall be under the terms and conditions of
 *       this License, without any additional terms or conditions.
 *       Notwithstanding the above, nothing herein shall supersede or modify
 *       the terms of any separate license agreement you may have executed
 *       with Licensor regarding such Contributions.
 *
 *    6. Trademarks. This License does not grant permission to use the trade
 *       names, trademarks, service marks, or product names of the Licensor,
 *       except as required for reasonable and customary use in describing the
 *       origin of the Work and reproducing the content of the NOTICE file.
 *
 *    7. Disclaimer of Warranty. Unless required by applicable law or
 *       agreed to in writing, Licensor provides the Work (and each
 *       Contributor provides its Contributions) on an "AS IS" BASIS,
 *       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *       implied, including, without limitation, any warranties or conditions
 *       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 *       PARTICULAR PURPOSE. You are solely responsible for determining the
 *       appropriateness of using or redistributing the Work and assume any
 *       risks associated with Your exercise of permissions under this License.
 *
 *    8. Limitation of Liability. In no event and under no legal theory,
 *       whether in tort (including negligence), contract, or otherwise,
 *       unless required by applicable law (such as deliberate and grossly
 *       negligent acts) or agreed to in writing, shall any Contributor be
 *       liable to You for damages, including any direct, indirect, special,
 *       incidental, or consequential damages of any character arising as a
 *       result of this License or out of the use or inability to use the
 *       Work (including but not limited to damages for loss of goodwill,
 *       work stoppage, computer failure or malfunction, or any and all
 *       other commercial damages or losses), even if such Contributor
 *       has been advised of the possibility of such damages.
 *
 *    9. Accepting Warranty or Additional Liability. While redistributing
 *       the Work or Derivative Works thereof, You may choose to offer,
 *       and charge a fee for, acceptance of support, warranty, indemnity,
 *       or other liability obligations and/or rights consistent with this
 *       License. However, in accepting such obligations, You may act only
 *       on Your own behalf and on Your sole responsibility, not on behalf
 *       of any other Contributor, and only if You agree to indemnify,
 *       defend, and hold each Contributor harmless for any liability
 *       incurred by, or claims asserted against, such Contributor by reason
 *       of your accepting any such warranty or additional liability.
 *
 *    END OF TERMS AND CONDITIONS
 *
 *    APPENDIX: How to apply the Apache License to your work.
 *
 *       To apply the Apache License to your work, attach the following
 *       boilerplate notice, with the fields enclosed by brackets "[]"
 *       replaced with your own identifying information. (Don't include
 *       the brackets!)  The text should be enclosed in the appropriate
 *       comment syntax for the file format. We also recommend that a
 *       file or class name and description of purpose be included on the
 *       same "printed page" as the copyright notice for easier
 *       identification within third-party archives.
 *
 *    Copyright 2016 Alibaba Group
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * Known Issus: In auto play mode, neighbor view not scaled or aplhaed rarely.
 *
 * Created by xingjiu on 16/8/18.
 */
public class WXSliderNeighbor extends WXSlider {
    public static final String NEIGHBOR_SCALE = "neighborScale"; // the init scale of neighbor page
    public static final String NEIGHBOR_ALPHA = "neighborAlpha"; // the init alpha of neighbor page
    public static final String NEIGHBOR_SPACE = "neighborSpace"; // the init space of neighbor page

    private static final int DEFAULT_NEIGHBOR_SPACE = 25;
    private static final float DEFAULT_NEIGHBOR_SCALE = 0.8F;
    private static final float DEFAULT_NEIGHBOR_ALPHA = 0.6F;

    private float mNeighborScale = DEFAULT_NEIGHBOR_SCALE;
    private float mNeighborAlpha = DEFAULT_NEIGHBOR_ALPHA;
    private float mNeighborSpace = DEFAULT_NEIGHBOR_SPACE;

    private static final float WX_DEFAULT_MAIN_NEIGHBOR_SCALE = 0.9f;

    public WXSliderNeighbor(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    public static class Creator implements ComponentCreator {
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXSliderNeighbor(instance, node, parent);
        }
    }

    @Override
    public void bindData(WXComponent component) {
        super.bindData(component);
        if(mAdapter.getRealCount() > 3){
            mViewPager.setOffscreenPageLimit(2);
        }else if(mAdapter.getRealCount() == 3){
            mViewPager.setOffscreenPageLimit(1);
        }

    }

    @Override
    protected FrameLayout initComponentHostView(@NonNull Context context) {
        FrameLayout view = new FrameLayout(context);

        // init view pager
        FrameLayout.LayoutParams pagerParams = new FrameLayout.LayoutParams(
                FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT);
        pagerParams.gravity = Gravity.CENTER;
        mViewPager = new WXCircleViewPager(getContext());
        mViewPager.setLayoutParams(pagerParams);

        // init adapter
        mAdapter = new WXCirclePageAdapter();
        mViewPager.setAdapter(mAdapter);

        // add to parent
        view.addView(mViewPager);
        mViewPager.addOnPageChangeListener(mPageChangeListener);

        // set animation
        mViewPager.setPageTransformer(true, createTransformer());
        mViewPager.setOverScrollMode(View.OVER_SCROLL_NEVER);
//        view.setClipChildren(false);
        registerActivityStateListener();

        return view;
    }

    ZoomTransformer createTransformer() {
        return new ZoomTransformer();
    }

    @Override
    protected void addSubView(View view, int index) {
        updateScaleAndAlpha(view, mNeighborAlpha, mNeighborScale); // we need to set neighbor view status when added.
        if (view == null || mAdapter == null) {
            return;
        }

        if (view instanceof WXCircleIndicator) {
            return;
        }

        FrameLayout wrapper = new FrameLayout(getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.gravity = Gravity.CENTER;
        view.setLayoutParams(params);
        wrapper.addView(view);
        super.addSubView(wrapper,index);
    }

    private void updateScaleAndAlpha(View view, float alpha, float scale) {
        if(null == view) {
            return;
        }
        if(alpha >= 0) {
            view.setAlpha(alpha);
        }
        if(scale >= 0) {
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private void updateAdapterScaleAndAlpha(float alpha, float scale) {
        List<View> pageViews = mAdapter.getViews();
        int cusPos = mViewPager.getCurrentItem();
        if(null != pageViews && pageViews.size() > 0) {
            for(View v : pageViews) {
                View realView = ((ViewGroup)v).getChildAt(0);

                if(mAdapter.getItemIndex(v) != cusPos) {
                    updateScaleAndAlpha(realView, alpha, scale);
                }else{
                    updateScaleAndAlpha(realView,1.0F,WX_DEFAULT_MAIN_NEIGHBOR_SCALE);
                }
            }
        }
    }

    @WXComponentProp(name = NEIGHBOR_SCALE)
    public void setNeighborScale(String input) {
        float neighborScale = DEFAULT_NEIGHBOR_SCALE;
        if (!TextUtils.isEmpty(input)) {
            try {
                neighborScale = Float.parseFloat(input);
            } catch (NumberFormatException e) {
            }
        }

        // addSubView is called before setProperty, so we need to modify the neighbor view in mAdapter.
        if(this.mNeighborScale != neighborScale) {
            this.mNeighborScale = neighborScale;
            updateAdapterScaleAndAlpha(-1, neighborScale);
        }
    }

    @WXComponentProp(name = NEIGHBOR_ALPHA)
    public void setNeighborAlpha(String input) {
        float neighborAlpha = DEFAULT_NEIGHBOR_ALPHA;
        if (!TextUtils.isEmpty(input)) {
            try {
                neighborAlpha = Float.parseFloat(input);
            } catch (NumberFormatException e) {
            }
        }

        // The same work as setNeighborScale()
        if(this.mNeighborAlpha != neighborAlpha) {
            this.mNeighborAlpha = neighborAlpha;
            updateAdapterScaleAndAlpha(neighborAlpha, -1);
        }
    }

    @WXComponentProp(name = NEIGHBOR_SPACE)
    @SuppressWarnings("unused")
    public void setNeighborSpace(String input) {
        float neighborSpace = DEFAULT_NEIGHBOR_SPACE;
        if (!TextUtils.isEmpty(input)) {
            try {
                neighborSpace = Float.parseFloat(input);
            } catch (NumberFormatException e) {
            }
        }

        // The same work as setNeighborScale()
        if(this.mNeighborSpace != neighborSpace) {
            this.mNeighborSpace = neighborSpace;
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        String input;
        switch (key) {
            case NEIGHBOR_SCALE:
                input = WXUtils.getString(param, null);
                if (input != null) {
                    setNeighborScale(input);
                }
                return true;
            case NEIGHBOR_ALPHA:
                input = WXUtils.getString(param, null);
                if (input != null) {
                    setNeighborAlpha(input);
                }
                return true;
            case NEIGHBOR_SPACE:
                input = WXUtils.getString(param, null);
                if (input != null) {
                    setNeighborSpace(input);
                }
                return true;
        }
        return super.setProperty(key, param);
    }

    // Here is the trick.
    class ZoomTransformer implements ViewPager.PageTransformer {
        @Override
        public void transformPage(View page, float position) {
            View realView = ((ViewGroup)page).getChildAt(0);
            if(realView == null){
                return;
            }
            float alpha, scale;

            if(position <= (-mAdapter.getRealCount() + 1)) {
                position = position + mAdapter.getRealCount();
            }
            if(position >= mAdapter.getRealCount() - 1) {
                position = position - mAdapter.getRealCount();
            }

            if (position >= -1 && position <= 1) {
                float factor = Math.abs(Math.abs(position) - 1);
                scale = mNeighborScale + factor * (WX_DEFAULT_MAIN_NEIGHBOR_SCALE- mNeighborScale);
                alpha = (1- mNeighborAlpha) * factor + mNeighborAlpha;

                float translation = (page.getMeasuredWidth()-realView.getMeasuredWidth()*mNeighborScale)/4;
                translation += ((page.getMeasuredWidth()-realView.getMeasuredWidth()*WX_DEFAULT_MAIN_NEIGHBOR_SCALE)/2 - WXViewUtils.getRealPxByWidth(mNeighborSpace))/2 ;
                if(position > 0){
                    translation = (position*translation);
                    realView.setTranslationX(-translation);
                    page.setTranslationX(-translation);
                }else if(position == 0){
                    page.setTranslationX(0);
                    realView.setTranslationX(0);
                }else{
                    translation = (-position*translation);
                    realView.setTranslationX(translation);
                    page.setTranslationX(translation);
                }

                realView.setPivotY(realView.getMeasuredHeight()/2);

                realView.setAlpha(alpha);
                realView.setScaleX(scale);
                realView.setScaleY(scale);
            }
        }
    }

}