/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.text.TextUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class WXFileUtils {
    public static String loadAsset(String path, Context context) {
        if (path == null || context == null) {
            return null;
        }
        try {
            InputStream in = context.getAssets().open(path);
            StringBuilder builder = new StringBuilder(in.available() + 10);
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(in));
            char[] data = new char[2048];
            int len = -1;
            while ((len = localBufferedReader.read(data)) > 0) {
                builder.append(data, 0, len);
            }
            localBufferedReader.close();
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    WXLogUtils.e("WXFileUtils loadAsset: ", e);
                }
            }
            return builder.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            WXLogUtils.e("", e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFile(String path, byte[] content, Context context) {
        if (TextUtils.isEmpty((CharSequence)path) || content == null || context == null) {
            return false;
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(path);
            outStream.write(content);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            WXLogUtils.e("WXFileUtils saveFile: " + WXLogUtils.getStackTrace(e));
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

