/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.core;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.view.refresh.circlebar.CircleProgressBar;

public class WXRefreshView
extends FrameLayout {
    private CircleProgressBar circleProgressBar;
    private LinearLayout linearLayout;

    public WXRefreshView(Context context) {
        super(context);
        this.setupViews();
    }

    public WXRefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupViews();
    }

    public WXRefreshView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupViews();
    }

    private void setupViews() {
        this.linearLayout = new LinearLayout(this.getContext());
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        this.linearLayout.setOrientation(1);
        this.linearLayout.setGravity(17);
        this.addView((View)this.linearLayout, (ViewGroup.LayoutParams)lp);
    }

    public boolean post(Runnable action) {
        return super.post(WXThread.secure(action));
    }

    public void setRefreshView(final View view) {
        if (view == null) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                View child = null;
                View temp = view;
                if (view.getParent() != null) {
                    ((ViewGroup)view.getParent()).removeView(view);
                }
                for (int i = 0; i < ((ViewGroup)temp).getChildCount(); ++i) {
                    child = ((ViewGroup)temp).getChildAt(i);
                    if (!(child instanceof CircleProgressBar)) continue;
                    WXRefreshView.this.circleProgressBar = (CircleProgressBar)child;
                }
                WXRefreshView.this.linearLayout.addView(temp);
            }
        });
    }

    public void setProgressBgColor(int color) {
        if (this.circleProgressBar != null) {
            this.circleProgressBar.setBackgroundColor(color);
        }
    }

    public void setProgressColor(int color) {
        if (this.circleProgressBar != null) {
            this.circleProgressBar.setColorSchemeColors(color);
        }
    }

    protected void startAnimation() {
        if (this.circleProgressBar != null) {
            this.circleProgressBar.start();
        }
    }

    public void setStartEndTrim(float startAngle, float endAngle) {
        if (this.circleProgressBar != null) {
            this.circleProgressBar.setStartEndTrim(startAngle, endAngle);
        }
    }

    protected void stopAnimation() {
        if (this.circleProgressBar != null) {
            this.circleProgressBar.stop();
        }
    }

    public void setProgressRotation(float rotation) {
        if (this.circleProgressBar != null) {
            this.circleProgressBar.setProgressRotation(rotation);
        }
    }
}

