/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.taobao.weex.dom.flex.FloatUtil;
import com.taobao.weex.ui.view.border.BorderEdge;
import com.taobao.weex.ui.view.border.BorderStyle;
import com.taobao.weex.ui.view.border.BottomLeftCorner;
import com.taobao.weex.ui.view.border.BottomRightCorner;
import com.taobao.weex.ui.view.border.TopLeftCorner;
import com.taobao.weex.ui.view.border.TopRightCorner;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class BorderDrawable
extends Drawable {
    public static final int BORDER_TOP_LEFT_RADIUS = 0;
    public static final int BORDER_TOP_RIGHT_RADIUS = 1;
    public static final int BORDER_BOTTOM_RIGHT_RADIUS = 2;
    public static final int BORDER_BOTTOM_LEFT_RADIUS = 3;
    public static final int BORDER_RADIUS_ALL = 8;
    static final int DEFAULT_BORDER_COLOR = -16777216;
    static final float DEFAULT_BORDER_WIDTH = 0.0f;
    static final float DEFAULT_BORDER_RADIUS = 0.0f;
    static final BorderStyle DEFAULT_BORDER_STYLE = BorderStyle.SOLID;
    private static final String TAG = "Border";
    private final Paint mPaint = new Paint(1);
    @Nullable
    private SparseArray<Float> mBorderWidth;
    @Nullable
    private SparseArray<Float> mBorderRadius;
    @Nullable
    private SparseArray<Float> mOverlappingBorderRadius;
    @Nullable
    private SparseArray<Integer> mBorderColor;
    @Nullable
    private SparseArray<Integer> mBorderStyle;
    @Nullable
    private Path mPathForBorderOutline;
    private boolean mNeedUpdatePath = false;
    private int mColor = 0;
    private int mAlpha = 255;

    public void draw(Canvas canvas) {
        int useColor;
        canvas.save();
        this.updateBorderOutline();
        if (this.mPathForBorderOutline != null && (useColor = WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha)) >>> 24 != 0) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(useColor);
            this.mPaint.setShader(null);
            canvas.drawPath(this.mPathForBorderOutline, this.mPaint);
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.drawBorders(canvas);
        this.mPaint.setShader(null);
        canvas.restore();
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mNeedUpdatePath = true;
    }

    public void setBorderWidth(int position, float width) {
        if (this.mBorderWidth == null) {
            this.mBorderWidth = new SparseArray(5);
            this.mBorderWidth.put(8, (Object)Float.valueOf(0.0f));
        }
        if (!FloatUtil.floatsEqual(this.getBorderWidth(position), width)) {
            this.updateSparseArray(this.mBorderWidth, position, Float.valueOf(width));
            this.mBorderWidth.put(position, (Object)Float.valueOf(width));
            this.mNeedUpdatePath = true;
            this.invalidateSelf();
        }
    }

    float getBorderWidth(int position) {
        return this.fetchFromSparseArray(this.mBorderWidth, position, Float.valueOf(0.0f)).floatValue();
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    private <T> void updateSparseArray(@NonNull SparseArray<T> array, int position, T value) {
        this.updateSparseArray(array, position, value, true);
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    private <T> T fetchFromSparseArray(@Nullable SparseArray<T> array, int position, T fallback) {
        return (T)(array == null ? fallback : array.get(position, array.get(8)));
    }

    public void setColorFilter(ColorFilter cf) {
    }

    private <T> void updateSparseArray(@NonNull SparseArray<T> array, int position, T value, boolean useSpacing) {
        if (useSpacing) {
            if (position == 8) {
                array.put(8, value);
                array.put(1, value);
                array.put(0, value);
                array.put(2, value);
                array.put(3, value);
            } else {
                array.put(position, value);
            }
        } else if (position == 8) {
            array.put(8, value);
            array.put(0, value);
            array.put(1, value);
            array.put(3, value);
            array.put(2, value);
        } else {
            array.put(position, value);
        }
    }

    public int getOpacity() {
        return WXViewUtils.getOpacityFromColor(WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha));
    }

    public void setBorderRadius(int position, float radius) {
        if (this.mBorderRadius == null) {
            this.mBorderRadius = new SparseArray(5);
            this.mBorderRadius.put(8, (Object)Float.valueOf(0.0f));
        }
        if (!FloatUtil.floatsEqual(this.getBorderRadius(this.mBorderRadius, position), radius)) {
            this.updateSparseArray(this.mBorderRadius, position, Float.valueOf(radius), false);
            this.mNeedUpdatePath = true;
            this.invalidateSelf();
        }
    }

    public void getOutline(@NonNull Outline outline) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.mPathForBorderOutline == null) {
                this.mNeedUpdatePath = true;
            }
            this.updateBorderOutline();
            outline.setConvexPath(this.mPathForBorderOutline);
        }
    }

    float getBorderRadius(@Nullable SparseArray<Float> borderRadius, int position) {
        return this.fetchFromSparseArray(borderRadius, position, Float.valueOf(0.0f)).floatValue();
    }

    public void setBorderColor(int position, int color) {
        if (this.mBorderColor == null) {
            this.mBorderColor = new SparseArray(5);
            this.mBorderColor.put(8, (Object)-16777216);
        }
        if (this.getBorderColor(position) != color) {
            this.updateSparseArray(this.mBorderColor, position, color);
            this.invalidateSelf();
        }
    }

    int getBorderColor(int position) {
        return this.fetchFromSparseArray(this.mBorderColor, position, -16777216);
    }

    public void setBorderStyle(int position, @NonNull String style) {
        if (this.mBorderStyle == null) {
            this.mBorderStyle = new SparseArray(5);
            this.mBorderStyle.put(8, (Object)DEFAULT_BORDER_STYLE.ordinal());
        }
        try {
            int borderStyle = BorderStyle.valueOf(style.toUpperCase(Locale.US)).ordinal();
            if (this.getBorderStyle(position) != borderStyle) {
                this.updateSparseArray(this.mBorderStyle, position, borderStyle);
                this.invalidateSelf();
            }
        }
        catch (IllegalArgumentException e) {
            WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
        }
    }

    int getBorderStyle(int position) {
        return this.fetchFromSparseArray(this.mBorderStyle, position, BorderStyle.SOLID.ordinal());
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
        this.invalidateSelf();
    }

    @NonNull
    public Path getContentPath(int viewTopPadding, int viewRightPadding, int viewBottomPadding, int viewLeftPadding, @NonNull RectF contentBox) {
        RectF rectForBorderOutline = new RectF();
        Path contentClip = new Path();
        rectForBorderOutline.set(contentBox);
        if (this.mBorderRadius != null) {
            this.prepareBorderRadius();
            float topLeftRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 0);
            float topRightRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 1);
            float bottomRightRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 2);
            float bottomLeftRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 3);
            contentClip.addRoundRect(rectForBorderOutline, new float[]{topLeftRadius - (float)viewLeftPadding, topLeftRadius - (float)viewTopPadding, topRightRadius - (float)viewRightPadding, topRightRadius - (float)viewTopPadding, bottomRightRadius - (float)viewRightPadding, bottomRightRadius - (float)viewBottomPadding, bottomLeftRadius - (float)viewLeftPadding, bottomLeftRadius - (float)viewBottomPadding}, Path.Direction.CW);
        } else {
            contentClip.addRect(rectForBorderOutline, Path.Direction.CW);
        }
        return contentClip;
    }

    @Deprecated
    float getBorderRadius(int position) {
        return this.getBorderRadius(this.mOverlappingBorderRadius, position);
    }

    private void updateBorderOutline() {
        if (this.mNeedUpdatePath) {
            this.mNeedUpdatePath = false;
            if (this.mPathForBorderOutline == null) {
                this.mPathForBorderOutline = new Path();
            }
            this.mPathForBorderOutline.reset();
            RectF mRectForBorderOutline = new RectF();
            mRectForBorderOutline.set(this.getBounds());
            if (this.mBorderRadius != null) {
                this.prepareBorderRadius();
                float topLeftRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 0);
                float topRightRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 1);
                float bottomRightRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 2);
                float bottomLeftRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 3);
                this.mPathForBorderOutline.addRoundRect(mRectForBorderOutline, new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius}, Path.Direction.CW);
            } else {
                this.mPathForBorderOutline.addRect(mRectForBorderOutline, Path.Direction.CW);
            }
        }
    }

    private void drawBorders(Canvas canvas) {
        if (this.mBorderWidth != null) {
            RectF rectBounds = new RectF(this.getBounds());
            TopLeftCorner topLeft = new TopLeftCorner(this.getBorderRadius(this.mOverlappingBorderRadius, 0), this.getBorderWidth(0), this.getBorderWidth(1), rectBounds);
            TopRightCorner topRight = new TopRightCorner(this.getBorderRadius(this.mOverlappingBorderRadius, 1), this.getBorderWidth(1), this.getBorderWidth(2), rectBounds);
            BottomRightCorner bottomRight = new BottomRightCorner(this.getBorderRadius(this.mOverlappingBorderRadius, 2), this.getBorderWidth(2), this.getBorderWidth(3), rectBounds);
            BottomLeftCorner bottomLeft = new BottomLeftCorner(this.getBorderRadius(this.mOverlappingBorderRadius, 3), this.getBorderWidth(3), this.getBorderWidth(0), rectBounds);
            this.drawOneSide(canvas, new BorderEdge(topLeft, topRight, 1, this.getBorderWidth(1)));
            this.drawOneSide(canvas, new BorderEdge(topRight, bottomRight, 2, this.getBorderWidth(2)));
            this.drawOneSide(canvas, new BorderEdge(bottomRight, bottomLeft, 3, this.getBorderWidth(3)));
            this.drawOneSide(canvas, new BorderEdge(bottomLeft, topLeft, 0, this.getBorderWidth(0)));
        }
    }

    private void prepareBorderRadius() {
        if (this.mBorderRadius != null) {
            float factor = this.getScaleFactor();
            if (this.mOverlappingBorderRadius == null) {
                this.mOverlappingBorderRadius = new SparseArray(5);
                this.mOverlappingBorderRadius.put(8, (Object)Float.valueOf(0.0f));
            }
            if (!Float.isNaN(factor) && factor < 1.0f) {
                this.mOverlappingBorderRadius.put(0, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 0) * factor));
                this.mOverlappingBorderRadius.put(1, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 1) * factor));
                this.mOverlappingBorderRadius.put(2, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 2) * factor));
                this.mOverlappingBorderRadius.put(3, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 3) * factor));
            } else {
                this.mOverlappingBorderRadius.put(0, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 0)));
                this.mOverlappingBorderRadius.put(1, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 1)));
                this.mOverlappingBorderRadius.put(2, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 2)));
                this.mOverlappingBorderRadius.put(3, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 3)));
            }
        }
    }

    private float getScaleFactor() {
        Rect borderBox = this.getBounds();
        float topRadius = this.getBorderRadius(this.mBorderRadius, 0) + this.getBorderRadius(this.mBorderRadius, 1);
        float rightRadius = this.getBorderRadius(this.mBorderRadius, 1) + this.getBorderRadius(this.mBorderRadius, 2);
        float bottomRadius = this.getBorderRadius(this.mBorderRadius, 2) + this.getBorderRadius(this.mBorderRadius, 3);
        float leftRadius = this.getBorderRadius(this.mBorderRadius, 3) + this.getBorderRadius(this.mBorderRadius, 0);
        ArrayList<Float> factors = new ArrayList<Float>(4);
        this.updateFactor(factors, borderBox.width(), topRadius);
        this.updateFactor(factors, borderBox.height(), rightRadius);
        this.updateFactor(factors, borderBox.width(), bottomRadius);
        this.updateFactor(factors, borderBox.height(), leftRadius);
        float factor = factors.isEmpty() ? Float.NaN : Collections.min(factors).floatValue();
        return factor;
    }

    private void updateFactor(@NonNull List<Float> list, float numerator, float denominator) {
        if (!FloatUtil.floatsEqual(denominator, 0.0f)) {
            list.add(Float.valueOf(numerator / denominator));
        }
    }

    private void drawOneSide(Canvas canvas, @NonNull BorderEdge borderEdge) {
        if (!FloatUtil.floatsEqual(0.0f, this.getBorderWidth(borderEdge.getEdge()))) {
            this.preparePaint(borderEdge.getEdge());
            borderEdge.drawEdge(canvas, this.mPaint);
        }
    }

    private void preparePaint(int side) {
        float borderWidth = this.getBorderWidth(side);
        int color = WXViewUtils.multiplyColorAlpha(this.getBorderColor(side), this.mAlpha);
        BorderStyle borderStyle = BorderStyle.values()[this.getBorderStyle(side)];
        Shader shader = borderStyle.getLineShader(borderWidth, color, side);
        this.mPaint.setShader(shader);
        this.mPaint.setColor(color);
        this.mPaint.setStrokeWidth(borderWidth);
    }
}

