/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;

public class WXEditText
extends EditText
implements WXGestureObservable {
    private WXGesture wxGesture;

    public WXEditText(Context context) {
        super(context);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
        } else {
            this.setBackgroundDrawable(null);
        }
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int contentH = this.getLayout().getHeight();
        if (h < contentH) {
            this.setMovementMethod(null);
        } else {
            this.setMovementMethod(this.getDefaultMovementMethod());
        }
    }

    public boolean postDelayed(Runnable action, long delayMillis) {
        return super.postDelayed(WXThread.secure(action), delayMillis);
    }
}

