/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class WXSliderNeighbor
extends WXSlider {
    public static final String NEIGHBOR_SCALE = "neighborScale";
    public static final String NEIGHBOR_ALPHA = "neighborAlpha";
    private static final int DEFAULT_NEIGHBOR_SPACE = 25;
    private static final float DEFAULT_NEIGHBOR_SCALE = 0.8f;
    private static final float DEFAULT_NEIGHBOR_ALPHA = 0.6f;
    private float mNerghborScale = 0.8f;
    private float mNerghborAlpha = 0.6f;
    private static final float WX_DEFAULT_MAIN_NEIGHBOR_SCALE = 0.9f;

    public WXSliderNeighbor(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        super(instance, dom, parent, instanceId, isLazy);
    }

    public WXSliderNeighbor(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    @Override
    public void bindData(WXComponent component) {
        super.bindData(component);
        this.mViewPager.setCurrentItem(0);
        if (this.mAdapter.getRealCount() > 3) {
            this.mViewPager.setOffscreenPageLimit(2);
        } else if (this.mAdapter.getRealCount() == 3) {
            this.mViewPager.setOffscreenPageLimit(1);
        }
    }

    @Override
    protected FrameLayout initComponentHostView(Context context) {
        FrameLayout view = new FrameLayout(context);
        FrameLayout.LayoutParams pagerParams = new FrameLayout.LayoutParams(-1, -1);
        pagerParams.gravity = 17;
        this.mViewPager = new WXCircleViewPager(this.mContext);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)pagerParams);
        this.mAdapter = new WXCirclePageAdapter();
        this.mViewPager.setAdapter(this.mAdapter);
        view.addView((View)this.mViewPager);
        this.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        this.mViewPager.setPageTransformer(true, new ZoomTransformer());
        this.mViewPager.setOverScrollMode(2);
        view.setClipChildren(false);
        this.registerActivityStateListener();
        return view;
    }

    @Override
    protected void addSubView(View view, int index) {
        this.updateScaleAndAlpha(view, this.mNerghborAlpha, this.mNerghborScale);
        if (view == null || this.mAdapter == null) {
            return;
        }
        if (view instanceof WXCircleIndicator) {
            return;
        }
        FrameLayout wrapper = new FrameLayout(this.mContext);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        wrapper.addView(view);
        this.mAdapter.addPageView((View)wrapper);
        this.mAdapter.notifyDataSetChanged();
        if (this.mIndicator != null) {
            ((WXCircleIndicator)this.mIndicator.getHostView()).forceLayout();
            ((WXCircleIndicator)this.mIndicator.getHostView()).requestLayout();
        }
    }

    private void updateScaleAndAlpha(View view, float alpha, float scale) {
        if (null == view) {
            return;
        }
        if (alpha >= 0.0f) {
            view.setAlpha(alpha);
        }
        if (scale >= 0.0f) {
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    private void updateAdpaterScaleAndAplha(float alpha, float scale) {
        List<View> pageViews = this.mAdapter.getViews();
        int cusPos = this.mViewPager.getCurrentItem();
        if (null != pageViews && pageViews.size() > 0) {
            for (View v : pageViews) {
                View realView = ((ViewGroup)v).getChildAt(0);
                if (this.mAdapter.getItemPosition(v) != cusPos) {
                    this.updateScaleAndAlpha(realView, alpha, scale);
                    continue;
                }
                this.updateScaleAndAlpha(realView, 1.0f, 0.9f);
            }
        }
    }

    @WXComponentProp(name="neighborScale")
    public void setNeighborScale(String input) {
        float neighborScale = 0.8f;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            try {
                neighborScale = Float.parseFloat(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.mNerghborScale != neighborScale) {
            this.mNerghborScale = neighborScale;
            this.updateAdpaterScaleAndAplha(-1.0f, neighborScale);
        }
    }

    @WXComponentProp(name="neighborAlpha")
    public void setNeighborAlpha(String input) {
        float neighborAlpha = 0.6f;
        if (!TextUtils.isEmpty((CharSequence)input)) {
            try {
                neighborAlpha = Float.parseFloat(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.mNerghborAlpha != neighborAlpha) {
            this.mNerghborAlpha = neighborAlpha;
            this.updateAdpaterScaleAndAplha(neighborAlpha, -1.0f);
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        String input = "";
        switch (key) {
            case "neighborScale": {
                input = WXUtils.getString(param, null);
                if (input != null) {
                    this.setNeighborScale(input);
                }
                return true;
            }
            case "neighborAlpha": {
                input = WXUtils.getString(param, null);
                if (input != null) {
                    this.setNeighborAlpha(input);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    class ZoomTransformer
    implements ViewPager.PageTransformer {
        ZoomTransformer() {
        }

        public void transformPage(View page, float position) {
            View realView = ((ViewGroup)page).getChildAt(0);
            if (realView == null) {
                return;
            }
            if (position <= (float)(-WXSliderNeighbor.this.mAdapter.getRealCount() + 1)) {
                position += (float)WXSliderNeighbor.this.mAdapter.getRealCount();
            }
            if (position >= (float)(WXSliderNeighbor.this.mAdapter.getRealCount() - 1)) {
                position -= (float)WXSliderNeighbor.this.mAdapter.getRealCount();
            }
            if (position >= -1.0f && position <= 1.0f) {
                float factor = Math.abs(Math.abs(position) - 1.0f);
                float scale = WXSliderNeighbor.this.mNerghborScale + factor * (0.9f - WXSliderNeighbor.this.mNerghborScale);
                float alpha = (1.0f - WXSliderNeighbor.this.mNerghborAlpha) * factor + WXSliderNeighbor.this.mNerghborAlpha;
                int delta = page.getMeasuredWidth() - realView.getMeasuredWidth();
                float translation = ((float)page.getMeasuredWidth() - (float)realView.getMeasuredWidth() * 0.9f - WXViewUtils.getRealPxByWidth(25.0f) * 2.0f) / 2.0f;
                if (WXSliderNeighbor.this.mViewPager.getCurrentItem() != WXSliderNeighbor.this.mAdapter.getItemPosition(page)) {
                    if (position > 0.0f) {
                        realView.setPivotX(0.0f);
                        realView.setTranslationX((float)(-delta));
                        page.setTranslationX(-translation);
                    } else {
                        realView.setPivotX((float)realView.getMeasuredWidth());
                        realView.setTranslationX((float)delta);
                        page.setTranslationX(translation);
                    }
                } else {
                    realView.setPivotX((float)(realView.getMeasuredWidth() / 2));
                    page.setTranslationX(0.0f);
                    realView.setTranslationX(0.0f);
                }
                realView.setPivotY((float)(realView.getMeasuredHeight() / 2));
                realView.setAlpha(alpha);
                realView.setScaleX(scale);
                realView.setScaleY(scale);
            }
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXSliderNeighbor(instance, node, parent, lazy);
        }
    }
}

