/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.Component;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXIndicator;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload=false)
public class WXSlider
extends WXVContainer<FrameLayout> {
    Map<String, Object> params = new HashMap<String, Object>();
    WXCircleViewPager mViewPager;
    protected WXIndicator mIndicator;
    protected WXCirclePageAdapter mAdapter;
    protected boolean mShowIndicators;
    protected ViewPager.OnPageChangeListener mPageChangeListener = new SliderPageChangeListener();

    @Deprecated
    public WXSlider(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXSlider(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    @Override
    protected FrameLayout initComponentHostView(@NonNull Context context) {
        FrameLayout view = new FrameLayout(context);
        FrameLayout.LayoutParams pagerParams = new FrameLayout.LayoutParams(-1, -1);
        this.mViewPager = new WXCircleViewPager(context);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)pagerParams);
        this.mAdapter = new WXCirclePageAdapter();
        this.mViewPager.setAdapter(this.mAdapter);
        view.addView((View)this.mViewPager);
        this.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        this.registerActivityStateListener();
        return view;
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (this.getRealView() != null) {
            this.getRealView().setOnTouchListener(null);
        }
        this.mGestureType.clear();
    }

    @Override
    public ViewGroup getRealView() {
        return this.mViewPager;
    }

    @Override
    protected void addSubView(View view, int index) {
        if (view == null || this.mAdapter == null) {
            return;
        }
        if (view instanceof WXCircleIndicator) {
            return;
        }
        this.mAdapter.addPageView(view);
        this.mAdapter.notifyDataSetChanged();
        if (this.mIndicator != null) {
            ((WXCircleIndicator)this.mIndicator.getHostView()).forceLayout();
            ((WXCircleIndicator)this.mIndicator.getHostView()).requestLayout();
        }
    }

    @Override
    public void remove(WXComponent child) {
        this.remove(child, true);
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        if (child == null || child.getHostView() == null || this.mAdapter == null) {
            return;
        }
        this.mAdapter.removePageView((View)child.getHostView());
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mViewPager != null) {
            this.mViewPager.stopAutoScroll();
            this.mViewPager.removeAllViews();
            this.mViewPager.destory();
        }
    }

    @Override
    public void onActivityResume() {
        if (this.mViewPager != null && this.mViewPager.isAutoScroll()) {
            this.mViewPager.startAutoScroll();
        }
    }

    @Override
    public void onActivityStop() {
        if (this.mViewPager != null) {
            this.mViewPager.stopAutoScroll();
        }
    }

    public void addIndicator(WXIndicator indicator) {
        FrameLayout root = (FrameLayout)this.getHostView();
        if (root == null) {
            return;
        }
        this.mIndicator = indicator;
        WXCircleIndicator indicatorView = (WXCircleIndicator)indicator.getHostView();
        if (indicatorView != null) {
            indicatorView.setCircleViewPager(this.mViewPager);
            root.addView((View)indicatorView);
        }
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "value": {
                String value = WXUtils.getString(param, null);
                if (value != null) {
                    this.setValue(value);
                }
                return true;
            }
            case "autoPlay": {
                String aotu_play = WXUtils.getString(param, null);
                if (aotu_play != null) {
                    this.setAutoPlay(aotu_play);
                }
                return true;
            }
            case "showIndicators": {
                String indicators = WXUtils.getString(param, null);
                if (indicators != null) {
                    this.setShowIndicators(indicators);
                }
                return true;
            }
            case "interval": {
                Integer interval = WXUtils.getInteger(param, null);
                if (interval != null) {
                    this.setInterval(interval);
                }
                return true;
            }
            case "index": {
                Integer index = WXUtils.getInteger(param, null);
                if (index != null) {
                    this.setIndex(index);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @Deprecated
    @WXComponentProp(name="value")
    public void setValue(String value) {
        int i;
        if (value == null || this.getHostView() == null) {
            return;
        }
        try {
            i = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            WXLogUtils.e("", e);
            return;
        }
        this.mViewPager.setCurrentItem(i);
    }

    @WXComponentProp(name="autoPlay")
    public void setAutoPlay(String autoPlay) {
        if (TextUtils.isEmpty((CharSequence)autoPlay) || autoPlay.equals("false")) {
            this.mViewPager.stopAutoScroll();
        } else {
            this.mViewPager.stopAutoScroll();
            this.mViewPager.startAutoScroll();
        }
    }

    @WXComponentProp(name="showIndicators")
    public void setShowIndicators(String show) {
        this.mShowIndicators = !TextUtils.isEmpty((CharSequence)show) && !show.equals("false");
        if (this.mIndicator == null) {
            return;
        }
        this.mIndicator.setShowIndicators(this.mShowIndicators);
    }

    @WXComponentProp(name="interval")
    public void setInterval(int intervalMS) {
        if (this.mViewPager != null && intervalMS > 0) {
            this.mViewPager.setIntervalTime(intervalMS);
        }
    }

    @WXComponentProp(name="index")
    public void setIndex(int index) {
        if (this.mViewPager != null && this.mAdapter != null) {
            if (index >= this.mAdapter.getRealCount() || index < 0) {
                return;
            }
            this.mViewPager.setCurrentItem(index %= this.mAdapter.getRealCount());
        }
    }

    protected class SliderPageChangeListener
    implements ViewPager.OnPageChangeListener {
        protected SliderPageChangeListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int pos) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("onPageSelected >>>>" + pos);
            }
            if (WXSlider.this.mAdapter == null || WXSlider.this.mAdapter.getRealCount() == 0) {
                return;
            }
            int realPosition = pos % WXSlider.this.mAdapter.getRealCount();
            if (WXSlider.this.mChildren == null || realPosition >= WXSlider.this.mChildren.size()) {
                return;
            }
            if (WXSlider.this.getDomObject().getEvents().size() == 0) {
                return;
            }
            WXEvent event = WXSlider.this.getDomObject().getEvents();
            String ref = WXSlider.this.getDomObject().getRef();
            if (event.contains("change") && WXViewUtils.onScreenArea(WXSlider.this.getHostView())) {
                WXSlider.this.params.put("index", realPosition);
                HashMap<String, Object> domChanges = new HashMap<String, Object>();
                HashMap<String, Integer> attrsChanges = new HashMap<String, Integer>();
                attrsChanges.put("value", realPosition);
                domChanges.put("attrs", attrsChanges);
                WXSDKManager.getInstance().fireEvent(WXSlider.this.mInstanceId, ref, "change", WXSlider.this.params, domChanges);
            }
            WXSlider.this.mViewPager.requestLayout();
            ((FrameLayout)WXSlider.this.getHostView()).invalidate();
        }

        public void onPageScrollStateChanged(int arg0) {
            FrameLayout root = (FrameLayout)WXSlider.this.getHostView();
            if (null != root) {
                root.invalidate();
            }
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXSlider(instance, node, parent, lazy);
        }
    }
}

