/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXViewUtils;

public class WXImageView
extends ImageView
implements WXGestureObservable {
    private WXGesture wxGesture;

    public WXImageView(Context context) {
        super(context);
    }

    public void setImageResource(int resId) {
        Drawable drawable2 = this.getResources().getDrawable(resId);
        this.setImageDrawable(drawable2);
    }

    public void setImageDrawable(Drawable drawable2, boolean isGif) {
        if (drawable2 != null) {
            if (isGif) {
                super.setImageDrawable(drawable2);
            } else {
                super.setImageDrawable((Drawable)new ImageClipDrawable(drawable2));
            }
        } else {
            super.setImageDrawable(null);
        }
        if (this.getScaleType() == ImageView.ScaleType.MATRIX && this.getDrawable() != null) {
            Matrix matrix = this.getImageMatrix();
            int dwidth = this.getDrawable().getIntrinsicWidth();
            int dheight = this.getDrawable().getIntrinsicHeight();
            int vwidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int vheight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            float scale = dwidth * vheight > vwidth * dheight ? (float)vheight / (float)dheight : (float)vwidth / (float)dwidth;
            matrix.setScale(scale, scale);
            this.setImageMatrix(matrix);
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        this.setImageDrawable(drawable2, false);
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    private class ImageClipDrawable
    extends Drawable {
        @NonNull
        private Paint mPaint;
        @NonNull
        private final Drawable mOriginal;

        private ImageClipDrawable(Drawable original) {
            this.mOriginal = original;
            this.mPaint = new Paint(1);
        }

        public void draw(Canvas canvas) {
            Bitmap bitmap;
            if (this.mOriginal instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)this.mOriginal).getBitmap()) != null) {
                Path path;
                RectF bounds = new RectF(this.getBounds());
                BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable((View)WXImageView.this);
                if (borderDrawable != null) {
                    path = borderDrawable.getContentPath(WXImageView.this.getPaddingTop(), WXImageView.this.getPaddingRight(), WXImageView.this.getPaddingBottom(), WXImageView.this.getPaddingLeft(), bounds);
                } else {
                    path = new Path();
                    path.addRect(bounds, Path.Direction.CW);
                }
                Matrix matrix = new Matrix();
                matrix.setScale(bounds.width() / (float)bitmap.getWidth(), bounds.height() / (float)bitmap.getHeight());
                BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                bitmapShader.setLocalMatrix(matrix);
                this.mPaint.setStyle(Paint.Style.FILL);
                this.mPaint.setShader((Shader)bitmapShader);
                canvas.drawPath(path, this.mPaint);
            } else {
                this.mOriginal.draw(canvas);
            }
        }

        public void setAlpha(int i) {
            this.mOriginal.setAlpha(i);
        }

        public void setColorFilter(ColorFilter colorFilter) {
            this.mOriginal.setColorFilter(colorFilter);
        }

        public int getOpacity() {
            return this.mOriginal.getOpacity();
        }

        protected void onBoundsChange(Rect bounds) {
            this.mOriginal.setBounds(bounds);
            this.invalidateSelf();
        }

        public int getIntrinsicWidth() {
            return this.mOriginal.getIntrinsicWidth();
        }

        public int getIntrinsicHeight() {
            return this.mOriginal.getIntrinsicHeight();
        }
    }
}

