/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.Component;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.AppearanceHelper;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.helper.WXStickyHelper;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.WXBaseRefreshLayout;
import com.taobao.weex.ui.view.WXHorizontalScrollView;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceScrollerView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(lazyload=false)
public class WXScroller
extends WXVContainer<ViewGroup>
implements WXScrollView.WXScrollViewListener,
Scrollable {
    public static final String DIRECTION = "direction";
    protected int mOrientation = 1;
    private List<WXComponent> mRefreshs = new ArrayList<WXComponent>();
    private Map<String, AppearanceHelper> mAppearanceComponents = new HashMap<String, AppearanceHelper>();
    private Map<String, HashMap<String, WXComponent>> mStickyMap = new HashMap<String, HashMap<String, WXComponent>>();
    private FrameLayout mRealView;
    private int mContentHeight = 0;
    private WXStickyHelper stickyHelper;
    private Handler handler = new Handler();

    @Deprecated
    public WXScroller(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXScroller(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
        this.stickyHelper = new WXStickyHelper(this);
    }

    @Override
    public ViewGroup getRealView() {
        return this.mRealView;
    }

    @Override
    public void createViewImpl(WXVContainer parent, int index) {
        super.createViewImpl(parent, index);
        for (int i = 0; i < this.mRefreshs.size(); ++i) {
            WXComponent component = this.mRefreshs.get(i);
            component.createViewImpl(null, -1);
            this.checkRefreshOrLoading(component);
        }
    }

    public ViewGroup getInnerView() {
        if (this.getHostView() == null) {
            return null;
        }
        if (this.getHostView() instanceof BounceScrollerView) {
            return (ViewGroup)((BounceScrollerView)((Object)this.getHostView())).getInnerView();
        }
        return (ViewGroup)this.getHostView();
    }

    @Override
    protected void addSubView(View child, int index) {
        if (child == null || this.getRealView() == null) {
            return;
        }
        if (child instanceof WXBaseRefreshLayout) {
            return;
        }
        int count = this.getRealView().getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.getRealView().addView(child);
        } else {
            this.getRealView().addView(child, index);
        }
    }

    @Override
    public void addChild(WXComponent child, int index) {
        int count;
        if (child == null || index < -1) {
            return;
        }
        if (child instanceof WXBaseRefresh) {
            if (!this.checkRefreshOrLoading(child)) {
                this.mRefreshs.add(child);
            }
            return;
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList();
        }
        int n = index = index >= (count = this.mChildren.size()) ? -1 : index;
        if (index == -1) {
            this.mChildren.add(child);
        } else {
            this.mChildren.add(index, child);
        }
    }

    private boolean checkRefreshOrLoading(final WXComponent child) {
        Runnable runnable;
        boolean result = false;
        if (child instanceof WXRefresh && this.getHostView() != null) {
            ((BaseBounceView)((Object)this.getHostView())).setOnRefreshListener((WXRefresh)child);
            runnable = WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)((Object)WXScroller.this.getHostView())).setHeaderView(child);
                }
            });
            this.handler.postDelayed(runnable, 100L);
        }
        if (child instanceof WXLoading && this.getHostView() != null) {
            ((BaseBounceView)((Object)this.getHostView())).setOnLoadingListener((WXLoading)child);
            runnable = WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)((Object)WXScroller.this.getHostView())).setFooterView(child);
                }
            });
            this.handler.postDelayed(runnable, 100L);
            result = true;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mAppearanceComponents != null) {
            this.mAppearanceComponents.clear();
        }
        if (this.mStickyMap != null) {
            this.mStickyMap.clear();
        }
        if (this.getInnerView() != null && this.getInnerView() instanceof IWXScroller) {
            ((IWXScroller)this.getInnerView()).destroy();
        }
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        WXComponent.MeasureOutput measureOutput = new WXComponent.MeasureOutput();
        if (this.mOrientation == 0) {
            int screenW = WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
            int weexW = WXViewUtils.getWeexWidth(this.getInstanceId());
            measureOutput.width = width > (weexW >= screenW ? screenW : weexW) ? -1 : width;
            measureOutput.height = height;
        } else {
            int screenH = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
            int weexH = WXViewUtils.getWeexHeight(this.getInstanceId());
            measureOutput.height = height > (weexH >= screenH ? screenH : weexH) ? -1 : height;
            measureOutput.width = width;
        }
        return measureOutput;
    }

    @Override
    protected ViewGroup initComponentHostView(@NonNull Context context) {
        Object host;
        String scroll = this.getDomObject() == null || this.getDomObject().getAttrs().isEmpty() ? "vertical" : this.getDomObject().getAttrs().getScrollDirection();
        if ("horizontal".equals(scroll)) {
            this.mOrientation = 0;
            WXHorizontalScrollView scrollView = new WXHorizontalScrollView(context);
            this.mRealView = new FrameLayout(context);
            scrollView.setScrollViewListener(new WXHorizontalScrollView.ScrollViewListener(){

                @Override
                public void onScrollChanged(WXHorizontalScrollView scrollView, int x, int y, int oldx, int oldy) {
                    WXScroller.this.procAppear(x, y, oldx, oldy);
                }
            });
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            scrollView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            scrollView.setHorizontalScrollBarEnabled(false);
            host = scrollView;
        } else {
            this.mOrientation = 1;
            BounceScrollerView scrollerView = new BounceScrollerView(context, this.mOrientation, this);
            this.mRealView = new FrameLayout(context);
            WXScrollView innerView = (WXScrollView)scrollerView.getInnerView();
            innerView.addScrollViewListener(this);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            innerView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            innerView.setVerticalScrollBarEnabled(true);
            innerView.addScrollViewListener(new WXScrollView.WXScrollViewListener(){

                @Override
                public void onScrollChanged(WXScrollView scrollView, int x, int y, int oldx, int oldy) {
                }

                @Override
                public void onScrollToBottom(WXScrollView scrollView, int x, int y) {
                }

                @Override
                public void onScrollStopped(WXScrollView scrollView, int x, int y) {
                    List<OnWXScrollListener> listeners = WXScroller.this.getInstance().getWXScrollListeners();
                    if (listeners != null && listeners.size() > 0) {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            listener.onScrollStateChanged((View)scrollView, x, y, 0);
                        }
                    }
                }

                @Override
                public void onScroll(WXScrollView scrollView, int x, int y) {
                    List<OnWXScrollListener> listeners = WXScroller.this.getInstance().getWXScrollListeners();
                    if (listeners != null && listeners.size() > 0) {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            listener.onScrolled((View)scrollView, x, y);
                        }
                    }
                }
            });
            host = scrollerView;
        }
        return host;
    }

    @Override
    public int getScrollY() {
        return this.getInnerView() == null ? 0 : this.getInnerView().getScrollY();
    }

    @Override
    public int getScrollX() {
        return this.getInnerView() == null ? 0 : this.getInnerView().getScrollX();
    }

    public Map<String, HashMap<String, WXComponent>> getStickMap() {
        return this.mStickyMap;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "showScrollbar": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setShowScrollbar(result);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="showScrollbar")
    public void setShowScrollbar(boolean show) {
        if (this.getInnerView() == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.getInnerView().setVerticalScrollBarEnabled(show);
        } else {
            this.getInnerView().setHorizontalScrollBarEnabled(show);
        }
    }

    @Override
    public void bindStickStyle(WXComponent component) {
        this.stickyHelper.bindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void unbindStickStyle(WXComponent component) {
        this.stickyHelper.unbindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void bindAppearEvent(WXComponent component) {
        this.setWatch(0, component, true);
    }

    private void setWatch(int event, WXComponent component, boolean isWatch) {
        AppearanceHelper item = this.mAppearanceComponents.get(component.getRef());
        if (item == null) {
            item = new AppearanceHelper(component);
            this.mAppearanceComponents.put(component.getRef(), item);
        }
        item.setWatchEvent(event, isWatch);
        this.procAppear(1, 1, 0, 0);
    }

    @Override
    public void bindDisappearEvent(WXComponent component) {
        this.setWatch(1, component, true);
    }

    @Override
    public void unbindAppearEvent(WXComponent component) {
        this.setWatch(0, component, false);
    }

    @Override
    public void unbindDisappearEvent(WXComponent component) {
        this.setWatch(1, component, false);
    }

    @Override
    public void scrollTo(WXComponent component, int offset) {
        int offsetIntF = (int)WXViewUtils.getRealPxByWidth(offset);
        int viewYInScroller = component.getAbsoluteY() - this.getAbsoluteY();
        int viewXInScroller = component.getAbsoluteX() - this.getAbsoluteX();
        this.scrollBy(viewXInScroller - this.getScrollX() + offsetIntF, viewYInScroller - this.getScrollY() + offsetIntF);
    }

    public void scrollBy(final int x, final int y) {
        if (this.getInnerView() == null) {
            return;
        }
        this.getInnerView().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (WXScroller.this.getInnerView() == null) {
                    return;
                }
                if (WXScroller.this.mOrientation == 1) {
                    ((WXScrollView)WXScroller.this.getInnerView()).smoothScrollBy(0, y);
                } else {
                    ((WXHorizontalScrollView)WXScroller.this.getInnerView()).smoothScrollBy(x, 0);
                }
                WXScroller.this.getInnerView().invalidate();
            }
        }, 16L);
    }

    @Override
    public void onScrollChanged(WXScrollView scrollView, int x, int y, int oldx, int oldy) {
        this.procAppear(x, y, oldx, oldy);
    }

    private void procAppear(int x, int y, int oldx, int oldy) {
        String direction;
        String string = direction = y - oldy > 0 ? "up" : "down";
        if (this.mOrientation == 0) {
            direction = x - oldx > 0 ? "right" : "left";
        }
        for (Map.Entry<String, AppearanceHelper> item : this.mAppearanceComponents.entrySet()) {
            boolean visible;
            int result;
            AppearanceHelper helper = item.getValue();
            if (!helper.isWatch() || (result = helper.setAppearStatus(visible = helper.isViewVisible())) == 0) continue;
            helper.getAwareChild().notifyAppearStateChange(result == 1 ? "appear" : "disappear", direction);
        }
    }

    @Override
    public void onScrollToBottom(WXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScrollStopped(WXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScroll(WXScrollView scrollView, int x, int y) {
        this.onLoadMore(scrollView, x, y);
    }

    protected void onLoadMore(WXScrollView scrollView, int x, int y) {
        try {
            int scrollerH;
            String offset = this.getDomObject().getAttrs().getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                return;
            }
            int contentH = scrollView.getChildAt(0).getHeight();
            int offScreenY = contentH - y - (scrollerH = scrollView.getHeight());
            if (offScreenY < Integer.parseInt(offset)) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("[WXScroller-onScroll] offScreenY :" + offScreenY);
                }
                if (this.mContentHeight != contentH) {
                    this.getInstance().fireEvent(this.getDomObject().getRef(), "loadmore");
                    this.mContentHeight = contentH;
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.d("[WXScroller-onScroll] ", e);
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXScroller(instance, node, parent, lazy);
        }
    }
}

