/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.graphics.Color;
import android.text.TextUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WXResourceUtils {
    private static final Map<String, Integer> colorMap = new HashMap<String, Integer>();
    private static final Pattern RGB_PATTERN = Pattern.compile("^#[0-9a-fA-F]{3,9}$");
    private static final Pattern FUNCTION_RGBA_PATTERN = Pattern.compile("^(rgba?[\\(])([\\s]*[0-9%]+[\\s]*),([\\s]*[0-9%]+[\\s]*),(([\\s]*[0-9%]+[\\s]*),)?([\\s]*[0-9.]+[\\s]*)[\\)]$");

    public static int getColor(String color) {
        return WXResourceUtils.getColor(color, Integer.MIN_VALUE);
    }

    public static int getColor(String color, int defaultColor) {
        if (TextUtils.isEmpty((CharSequence)color)) {
            return defaultColor;
        }
        color = color.trim();
        int resultColor = defaultColor;
        try {
            ColorConvertHandler[] handlers;
            for (ColorConvertHandler handler : handlers = ColorConvertHandler.values()) {
                Integer convertedColor = handler.handle(color);
                if (convertedColor == null) continue;
                resultColor = convertedColor;
                break;
            }
        }
        catch (Exception e) {
            WXLogUtils.e("WXResourceUtils getColor failed: " + color);
        }
        return resultColor;
    }

    static {
        colorMap.put("aliceblue", -984833);
        colorMap.put("antiquewhite", -332841);
        colorMap.put("aqua", -16711681);
        colorMap.put("aquamarine", -8388652);
        colorMap.put("azure", -983041);
        colorMap.put("beige", -657956);
        colorMap.put("bisque", -6972);
        colorMap.put("black", -16777216);
        colorMap.put("blanchedalmond", -5171);
        colorMap.put("blue", -16776961);
        colorMap.put("blueviolet", -7722014);
        colorMap.put("brown", -5952982);
        colorMap.put("burlywood", -2180985);
        colorMap.put("cadetblue", -10510688);
        colorMap.put("chartreuse", -8388864);
        colorMap.put("chocolate", -2987746);
        colorMap.put("coral", -32944);
        colorMap.put("cornflowerblue", -10185235);
        colorMap.put("cornsilk", -1828);
        colorMap.put("crimson", -2354116);
        colorMap.put("cyan", -16711681);
        colorMap.put("darkblue", -16777077);
        colorMap.put("darkcyan", -16741493);
        colorMap.put("darkgoldenrod", -4684277);
        colorMap.put("darkgray", -5658199);
        colorMap.put("darkgreen", -16751616);
        colorMap.put("darkkhaki", -4343957);
        colorMap.put("darkmagenta", -7667573);
        colorMap.put("darkolivegreen", -11179217);
        colorMap.put("darkorange", -29696);
        colorMap.put("darkorchid", -6737204);
        colorMap.put("darkred", -7667712);
        colorMap.put("darksalmon", -1468806);
        colorMap.put("darkseagreen", -7357297);
        colorMap.put("darkslateblue", -12042869);
        colorMap.put("darkslategray", -13676721);
        colorMap.put("darkslategrey", -13676721);
        colorMap.put("darkturquoise", -16724271);
        colorMap.put("darkviolet", -7077677);
        colorMap.put("deeppink", -60269);
        colorMap.put("deepskyblue", -16728065);
        colorMap.put("dimgray", -9868951);
        colorMap.put("dimgrey", -9868951);
        colorMap.put("dodgerblue", -14774017);
        colorMap.put("firebrick", -5103070);
        colorMap.put("floralwhite", -1296);
        colorMap.put("forestgreen", -14513374);
        colorMap.put("fuchsia", -65281);
        colorMap.put("gainsboro", -2302756);
        colorMap.put("ghostwhite", -460545);
        colorMap.put("gold", -10496);
        colorMap.put("goldenrod", -2448096);
        colorMap.put("gray", -8355712);
        colorMap.put("grey", -8355712);
        colorMap.put("green", -16744448);
        colorMap.put("greenyellow", -5374161);
        colorMap.put("honeydew", -983056);
        colorMap.put("hotpink", -38476);
        colorMap.put("indianred", -3318692);
        colorMap.put("indigo", -11861886);
        colorMap.put("ivory", -16);
        colorMap.put("khaki", -989556);
        colorMap.put("lavender", -1644806);
        colorMap.put("lavenderblush", -3851);
        colorMap.put("lawngreen", -8586240);
        colorMap.put("lemonchiffon", -1331);
        colorMap.put("lightblue", -5383962);
        colorMap.put("lightcoral", -1015680);
        colorMap.put("lightcyan", -2031617);
        colorMap.put("lightgoldenrodyellow", -329006);
        colorMap.put("lightgray", -2894893);
        colorMap.put("lightgrey", -2894893);
        colorMap.put("lightgreen", -7278960);
        colorMap.put("lightpink", -18751);
        colorMap.put("lightsalmon", -24454);
        colorMap.put("lightseagreen", -14634326);
        colorMap.put("lightskyblue", -7876870);
        colorMap.put("lightslategray", -8943463);
        colorMap.put("lightslategrey", -8943463);
        colorMap.put("lightsteelblue", -5192482);
        colorMap.put("lightyellow", -32);
        colorMap.put("lime", -16711936);
        colorMap.put("limegreen", -13447886);
        colorMap.put("linen", -331546);
        colorMap.put("magenta", -65281);
        colorMap.put("maroon", -8388608);
        colorMap.put("mediumaquamarine", -10039894);
        colorMap.put("mediumblue", -16777011);
        colorMap.put("mediumorchid", -4565549);
        colorMap.put("mediumpurple", -7114533);
        colorMap.put("mediumseagreen", -12799119);
        colorMap.put("mediumslateblue", -8689426);
        colorMap.put("mediumspringgreen", -16713062);
        colorMap.put("mediumturquoise", -12004916);
        colorMap.put("mediumvioletred", -3730043);
        colorMap.put("midnightblue", -15132304);
        colorMap.put("mintcream", -655366);
        colorMap.put("mistyrose", -6943);
        colorMap.put("moccasin", -6987);
        colorMap.put("navajowhite", -8531);
        colorMap.put("navy", -16777088);
        colorMap.put("oldlace", -133658);
        colorMap.put("olive", -8355840);
        colorMap.put("olivedrab", -9728477);
        colorMap.put("orange", -23296);
        colorMap.put("orangered", -47872);
        colorMap.put("orchid", -2461482);
        colorMap.put("palegoldenrod", -1120086);
        colorMap.put("palegreen", -6751336);
        colorMap.put("paleturquoise", -5247250);
        colorMap.put("palevioletred", -2396013);
        colorMap.put("papayawhip", -4139);
        colorMap.put("peachpuff", -9543);
        colorMap.put("peru", -3308225);
        colorMap.put("pink", -16181);
        colorMap.put("plum", -2252579);
        colorMap.put("powderblue", -5185306);
        colorMap.put("purple", -8388480);
        colorMap.put("rebeccapurple", -10079335);
        colorMap.put("red", -65536);
        colorMap.put("rosybrown", -4419697);
        colorMap.put("royalblue", -12490271);
        colorMap.put("saddlebrown", -7650029);
        colorMap.put("salmon", -360334);
        colorMap.put("sandybrown", -744352);
        colorMap.put("seagreen", -13726889);
        colorMap.put("seashell", -2578);
        colorMap.put("sienna", -6270419);
        colorMap.put("silver", -4144960);
        colorMap.put("skyblue", -7876885);
        colorMap.put("slateblue", -9807155);
        colorMap.put("slategray", -9404272);
        colorMap.put("slategrey", -9404272);
        colorMap.put("snow", -1286);
        colorMap.put("springgreen", -16711809);
        colorMap.put("steelblue", -12156236);
        colorMap.put("tan", -2968436);
        colorMap.put("teal", -16744320);
        colorMap.put("thistle", -2572328);
        colorMap.put("tomato", -40121);
        colorMap.put("turquoise", -12525360);
        colorMap.put("violet", -1146130);
        colorMap.put("wheat", -663885);
        colorMap.put("white", -1);
        colorMap.put("whitesmoke", -657931);
        colorMap.put("yellow", -256);
        colorMap.put("yellowgreen", -6632142);
        colorMap.put("transparent", 0);
    }

    static enum ColorConvertHandler {
        NAMED_COLOR_HANDLER{

            @Override
            Integer handle(String rawColor) {
                return (Integer)colorMap.get(rawColor);
            }
        }
        ,
        RGB_HANDLER{

            @Override
            Integer handle(String rawColor) {
                if (RGB_PATTERN.matcher(rawColor).matches()) {
                    if (rawColor.length() == 4) {
                        int result = 0;
                        for (int i = 1; i < 4; ++i) {
                            result = (result << 8) + 17 * Character.digit(rawColor.charAt(i), 16);
                        }
                        return result | 0xFF000000;
                    }
                    if (rawColor.length() == 7 || rawColor.length() == 9) {
                        return Color.parseColor((String)rawColor);
                    }
                    throw new IllegalArgumentException("ColorConvertHandler invalid color: " + rawColor);
                }
                return null;
            }
        }
        ,
        FUNCTIONAL_RGBA_HANDLER{

            @Override
            Integer handle(String rawColor) {
                return ColorConvertHandler.convertFunctionalColor(rawColor);
            }
        };


        private static Integer convertFunctionalColor(String raw) {
            Matcher matcher = FUNCTION_RGBA_PATTERN.matcher(raw);
            if (matcher.matches()) {
                boolean alpha = matcher.group(1).startsWith("rgba");
                String[] gradients = new String[alpha ? 4 : 3];
                gradients[0] = matcher.group(2);
                gradients[1] = matcher.group(3);
                if (alpha) {
                    gradients[2] = matcher.group(5);
                    gradients[3] = matcher.group(6);
                } else {
                    gradients[2] = matcher.group(6);
                }
                return ColorConvertHandler.parseRGBA(gradients);
            }
            return null;
        }

        private static Integer parseRGBA(String[] gradients) {
            int[] digits = new int[4];
            if (gradients.length == 3) {
                digits[3] = 255;
            }
            for (int i = 0; i < gradients.length; ++i) {
                int value;
                String gradient = gradients[i].trim();
                int percent_loc = gradient.lastIndexOf("%");
                if (percent_loc != -1) {
                    gradient = gradient.substring(0, percent_loc);
                    value = (int)(Float.parseFloat(gradient) / 100.0f * 255.0f);
                } else {
                    float temp = Float.parseFloat(gradient);
                    value = 0.0f < temp && temp <= 1.0f && i == 3 ? (int)(temp * 255.0f) : (int)temp;
                }
                if (value < 0 || value > 255) {
                    throw new IllegalArgumentException("ColorConvertHandler invalid gradient: " + gradient);
                }
                digits[i] = value;
            }
            int result = digits[3];
            for (int i = 0; i < 3; ++i) {
                result = (result << 8) + digits[i];
            }
            return result;
        }

        abstract Integer handle(String var1);
    }
}

