/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.gesture;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WXGesture
implements View.OnTouchListener {
    private static final String TAG = "Gesture";
    private static final int CUR_EVENT = -1;
    private WXComponent component;
    private GestureDetector mGestureDetector;
    private Rect globalRect;
    private Point globalOffset;
    private Point globalEventOffset;
    private PointF locEventOffset;
    private PointF locLeftTop;
    private boolean scrolling;

    public WXGesture(WXComponent wxComponent, Context context) {
        this.component = wxComponent;
        this.globalRect = new Rect();
        this.globalOffset = new Point();
        this.globalEventOffset = new Point();
        this.locEventOffset = new PointF();
        this.locLeftTop = new PointF();
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener(), (Handler)new GestureHandler());
    }

    public boolean onTouch(View v, MotionEvent event) {
        try {
            boolean result = this.mGestureDetector.onTouchEvent(event);
            switch (event.getActionMasked()) {
                case 0: 
                case 5: {
                    result |= this.handleMotionEvent(WXGestureType.LowLevelGesture.ACTION_DOWN, event);
                    break;
                }
                case 2: {
                    result |= this.handleMotionEvent(WXGestureType.LowLevelGesture.ACTION_MOVE, event);
                    break;
                }
                case 1: {
                    if (this.scrolling) {
                        result |= this.handleMotionEvent(WXGestureType.HighLevelGesture.PAN_END, event);
                        this.scrolling = false;
                    }
                    result |= this.handleMotionEvent(WXGestureType.LowLevelGesture.ACTION_UP, event);
                    break;
                }
                case 6: {
                    result |= this.handleMotionEvent(WXGestureType.LowLevelGesture.ACTION_UP, event);
                    break;
                }
                case 3: {
                    result |= this.handleMotionEvent(WXGestureType.LowLevelGesture.ACTION_CANCEL, event);
                }
            }
            return result;
        }
        catch (Exception e) {
            WXLogUtils.e("Gesture RunTime Error ", e);
            return false;
        }
    }

    private boolean handleMotionEvent(WXGestureType WXGestureType2, MotionEvent motionEvent) {
        if (this.component.containsGesture(WXGestureType2)) {
            List<Map<String, Object>> list = this.createFireEventParam(motionEvent);
            for (Map<String, Object> map : list) {
                this.component.getInstance().fireEvent(this.component.getDomObject().getRef(), WXGestureType2.toString(), map);
            }
            return true;
        }
        return false;
    }

    private List<Map<String, Object>> createFireEventParam(MotionEvent motionEvent) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(motionEvent.getHistorySize() + 1);
        list.addAll(this.getHistoricalEvents(motionEvent));
        list.add(this.createFireEventParam(motionEvent, -1));
        return list;
    }

    private List<Map<String, Object>> getHistoricalEvents(MotionEvent motionEvent) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(motionEvent.getHistorySize());
        if (motionEvent.getActionMasked() == 2) {
            for (int i = 0; i < motionEvent.getHistorySize(); ++i) {
                Map<String, Object> param = this.createFireEventParam(motionEvent, i);
                list.add(param);
            }
        }
        return list;
    }

    private Map<String, Object> createFireEventParam(MotionEvent motionEvent, int pos) {
        JSONArray jsonArray = new JSONArray(motionEvent.getPointerCount());
        if (motionEvent.getActionMasked() == 2) {
            for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
                jsonArray.add((Object)this.createJSONObject(motionEvent, pos, i));
            }
        } else if (this.isPointerNumChanged(motionEvent)) {
            int pointerIndex = motionEvent.getActionIndex();
            jsonArray.add((Object)this.createJSONObject(motionEvent, -1, pointerIndex));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("changedTouches", jsonArray);
        return map;
    }

    private boolean isPointerNumChanged(MotionEvent event) {
        return event.getActionMasked() == 0 || event.getActionMasked() == 5 || event.getActionMasked() == 1 || event.getActionMasked() == 6 || event.getActionMasked() == 3;
    }

    private boolean containsPan() {
        return this.component.containsGesture(WXGestureType.HighLevelGesture.PAN_START) || this.component.containsGesture(WXGestureType.HighLevelGesture.PAN_MOVE) || this.component.containsGesture(WXGestureType.HighLevelGesture.PAN_END);
    }

    private JSONObject createJSONObject(MotionEvent motionEvent, int pos, int pointerIndex) {
        PointF screenXY;
        PointF pageXY;
        if (pos == -1) {
            pageXY = this.getEventLocInPageCoordinate(motionEvent, pointerIndex);
            screenXY = this.getEventLocInScreenCoordinate(motionEvent, pointerIndex);
        } else {
            pageXY = this.getEventLocInPageCoordinate(motionEvent, pointerIndex, pos);
            screenXY = this.getEventLocInScreenCoordinate(motionEvent, pointerIndex, pos);
        }
        return this.createJSONObject(screenXY, pageXY, (float)motionEvent.getPointerId(pointerIndex));
    }

    @NonNull
    private JSONObject createJSONObject(PointF screenXY, PointF pageXY, float pointerId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pageX", (Object)Float.valueOf(pageXY.x));
        jsonObject.put("pageY", (Object)Float.valueOf(pageXY.y));
        jsonObject.put("screenX", (Object)Float.valueOf(screenXY.x));
        jsonObject.put("screenY", (Object)Float.valueOf(screenXY.y));
        jsonObject.put("identifier", (Object)Float.valueOf(pointerId));
        return jsonObject;
    }

    private PointF getEventLocInScreenCoordinate(MotionEvent motionEvent, int pointerIndex) {
        return this.getEventLocInScreenCoordinate(motionEvent, pointerIndex, -1);
    }

    private PointF getEventLocInScreenCoordinate(MotionEvent motionEvent, int pointerIndex, int position) {
        float eventY;
        float eventX;
        if (position == -1) {
            eventX = motionEvent.getX(pointerIndex);
            eventY = motionEvent.getY(pointerIndex);
        } else {
            eventX = motionEvent.getHistoricalX(pointerIndex, position);
            eventY = motionEvent.getHistoricalY(pointerIndex, position);
        }
        return this.getEventLocInScreenCoordinate(eventX, eventY);
    }

    @NonNull
    private PointF getEventLocInScreenCoordinate(float eventX, float eventY) {
        this.globalRect.set(0, 0, 0, 0);
        this.globalOffset.set(0, 0);
        this.globalEventOffset.set((int)eventX, (int)eventY);
        this.component.getRealView().getGlobalVisibleRect(this.globalRect, this.globalOffset);
        this.globalEventOffset.offset(this.globalOffset.x, this.globalOffset.y);
        return new PointF(WXViewUtils.getWebPxByWidth(this.globalEventOffset.x), WXViewUtils.getWebPxByWidth(this.globalEventOffset.y));
    }

    private PointF getEventLocInPageCoordinate(MotionEvent motionEvent, int pointerIndex) {
        return this.getEventLocInPageCoordinate(motionEvent, pointerIndex, -1);
    }

    private PointF getEventLocInPageCoordinate(MotionEvent motionEvent, int pointerIndex, int position) {
        float eventY;
        float eventX;
        if (position == -1) {
            eventX = motionEvent.getX(pointerIndex);
            eventY = motionEvent.getY(pointerIndex);
        } else {
            eventX = motionEvent.getHistoricalX(pointerIndex, position);
            eventY = motionEvent.getHistoricalY(pointerIndex, position);
        }
        return this.getEventLocInPageCoordinate(eventX, eventY);
    }

    @NonNull
    private PointF getEventLocInPageCoordinate(float eventX, float eventY) {
        this.locEventOffset.set(eventX, eventY);
        this.locLeftTop.set(0.0f, 0.0f);
        this.component.computeVisiblePointInViewCoordinate(this.locLeftTop);
        this.locEventOffset.offset(this.locLeftTop.x, this.locLeftTop.y);
        return new PointF(WXViewUtils.getWebPxByWidth(this.locEventOffset.x), WXViewUtils.getWebPxByWidth(this.locEventOffset.y));
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private long swipeDownTime = -1L;
        private long panDownTime = -1L;

        private GestureListener() {
        }

        public void onLongPress(MotionEvent e) {
            if (WXGesture.this.component.containsGesture(WXGestureType.HighLevelGesture.LONG_PRESS)) {
                List list = WXGesture.this.createFireEventParam(e);
                WXGesture.this.component.getInstance().fireEvent(WXGesture.this.component.getDomObject().getRef(), WXGestureType.HighLevelGesture.LONG_PRESS.toString(), (Map)list.get(list.size() - 1));
            }
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            boolean result = false;
            if (WXGesture.this.containsPan() && e2.getPointerId(e1.getActionIndex()) == e1.getPointerId(e1.getActionIndex())) {
                if (this.panDownTime != e1.getEventTime()) {
                    this.panDownTime = e1.getEventTime();
                    WXGesture.this.scrolling = true;
                    WXGesture.this.component.getInstance().fireEvent(WXGesture.this.component.getDomObject().getRef(), WXGestureType.HighLevelGesture.PAN_START.toString(), WXGesture.this.createFireEventParam(e1, -1));
                } else {
                    WXGesture.this.component.getInstance().fireEvent(WXGesture.this.component.getDomObject().getRef(), WXGestureType.HighLevelGesture.PAN_MOVE.toString(), WXGesture.this.createFireEventParam(e2, -1));
                }
                result = true;
            }
            if (WXGesture.this.component.containsGesture(WXGestureType.HighLevelGesture.SWIPE) && this.swipeDownTime != e1.getEventTime()) {
                this.swipeDownTime = e1.getEventTime();
                List list = WXGesture.this.createFireEventParam(e2);
                Map param = (Map)list.get(list.size() - 1);
                if (Math.abs(distanceX) > Math.abs(distanceY)) {
                    param.put("direction", distanceX > 0.0f ? "left" : "right");
                } else {
                    param.put("direction", distanceY > 0.0f ? "up" : "down");
                }
                WXGesture.this.component.getInstance().fireEvent(WXGesture.this.component.getDomObject().getRef(), WXGestureType.HighLevelGesture.SWIPE.toString(), param);
                result = true;
            }
            return result;
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }
    }

    private static class GestureHandler
    extends Handler {
        public GestureHandler() {
            super(Looper.getMainLooper());
        }
    }
}

