/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.support.annotation.Nullable;

enum BorderStyle {
    SOLID,
    DASHED,
    DOTTED;


    @Nullable
    Shader getLineShader(float borderWidth, int borderColor, int edge) {
        switch (this) {
            case DOTTED: {
                if (edge == 0 || edge == 2) {
                    return new LinearGradient(0.0f, 0.0f, 0.0f, borderWidth * 2.0f, new int[]{borderColor, 0}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
                }
                if (edge == 1 || edge == 3) {
                    return new LinearGradient(0.0f, 0.0f, borderWidth * 2.0f, 0.0f, new int[]{borderColor, 0}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
                }
            }
            case DASHED: {
                if (edge == 0 || edge == 2) {
                    return new LinearGradient(0.0f, 0.0f, 0.0f, borderWidth * 6.0f, new int[]{borderColor, 0}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
                }
                if (edge != 1 && edge != 3) break;
                return new LinearGradient(0.0f, 0.0f, borderWidth * 6.0f, 0.0f, new int[]{borderColor, 0}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
            }
        }
        return null;
    }
}

