/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.module;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.utils.WXLogUtils;
import java.net.URLDecoder;
import java.util.HashMap;
import org.json.JSONObject;

public class WXModalUIModule
extends WXModule {
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final String RESULT = "result";
    public static final String DATA = "data";
    public static final String MESSAGE = "message";
    public static final String DURATION = "duration";
    public static final String OK_TITLE = "okTitle";
    public static final String CANCEL_TITLE = "cancelTitle";
    private Toast toast;

    @WXModuleAnno
    public void toast(String param) {
        String message = "";
        int duration = 0;
        if (!TextUtils.isEmpty((CharSequence)param)) {
            try {
                param = URLDecoder.decode(param, "utf-8");
                JSONObject jsObj = new JSONObject(param);
                message = jsObj.optString(MESSAGE);
                duration = jsObj.optInt(DURATION);
            }
            catch (Exception e) {
                WXLogUtils.e("[WXModalUIModule] alert param parse error ", e);
            }
        }
        if (TextUtils.isEmpty((CharSequence)message)) {
            WXLogUtils.e("[WXModalUIModule] toast param parse is null ");
            return;
        }
        duration = duration > 3 ? 1 : 0;
        if (this.toast == null) {
            this.toast = Toast.makeText((Context)this.mWXSDKInstance.getContext(), (CharSequence)message, (int)duration);
        } else {
            this.toast.setDuration(duration);
            this.toast.setText((CharSequence)message);
        }
        this.toast.setGravity(17, 0, 0);
        this.toast.show();
    }

    @WXModuleAnno
    public void alert(String param, final JSCallback callback) {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            String message = "";
            String okTitle = OK;
            if (!TextUtils.isEmpty((CharSequence)param)) {
                try {
                    param = URLDecoder.decode(param, "utf-8");
                    JSONObject jsObj = new JSONObject(param);
                    message = jsObj.optString(MESSAGE);
                    okTitle = jsObj.optString(OK_TITLE);
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXModalUIModule] alert param parse error ", e);
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                message = "";
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mWXSDKInstance.getContext());
            builder.setMessage((CharSequence)message);
            final String okTitle_f = TextUtils.isEmpty((CharSequence)okTitle) ? OK : okTitle;
            builder.setPositiveButton((CharSequence)okTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        callback.invoke(okTitle_f);
                    }
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
        } else {
            WXLogUtils.e("[WXModalUIModule] when call alert mWXSDKInstance.getContext() must instanceof Activity");
        }
    }

    @WXModuleAnno
    public void confirm(String param, final JSCallback callback) {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            String message = "";
            String okTitle = OK;
            String cancelTitle = CANCEL;
            if (!TextUtils.isEmpty((CharSequence)param)) {
                try {
                    param = URLDecoder.decode(param, "utf-8");
                    JSONObject jsObj = new JSONObject(param);
                    message = jsObj.optString(MESSAGE);
                    okTitle = jsObj.optString(OK_TITLE);
                    cancelTitle = jsObj.optString(CANCEL_TITLE);
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXModalUIModule] confirm param parse error ", e);
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                message = "";
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mWXSDKInstance.getContext());
            builder.setMessage((CharSequence)message);
            final String okTitle_f = TextUtils.isEmpty((CharSequence)okTitle) ? OK : okTitle;
            final String cancelTitle_f = TextUtils.isEmpty((CharSequence)cancelTitle) ? CANCEL : cancelTitle;
            builder.setPositiveButton((CharSequence)okTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        callback.invoke(okTitle_f);
                    }
                }
            });
            builder.setNegativeButton((CharSequence)cancelTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        callback.invoke(cancelTitle_f);
                    }
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
        } else {
            WXLogUtils.e("[WXModalUIModule] when call confirm mWXSDKInstance.getContext() must instanceof Activity");
        }
    }

    @WXModuleAnno
    public void prompt(String param, final JSCallback callback) {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            String message = "";
            String defaultValue = "";
            String okTitle = OK;
            String cancelTitle = CANCEL;
            if (!TextUtils.isEmpty((CharSequence)param)) {
                try {
                    param = URLDecoder.decode(param, "utf-8");
                    JSONObject jsObj = new JSONObject(param);
                    message = jsObj.optString(MESSAGE);
                    okTitle = jsObj.optString(OK_TITLE);
                    cancelTitle = jsObj.optString(CANCEL_TITLE);
                    defaultValue = jsObj.optString("default");
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXModalUIModule] confirm param parse error ", e);
                }
            }
            if (TextUtils.isEmpty((CharSequence)message)) {
                message = "";
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mWXSDKInstance.getContext());
            builder.setMessage((CharSequence)message);
            final EditText editText = new EditText(this.mWXSDKInstance.getContext());
            editText.setText((CharSequence)defaultValue);
            builder.setView((View)editText);
            final String okTitle_f = TextUtils.isEmpty((CharSequence)okTitle) ? OK : okTitle;
            final String cancelTitle_f = TextUtils.isEmpty((CharSequence)cancelTitle) ? CANCEL : cancelTitle;
            builder.setPositiveButton((CharSequence)okTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        HashMap<String, String> result = new HashMap<String, String>();
                        result.put(WXModalUIModule.RESULT, okTitle_f);
                        result.put(WXModalUIModule.DATA, editText.getText().toString());
                        callback.invoke(result);
                    }
                }
            });
            builder.setNegativeButton((CharSequence)cancelTitle_f, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        HashMap<String, String> result = new HashMap<String, String>();
                        result.put(WXModalUIModule.RESULT, cancelTitle_f);
                        result.put(WXModalUIModule.DATA, editText.getText().toString());
                        callback.invoke(result);
                    }
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.show();
        } else {
            WXLogUtils.e("when call prompt mWXSDKInstance.getContext() must instanceof Activity");
        }
    }
}

