/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.MethodInvoker;
import com.taobao.weex.common.Component;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class SimpleComponentHolder
implements IFComponentHolder {
    public static final String TAG = "SimpleComponentHolder";
    private final Class<? extends WXComponent> mClz;
    private Map<String, Invoker> mMethods;
    private ComponentCreator mCreator;

    public SimpleComponentHolder(Class<? extends WXComponent> clz) {
        this(clz, new ClazzComponentCreator(clz));
    }

    public SimpleComponentHolder(Class<? extends WXComponent> clz, ComponentCreator customCreator) {
        this.mClz = clz;
        this.mCreator = customCreator;
    }

    @Override
    public void loadIfNonLazy() {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.mClz.getDeclaredAnnotations()) {
            if (!(annotation instanceof Component)) continue;
            if (!((Component)annotation).lazyload()) {
                this.generate();
            }
            return;
        }
    }

    private synchronized void generate() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "Generate Component:" + this.mClz.getSimpleName());
        }
        this.mMethods = SimpleComponentHolder.getMethods(this.mClz);
    }

    static Map<String, Invoker> getMethods(Class clz) {
        HashMap<String, Invoker> methods = new HashMap<String, Invoker>();
        try {
            block4: for (Method method : clz.getMethods()) {
                try {
                    for (Annotation anno : method.getDeclaredAnnotations()) {
                        if (anno == null || !(anno instanceof WXComponentProp)) continue;
                        String name = ((WXComponentProp)anno).name();
                        methods.put(name, new MethodInvoker(method));
                        continue block4;
                    }
                }
                catch (ArrayIndexOutOfBoundsException | IncompatibleClassChangeError e) {
                    // empty catch block
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return methods;
    }

    @Override
    public synchronized WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        WXComponent component = this.mCreator.createInstance(instance, node, parent, lazy);
        component.bindHolder(this);
        return component;
    }

    @Override
    public synchronized Invoker getMethod(String name) {
        if (this.mMethods == null) {
            this.generate();
        }
        return this.mMethods.get(name);
    }

    static class ClazzComponentCreator
    implements ComponentCreator {
        private Constructor<? extends WXComponent> mConstructor;
        private final Class<? extends WXComponent> mCompClz;

        ClazzComponentCreator(Class<? extends WXComponent> c) {
            this.mCompClz = c;
        }

        private void loadConstructor() {
            Constructor<? extends WXComponent> constructor;
            Class<? extends WXComponent> c = this.mCompClz;
            try {
                constructor = c.getConstructor(WXSDKInstance.class, WXDomObject.class, WXVContainer.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                WXLogUtils.d("ClazzComponentCreator", "Use deprecated component constructor");
                try {
                    constructor = c.getConstructor(WXSDKInstance.class, WXDomObject.class, WXVContainer.class, String.class, Boolean.TYPE);
                }
                catch (NoSuchMethodException e1) {
                    throw new WXRuntimeException("Can't find constructor of component.");
                }
            }
            this.mConstructor = constructor;
        }

        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            int parameters;
            if (this.mConstructor == null) {
                this.loadConstructor();
            }
            WXComponent component = (parameters = this.mConstructor.getParameterTypes().length) == 4 ? this.mConstructor.newInstance(instance, node, parent, lazy) : this.mConstructor.newInstance(instance, node, parent, instance.getInstanceId(), lazy);
            return component;
        }
    }
}

