/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.flex;

import com.taobao.weex.dom.flex.CSSAlign;
import com.taobao.weex.dom.flex.CSSDirection;
import com.taobao.weex.dom.flex.CSSFlexDirection;
import com.taobao.weex.dom.flex.CSSJustify;
import com.taobao.weex.dom.flex.CSSPositionType;
import com.taobao.weex.dom.flex.CSSWrap;
import com.taobao.weex.dom.flex.Spacing;
import java.util.Arrays;

public class CSSStyle {
    public CSSDirection direction;
    public CSSFlexDirection flexDirection;
    public CSSJustify justifyContent;
    public CSSAlign alignContent;
    public CSSAlign alignItems;
    public CSSAlign alignSelf;
    public CSSPositionType positionType;
    public CSSWrap flexWrap;
    public float flex;
    public Spacing margin = new Spacing();
    public Spacing padding = new Spacing();
    public Spacing border = new Spacing();
    public float[] position = new float[4];
    public float[] dimensions = new float[2];
    public float minWidth = Float.NaN;
    public float minHeight = Float.NaN;
    public float maxWidth = Float.NaN;
    public float maxHeight = Float.NaN;

    CSSStyle() {
        this.reset();
    }

    void reset() {
        this.direction = CSSDirection.INHERIT;
        this.flexDirection = CSSFlexDirection.COLUMN;
        this.justifyContent = CSSJustify.FLEX_START;
        this.alignContent = CSSAlign.FLEX_START;
        this.alignItems = CSSAlign.STRETCH;
        this.alignSelf = CSSAlign.AUTO;
        this.positionType = CSSPositionType.RELATIVE;
        this.flexWrap = CSSWrap.NOWRAP;
        this.flex = 0.0f;
        this.margin.reset();
        this.padding.reset();
        this.border.reset();
        Arrays.fill(this.position, Float.NaN);
        Arrays.fill(this.dimensions, Float.NaN);
        this.minWidth = Float.NaN;
        this.minHeight = Float.NaN;
        this.maxWidth = Float.NaN;
        this.maxHeight = Float.NaN;
    }

    public void copy(CSSStyle cssStyle) {
        this.direction = cssStyle.direction;
        this.flexDirection = cssStyle.flexDirection;
        this.justifyContent = cssStyle.justifyContent;
        this.alignContent = cssStyle.alignContent;
        this.alignItems = cssStyle.alignItems;
        this.alignSelf = cssStyle.alignSelf;
        this.positionType = cssStyle.positionType;
        this.flexWrap = cssStyle.flexWrap;
        this.flex = cssStyle.flex;
        this.margin = cssStyle.margin;
        this.padding = cssStyle.padding;
        this.border = cssStyle.border;
        this.position[1] = cssStyle.position[1];
        this.position[3] = cssStyle.position[3];
        this.position[0] = cssStyle.position[0];
        this.position[2] = cssStyle.position[2];
        this.dimensions[0] = cssStyle.dimensions[0];
        this.dimensions[1] = cssStyle.dimensions[1];
        this.minWidth = cssStyle.minWidth;
        this.minHeight = cssStyle.minHeight;
        this.maxWidth = cssStyle.maxWidth;
        this.maxHeight = cssStyle.maxHeight;
    }

    public String toString() {
        return "direction =" + (Object)((Object)this.direction) + "\n" + "flexDirection =" + (Object)((Object)this.flexDirection) + "\n" + "justifyContent=" + (Object)((Object)this.justifyContent) + "\n" + "alignContent =" + (Object)((Object)this.alignContent) + "\n" + "alignItems =" + (Object)((Object)this.alignItems) + "\n" + "alignSelf =" + (Object)((Object)this.alignSelf) + "\n" + "positionType =" + (Object)((Object)this.positionType) + "\n" + "flexWrap =" + (Object)((Object)this.flexWrap) + "\n" + "flex =" + this.flex + "\n" + "margin =" + this.margin + "\n" + "padding =" + this.padding + "\n" + "border =" + this.border + "\n" + "position[POSITION_TOP] =" + this.position[1] + "\n" + "position[POSITION_BOTTOM] =" + this.position[3] + "\n" + "position[POSITION_LEFT] =" + this.position[0] + "\n" + "position[POSITION_RIGHT] =" + this.position[2] + "\n" + "position[DIMENSION_WIDTH] =" + this.position[0] + "\n" + "position[DIMENSION_HEIGHT] =" + this.position[1] + "\n" + "minWidth =" + this.minWidth + "\n" + "minHeight =" + this.minHeight + "\n" + "maxWidth =" + this.maxWidth + "\n" + "maxHeight =" + this.maxHeight + "\n";
    }
}

