/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.os.Message;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.WXDomTask;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;

public final class WXDomModule
extends WXModule {
    static final String CREATE_BODY = "createBody";
    static final String UPDATE_ATTRS = "updateAttrs";
    static final String UPDATE_STYLE = "updateStyle";
    static final String REMOVE_ELEMENT = "removeElement";
    static final String ADD_ELEMENT = "addElement";
    static final String MOVE_ELEMENT = "moveElement";
    static final String ADD_EVENT = "addEvent";
    static final String REMOVE_EVENT = "removeEvent";
    static final String CREATE_FINISH = "createFinish";
    static final String REFRESH_FINISH = "refreshFinish";
    static final String UPDATE_FINISH = "updateFinish";
    static final String SCROLL_TO_ELEMENT = "scrollToElement";
    static final String ADD_RULE = "addRule";
    public static final String WXDOM = "dom";
    public static final String[] METHODS = new String[]{"createBody", "updateAttrs", "updateStyle", "removeElement", "addElement", "moveElement", "addEvent", "removeEvent", "createFinish", "refreshFinish", "updateFinish", "scrollToElement", "addRule"};

    public void callDomMethod(JSONObject task) {
        if (task == null) {
            return;
        }
        String method = (String)task.get((Object)"method");
        JSONArray args = (JSONArray)task.get((Object)"args");
        if (method == null) {
            return;
        }
        try {
            switch (method) {
                case "createBody": {
                    if (args == null) {
                        return;
                    }
                    this.createBody((JSONObject)args.get(0));
                    break;
                }
                case "updateAttrs": {
                    if (args == null) {
                        return;
                    }
                    this.updateAttrs((String)args.get(0), (JSONObject)args.get(1));
                    break;
                }
                case "updateStyle": {
                    if (args == null) {
                        return;
                    }
                    this.updateStyle((String)args.get(0), (JSONObject)args.get(1));
                    break;
                }
                case "removeElement": {
                    if (args == null) {
                        return;
                    }
                    this.removeElement((String)args.get(0));
                    break;
                }
                case "addElement": {
                    if (args == null) {
                        return;
                    }
                    this.addElement((String)args.get(0), (JSONObject)args.get(1), (Integer)args.get(2));
                    break;
                }
                case "moveElement": {
                    if (args == null) {
                        return;
                    }
                    this.moveElement((String)args.get(0), (String)args.get(1), (Integer)args.get(2));
                    break;
                }
                case "addEvent": {
                    if (args == null) {
                        return;
                    }
                    this.addEvent((String)args.get(0), (String)args.get(1));
                    break;
                }
                case "removeEvent": {
                    if (args == null) {
                        return;
                    }
                    this.removeEvent((String)args.get(0), (String)args.get(1));
                    break;
                }
                case "createFinish": {
                    this.createFinish();
                    break;
                }
                case "refreshFinish": {
                    this.refreshFinish();
                    break;
                }
                case "updateFinish": {
                    this.updateFinish();
                    break;
                }
                case "scrollToElement": {
                    if (args == null) {
                        return;
                    }
                    this.scrollToElement((String)args.get(0), (JSONObject)args.get(1));
                    break;
                }
                case "addRule": {
                    if (args == null) {
                        return;
                    }
                    this.addRule((String)args.get(0), (JSONObject)args.get(1));
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            WXLogUtils.e("Dom module call miss arguments.");
        }
        catch (ClassCastException cce) {
            WXLogUtils.e("Dom module call arguments format error!!");
        }
    }

    public void createBody(JSONObject element) {
        if (element == null) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(element);
        msg.what = 0;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void updateAttrs(String ref, JSONObject attr) {
        if (TextUtils.isEmpty((CharSequence)ref) || attr == null || attr.size() < 1) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(ref);
        task.args.add(attr);
        msg.what = 1;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void updateStyle(String ref, JSONObject style) {
        if (TextUtils.isEmpty((CharSequence)ref) || style == null || style.size() < 1) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(ref);
        task.args.add(style);
        msg.what = 2;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void removeElement(String ref) {
        if (TextUtils.isEmpty((CharSequence)ref)) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(ref);
        msg.what = 4;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void addElement(String parentRef, JSONObject element, Integer index) {
        if (element == null || TextUtils.isEmpty((CharSequence)parentRef)) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(parentRef);
        task.args.add(element);
        task.args.add(index);
        msg.what = 3;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void moveElement(String ref, String parentRef, Integer index) {
        if (TextUtils.isEmpty((CharSequence)ref) || TextUtils.isEmpty((CharSequence)parentRef)) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(ref);
        task.args.add(parentRef);
        task.args.add(index);
        msg.what = 5;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void addEvent(String ref, String type) {
        if (TextUtils.isEmpty((CharSequence)ref) || TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(ref);
        task.args.add(type);
        msg.what = 6;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void removeEvent(String ref, String type) {
        if (TextUtils.isEmpty((CharSequence)ref) || TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(ref);
        task.args.add(type);
        msg.what = 7;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void createFinish() {
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        msg.what = 9;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void refreshFinish() {
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        msg.what = 10;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void updateFinish() {
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        msg.what = 11;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void scrollToElement(String ref, JSONObject options) {
        if (TextUtils.isEmpty((CharSequence)ref) || options == null) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(ref);
        task.args.add(options);
        msg.what = 8;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }

    public void addRule(String type, JSONObject options) {
        if (TextUtils.isEmpty((CharSequence)type) || options == null) {
            return;
        }
        Message msg = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.mWXSDKInstance.getInstanceId();
        task.args = new ArrayList<Object>();
        task.args.add(type);
        task.args.add(options);
        msg.what = 13;
        msg.obj = task;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
    }
}

