/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.common.IWXBridge;
import com.taobao.weex.utils.WXLogUtils;

class WXBridge
implements IWXBridge {
    public static final String TAG = "WXBridge";

    WXBridge() {
    }

    @Override
    public native int initFramework(String var1, WXParams var2);

    @Override
    public native int execJS(String var1, String var2, String var3, WXJSObject[] var4);

    public int callNative(String instanceId, byte[] tasks, String callback) {
        return this.callNative(instanceId, new String(tasks), callback);
    }

    @Override
    public int callNative(String instanceId, String tasks, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block5: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callNative(instanceId, tasks, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block5;
                e.printStackTrace();
                WXLogUtils.e(TAG, "callNative throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        if (WXEnvironment.isApkDebugable() && errorCode == -1) {
            WXLogUtils.w("destroyInstance :" + instanceId + " JSF must stop callNative");
        }
        return errorCode;
    }

    public int callAddElement(String instanceId, String ref, byte[] dom, String index, String callback) {
        return this.callAddElement(instanceId, ref, new String(dom), index, callback);
    }

    @Override
    public int callAddElement(String instanceId, String ref, String dom, String index, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block5: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callAddElement(instanceId, ref, dom, index, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block5;
                e.printStackTrace();
                WXLogUtils.e(TAG, "callNative throw expection:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        if (WXEnvironment.isApkDebugable() && errorCode == -1) {
            WXLogUtils.w("destroyInstance :" + instanceId + " JSF must stop callNative");
        }
        return errorCode;
    }

    @Override
    public void reportJSException(String instanceId, String func, String exception) {
        WXBridgeManager.getInstance().reportJSException(instanceId, func, exception);
    }

    public void setTimeoutNative(String callbackId, String time) {
        WXBridgeManager.getInstance().setTimeout(callbackId, time);
    }

    public void setJSFrmVersion(String version) {
        if (!TextUtils.isEmpty((CharSequence)version)) {
            WXEnvironment.JS_LIB_SDK_VERSION = version;
        }
    }
}

