/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.DefaultWXHttpAdapter;
import com.taobao.weex.adapter.IWXDebugAdapter;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.appfram.navigator.IActivityNavBarSetter;
import com.taobao.weex.appfram.storage.DefaultWXStorage;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.WXDomManager;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WXSDKManager {
    private static WXSDKManager sManager;
    private static AtomicInteger sInstanceId;
    private final WXDomManager mWXDomManager;
    private WXBridgeManager mBridgeManager;
    WXRenderManager mWXRenderManager = new WXRenderManager();
    private IWXUserTrackAdapter mIWXUserTrackAdapter;
    private IWXImgLoaderAdapter mIWXImgLoaderAdapter;
    private IWXHttpAdapter mIWXHttpAdapter;
    private IWXDebugAdapter mIWXDebugAdapter;
    private IActivityNavBarSetter mActivityNavBarSetter;
    private IWXStorageAdapter mIWXStorageAdapter;

    private WXSDKManager() {
        this.mWXDomManager = new WXDomManager(this.mWXRenderManager);
        this.mBridgeManager = WXBridgeManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXSDKManager getInstance() {
        if (sManager != null) return sManager;
        Class<WXSDKManager> clazz = WXSDKManager.class;
        synchronized (WXSDKManager.class) {
            if (sManager != null) return sManager;
            sManager = new WXSDKManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sManager;
        }
    }

    public IActivityNavBarSetter getActivityNavBarSetter() {
        return this.mActivityNavBarSetter;
    }

    public void setActivityNavBarSetter(IActivityNavBarSetter mActivityNavBarSetter) {
        this.mActivityNavBarSetter = mActivityNavBarSetter;
    }

    public void restartBridge() {
        this.mBridgeManager.restart();
    }

    public WXDomManager getWXDomManager() {
        return this.mWXDomManager;
    }

    public WXBridgeManager getWXBridgeManager() {
        return this.mBridgeManager;
    }

    public WXRenderManager getWXRenderManager() {
        return this.mWXRenderManager;
    }

    public WXSDKInstance getSDKInstance(String instanceId) {
        return this.mWXRenderManager.getWXSDKInstance(instanceId);
    }

    public void postOnUiThread(Runnable runnable, long delayMillis) {
        this.mWXRenderManager.postOnUiThread(WXThread.secure(runnable), delayMillis);
    }

    public void destroy() {
        if (this.mWXDomManager != null) {
            this.mWXDomManager.destroy();
        }
    }

    @Deprecated
    public void callback(String instanceId, String funcId, Map<String, Object> data) {
        this.mBridgeManager.callback(instanceId, funcId, data);
    }

    @Deprecated
    public void callback(String instanceId, String funcId, Map<String, Object> data, boolean keepAlive) {
        this.mBridgeManager.callback(instanceId, funcId, data, true);
    }

    public void initScriptsFramework(String framework) {
        this.mBridgeManager.initScriptsFramework(framework);
    }

    public void registerComponents(List<Map<String, String>> components) {
        this.mBridgeManager.registerComponents(components);
    }

    public void registerModules(Map<String, Object> modules) {
        this.mBridgeManager.registerModules(modules);
    }

    public void fireEvent(String instanceId, String ref, String type) {
        this.fireEvent(instanceId, ref, type, new HashMap<String, Object>());
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> params) {
        this.fireEvent(instanceId, ref, type, params, null);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> params, Map<String, Object> domChanges) {
        if (WXEnvironment.isApkDebugable() && Looper.getMainLooper().getThread().getId() != Thread.currentThread().getId()) {
            throw new WXRuntimeException("[WXSDKManager]  fireEvent error");
        }
        this.mBridgeManager.fireEventOnNode(instanceId, ref, type, params, domChanges);
    }

    void createInstance(WXSDKInstance instance, String code, Map<String, Object> options, String jsonInitData) {
        this.mWXRenderManager.registerInstance(instance);
        this.mBridgeManager.createInstance(instance.getInstanceId(), code, options, jsonInitData);
    }

    void refreshInstance(String instanceId, WXRefreshData jsonData) {
        this.mBridgeManager.refreshInstance(instanceId, jsonData);
    }

    void destroyInstance(String instanceId) {
        if (TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXSDKManager] destroyInstance error");
        }
        this.mWXRenderManager.removeRenderStatement(instanceId);
        this.mWXDomManager.removeDomStatement(instanceId);
        this.mBridgeManager.destroyInstance(instanceId);
        WXModuleManager.destroyInstanceModules(instanceId);
    }

    String generateInstanceId() {
        return String.valueOf(sInstanceId.incrementAndGet());
    }

    public IWXUserTrackAdapter getIWXUserTrackAdapter() {
        return this.mIWXUserTrackAdapter;
    }

    void setIWXUserTrackAdapter(IWXUserTrackAdapter IWXUserTrackAdapter2) {
        this.mIWXUserTrackAdapter = IWXUserTrackAdapter2;
    }

    public IWXImgLoaderAdapter getIWXImgLoaderAdapter() {
        return this.mIWXImgLoaderAdapter;
    }

    void setIWXImgLoaderAdapter(IWXImgLoaderAdapter IWXImgLoaderAdapter2) {
        if (IWXImgLoaderAdapter2 == null) {
            throw new NullPointerException("image adapter is null!");
        }
        this.mIWXImgLoaderAdapter = IWXImgLoaderAdapter2;
    }

    @NonNull
    public IWXHttpAdapter getIWXHttpAdapter() {
        if (this.mIWXHttpAdapter == null) {
            this.mIWXHttpAdapter = new DefaultWXHttpAdapter();
        }
        return this.mIWXHttpAdapter;
    }

    void setIWXHttpAdapter(IWXHttpAdapter IWXHttpAdapter2) {
        this.mIWXHttpAdapter = IWXHttpAdapter2;
    }

    public IWXDebugAdapter getIWXDebugAdapter() {
        return this.mIWXDebugAdapter;
    }

    public void setIWXDebugAdapter(IWXDebugAdapter IWXDebugAdapter2) {
        this.mIWXDebugAdapter = IWXDebugAdapter2;
    }

    void setIWXStorageAdapter(IWXStorageAdapter storageAdapter) {
        this.mIWXStorageAdapter = storageAdapter;
    }

    public IWXStorageAdapter getIWXStorageAdapter() {
        if (this.mIWXStorageAdapter == null) {
            if (WXEnvironment.sApplication != null) {
                this.mIWXStorageAdapter = new DefaultWXStorage((Context)WXEnvironment.sApplication);
            } else {
                WXLogUtils.e("WXStorageModule", "No Application context found,you should call WXSDKEngine#initialize() method in your application");
            }
        }
        return this.mIWXStorageAdapter;
    }

    static {
        sInstanceId = new AtomicInteger(0);
    }
}

