/**
 *
 *                                  Apache License
 *                            Version 2.0, January 2004
 *                         http://www.apache.org/licenses/
 *
 *    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 *
 *    1. Definitions.
 *
 *       "License" shall mean the terms and conditions for use, reproduction,
 *       and distribution as defined by Sections 1 through 9 of this document.
 *
 *       "Licensor" shall mean the copyright owner or entity authorized by
 *       the copyright owner that is granting the License.
 *
 *       "Legal Entity" shall mean the union of the acting entity and all
 *       other entities that control, are controlled by, or are under common
 *       control with that entity. For the purposes of this definition,
 *       "control" means (i) the power, direct or indirect, to cause the
 *       direction or management of such entity, whether by contract or
 *       otherwise, or (ii) ownership of fifty percent (50%) or more of the
 *       outstanding shares, or (iii) beneficial ownership of such entity.
 *
 *       "You" (or "Your") shall mean an individual or Legal Entity
 *       exercising permissions granted by this License.
 *
 *       "Source" form shall mean the preferred form for making modifications,
 *       including but not limited to software source code, documentation
 *       source, and configuration files.
 *
 *       "Object" form shall mean any form resulting from mechanical
 *       transformation or translation of a Source form, including but
 *       not limited to compiled object code, generated documentation,
 *       and conversions to other media types.
 *
 *       "Work" shall mean the work of authorship, whether in Source or
 *       Object form, made available under the License, as indicated by a
 *       copyright notice that is included in or attached to the work
 *       (an example is provided in the Appendix below).
 *
 *       "Derivative Works" shall mean any work, whether in Source or Object
 *       form, that is based on (or derived from) the Work and for which the
 *       editorial revisions, annotations, elaborations, or other modifications
 *       represent, as a whole, an original work of authorship. For the purposes
 *       of this License, Derivative Works shall not include works that remain
 *       separable from, or merely link (or bind by name) to the interfaces of,
 *       the Work and Derivative Works thereof.
 *
 *       "Contribution" shall mean any work of authorship, including
 *       the original version of the Work and any modifications or additions
 *       to that Work or Derivative Works thereof, that is intentionally
 *       submitted to Licensor for inclusion in the Work by the copyright owner
 *       or by an individual or Legal Entity authorized to submit on behalf of
 *       the copyright owner. For the purposes of this definition, "submitted"
 *       means any form of electronic, verbal, or written communication sent
 *       to the Licensor or its representatives, including but not limited to
 *       communication on electronic mailing lists, source code control systems,
 *       and issue tracking systems that are managed by, or on behalf of, the
 *       Licensor for the purpose of discussing and improving the Work, but
 *       excluding communication that is conspicuously marked or otherwise
 *       designated in writing by the copyright owner as "Not a Contribution."
 *
 *       "Contributor" shall mean Licensor and any individual or Legal Entity
 *       on behalf of whom a Contribution has been received by Licensor and
 *       subsequently incorporated within the Work.
 *
 *    2. Grant of Copyright License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       copyright license to reproduce, prepare Derivative Works of,
 *       publicly display, publicly perform, sublicense, and distribute the
 *       Work and such Derivative Works in Source or Object form.
 *
 *    3. Grant of Patent License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       (except as stated in this section) patent license to make, have made,
 *       use, offer to sell, sell, import, and otherwise transfer the Work,
 *       where such license applies only to those patent claims licensable
 *       by such Contributor that are necessarily infringed by their
 *       Contribution(s) alone or by combination of their Contribution(s)
 *       with the Work to which such Contribution(s) was submitted. If You
 *       institute patent litigation against any entity (including a
 *       cross-claim or counterclaim in a lawsuit) alleging that the Work
 *       or a Contribution incorporated within the Work constitutes direct
 *       or contributory patent infringement, then any patent licenses
 *       granted to You under this License for that Work shall terminate
 *       as of the date such litigation is filed.
 *
 *    4. Redistribution. You may reproduce and distribute copies of the
 *       Work or Derivative Works thereof in any medium, with or without
 *       modifications, and in Source or Object form, provided that You
 *       meet the following conditions:
 *
 *       (a) You must give any other recipients of the Work or
 *           Derivative Works a copy of this License; and
 *
 *       (b) You must cause any modified files to carry prominent notices
 *           stating that You changed the files; and
 *
 *       (c) You must retain, in the Source form of any Derivative Works
 *           that You distribute, all copyright, patent, trademark, and
 *           attribution notices from the Source form of the Work,
 *           excluding those notices that do not pertain to any part of
 *           the Derivative Works; and
 *
 *       (d) If the Work includes a "NOTICE" text file as part of its
 *           distribution, then any Derivative Works that You distribute must
 *           include a readable copy of the attribution notices contained
 *           within such NOTICE file, excluding those notices that do not
 *           pertain to any part of the Derivative Works, in at least one
 *           of the following places: within a NOTICE text file distributed
 *           as part of the Derivative Works; within the Source form or
 *           documentation, if provided along with the Derivative Works; or,
 *           within a display generated by the Derivative Works, if and
 *           wherever such third-party notices normally appear. The contents
 *           of the NOTICE file are for informational purposes only and
 *           do not modify the License. You may add Your own attribution
 *           notices within Derivative Works that You distribute, alongside
 *           or as an addendum to the NOTICE text from the Work, provided
 *           that such additional attribution notices cannot be construed
 *           as modifying the License.
 *
 *       You may add Your own copyright statement to Your modifications and
 *       may provide additional or different license terms and conditions
 *       for use, reproduction, or distribution of Your modifications, or
 *       for any such Derivative Works as a whole, provided Your use,
 *       reproduction, and distribution of the Work otherwise complies with
 *       the conditions stated in this License.
 *
 *    5. Submission of Contributions. Unless You explicitly state otherwise,
 *       any Contribution intentionally submitted for inclusion in the Work
 *       by You to the Licensor shall be under the terms and conditions of
 *       this License, without any additional terms or conditions.
 *       Notwithstanding the above, nothing herein shall supersede or modify
 *       the terms of any separate license agreement you may have executed
 *       with Licensor regarding such Contributions.
 *
 *    6. Trademarks. This License does not grant permission to use the trade
 *       names, trademarks, service marks, or product names of the Licensor,
 *       except as required for reasonable and customary use in describing the
 *       origin of the Work and reproducing the content of the NOTICE file.
 *
 *    7. Disclaimer of Warranty. Unless required by applicable law or
 *       agreed to in writing, Licensor provides the Work (and each
 *       Contributor provides its Contributions) on an "AS IS" BASIS,
 *       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *       implied, including, without limitation, any warranties or conditions
 *       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 *       PARTICULAR PURPOSE. You are solely responsible for determining the
 *       appropriateness of using or redistributing the Work and assume any
 *       risks associated with Your exercise of permissions under this License.
 *
 *    8. Limitation of Liability. In no event and under no legal theory,
 *       whether in tort (including negligence), contract, or otherwise,
 *       unless required by applicable law (such as deliberate and grossly
 *       negligent acts) or agreed to in writing, shall any Contributor be
 *       liable to You for damages, including any direct, indirect, special,
 *       incidental, or consequential damages of any character arising as a
 *       result of this License or out of the use or inability to use the
 *       Work (including but not limited to damages for loss of goodwill,
 *       work stoppage, computer failure or malfunction, or any and all
 *       other commercial damages or losses), even if such Contributor
 *       has been advised of the possibility of such damages.
 *
 *    9. Accepting Warranty or Additional Liability. While redistributing
 *       the Work or Derivative Works thereof, You may choose to offer,
 *       and charge a fee for, acceptance of support, warranty, indemnity,
 *       or other liability obligations and/or rights consistent with this
 *       License. However, in accepting such obligations, You may act only
 *       on Your own behalf and on Your sole responsibility, not on behalf
 *       of any other Contributor, and only if You agree to indemnify,
 *       defend, and hold each Contributor harmless for any liability
 *       incurred by, or claims asserted against, such Contributor by reason
 *       of your accepting any such warranty or additional liability.
 *
 *    END OF TERMS AND CONDITIONS
 *
 *    APPENDIX: How to apply the Apache License to your work.
 *
 *       To apply the Apache License to your work, attach the following
 *       boilerplate notice, with the fields enclosed by brackets "[]"
 *       replaced with your own identifying information. (Don't include
 *       the brackets!)  The text should be enclosed in the appropriate
 *       comment syntax for the file format. We also recommend that a
 *       file or class name and description of purpose be included on the
 *       same "printed page" as the copyright notice for easier
 *       identification within third-party archives.
 *
 *    Copyright 2016 Alibaba Group
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.taobao.weex.utils;

import android.graphics.Color;
import android.text.TextUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Class for parse color
 */
public class WXResourceUtils {

  private final static Map<String, Integer> colorMap = new HashMap<>();
  private final static Pattern RGB_PATTERN = Pattern.compile("^#[0-9a-fA-F]{3,9}$");
  private final static Pattern FUNCTION_RGBA_PATTERN = Pattern.compile("^(rgba?[\\(])([\\s]*[0-9%]+[\\s]*),([\\s]*[0-9%]+[\\s]*),(([\\s]*[0-9%]+[\\s]*),)?([\\s]*[0-9.]+[\\s]*)[\\)]$");

  static {
    colorMap.put("aliceblue", 0XFFF0F8FF);
    colorMap.put("antiquewhite", 0XFFFAEBD7);
    colorMap.put("aqua", 0XFF00FFFF);
    colorMap.put("aquamarine", 0XFF7FFFD4);
    colorMap.put("azure", 0XFFF0FFFF);
    colorMap.put("beige", 0XFFF5F5DC);
    colorMap.put("bisque", 0XFFFFE4C4);
    colorMap.put("black", 0XFF000000);
    colorMap.put("blanchedalmond", 0XFFFFEBCD);
    colorMap.put("blue", 0XFF0000FF);
    colorMap.put("blueviolet", 0XFF8A2BE2);
    colorMap.put("brown", 0XFFA52A2A);
    colorMap.put("burlywood", 0XFFDEB887);
    colorMap.put("cadetblue", 0XFF5F9EA0);
    colorMap.put("chartreuse", 0XFF7FFF00);
    colorMap.put("chocolate", 0XFFD2691E);
    colorMap.put("coral", 0XFFFF7F50);
    colorMap.put("cornflowerblue", 0XFF6495ED);
    colorMap.put("cornsilk", 0XFFFFF8DC);
    colorMap.put("crimson", 0XFFDC143C);
    colorMap.put("cyan", 0XFF00FFFF);
    colorMap.put("darkblue", 0XFF00008B);
    colorMap.put("darkcyan", 0XFF008B8B);
    colorMap.put("darkgoldenrod", 0XFFB8860B);
    colorMap.put("darkgray", 0XFFA9A9A9);
    colorMap.put("darkgreen", 0XFF006400);
    colorMap.put("darkkhaki", 0XFFBDB76B);
    colorMap.put("darkmagenta", 0XFF8B008B);
    colorMap.put("darkolivegreen", 0XFF556B2F);
    colorMap.put("darkorange", 0XFFFF8C00);
    colorMap.put("darkorchid", 0XFF9932CC);
    colorMap.put("darkred", 0XFF8B0000);
    colorMap.put("darksalmon", 0XFFE9967A);
    colorMap.put("darkseagreen", 0XFF8FBC8F);
    colorMap.put("darkslateblue", 0XFF483D8B);
    colorMap.put("darkslategray", 0XFF2F4F4F);
    colorMap.put("darkslategrey", 0XFF2F4F4F);
    colorMap.put("darkturquoise", 0XFF00CED1);
    colorMap.put("darkviolet", 0XFF9400D3);
    colorMap.put("deeppink", 0XFFFF1493);
    colorMap.put("deepskyblue", 0XFF00BFFF);
    colorMap.put("dimgray", 0XFF696969);
    colorMap.put("dimgrey", 0XFF696969);
    colorMap.put("dodgerblue", 0XFF1E90FF);
    colorMap.put("firebrick", 0XFFB22222);
    colorMap.put("floralwhite", 0XFFFFFAF0);
    colorMap.put("forestgreen", 0XFF228B22);
    colorMap.put("fuchsia", 0XFFFF00FF);
    colorMap.put("gainsboro", 0XFFDCDCDC);
    colorMap.put("ghostwhite", 0XFFF8F8FF);
    colorMap.put("gold", 0XFFFFD700);
    colorMap.put("goldenrod", 0XFFDAA520);
    colorMap.put("gray", 0XFF808080);
    colorMap.put("grey", 0XFF808080);
    colorMap.put("green", 0XFF008000);
    colorMap.put("greenyellow", 0XFFADFF2F);
    colorMap.put("honeydew", 0XFFF0FFF0);
    colorMap.put("hotpink", 0XFFFF69B4);
    colorMap.put("indianred", 0XFFCD5C5C);
    colorMap.put("indigo", 0XFF4B0082);
    colorMap.put("ivory", 0XFFFFFFF0);
    colorMap.put("khaki", 0XFFF0E68C);
    colorMap.put("lavender", 0XFFE6E6FA);
    colorMap.put("lavenderblush", 0XFFFFF0F5);
    colorMap.put("lawngreen", 0XFF7CFC00);
    colorMap.put("lemonchiffon", 0XFFFFFACD);
    colorMap.put("lightblue", 0XFFADD8E6);
    colorMap.put("lightcoral", 0XFFF08080);
    colorMap.put("lightcyan", 0XFFE0FFFF);
    colorMap.put("lightgoldenrodyellow", 0XFFFAFAD2);
    colorMap.put("lightgray", 0XFFD3D3D3);
    colorMap.put("lightgrey", 0XFFD3D3D3);
    colorMap.put("lightgreen", 0XFF90EE90);
    colorMap.put("lightpink", 0XFFFFB6C1);
    colorMap.put("lightsalmon", 0XFFFFA07A);
    colorMap.put("lightseagreen", 0XFF20B2AA);
    colorMap.put("lightskyblue", 0XFF87CEFA);
    colorMap.put("lightslategray", 0XFF778899);
    colorMap.put("lightslategrey", 0XFF778899);
    colorMap.put("lightsteelblue", 0XFFB0C4DE);
    colorMap.put("lightyellow", 0XFFFFFFE0);
    colorMap.put("lime", 0XFF00FF00);
    colorMap.put("limegreen", 0XFF32CD32);
    colorMap.put("linen", 0XFFFAF0E6);
    colorMap.put("magenta", 0XFFFF00FF);
    colorMap.put("maroon", 0XFF800000);
    colorMap.put("mediumaquamarine", 0XFF66CDAA);
    colorMap.put("mediumblue", 0XFF0000CD);
    colorMap.put("mediumorchid", 0XFFBA55D3);
    colorMap.put("mediumpurple", 0XFF9370DB);
    colorMap.put("mediumseagreen", 0XFF3CB371);
    colorMap.put("mediumslateblue", 0XFF7B68EE);
    colorMap.put("mediumspringgreen", 0XFF00FA9A);
    colorMap.put("mediumturquoise", 0XFF48D1CC);
    colorMap.put("mediumvioletred", 0XFFC71585);
    colorMap.put("midnightblue", 0XFF191970);
    colorMap.put("mintcream", 0XFFF5FFFA);
    colorMap.put("mistyrose", 0XFFFFE4E1);
    colorMap.put("moccasin", 0XFFFFE4B5);
    colorMap.put("navajowhite", 0XFFFFDEAD);
    colorMap.put("navy", 0XFF000080);
    colorMap.put("oldlace", 0XFFFDF5E6);
    colorMap.put("olive", 0XFF808000);
    colorMap.put("olivedrab", 0XFF6B8E23);
    colorMap.put("orange", 0XFFFFA500);
    colorMap.put("orangered", 0XFFFF4500);
    colorMap.put("orchid", 0XFFDA70D6);
    colorMap.put("palegoldenrod", 0XFFEEE8AA);
    colorMap.put("palegreen", 0XFF98FB98);
    colorMap.put("paleturquoise", 0XFFAFEEEE);
    colorMap.put("palevioletred", 0XFFDB7093);
    colorMap.put("papayawhip", 0XFFFFEFD5);
    colorMap.put("peachpuff", 0XFFFFDAB9);
    colorMap.put("peru", 0XFFCD853F);
    colorMap.put("pink", 0XFFFFC0CB);
    colorMap.put("plum", 0XFFDDA0DD);
    colorMap.put("powderblue", 0XFFB0E0E6);
    colorMap.put("purple", 0XFF800080);
    colorMap.put("rebeccapurple", 0XFF663399);
    colorMap.put("red", 0XFFFF0000);
    colorMap.put("rosybrown", 0XFFBC8F8F);
    colorMap.put("royalblue", 0XFF4169E1);
    colorMap.put("saddlebrown", 0XFF8B4513);
    colorMap.put("salmon", 0XFFFA8072);
    colorMap.put("sandybrown", 0XFFF4A460);
    colorMap.put("seagreen", 0XFF2E8B57);
    colorMap.put("seashell", 0XFFFFF5EE);
    colorMap.put("sienna", 0XFFA0522D);
    colorMap.put("silver", 0XFFC0C0C0);
    colorMap.put("skyblue", 0XFF87CEEB);
    colorMap.put("slateblue", 0XFF6A5ACD);
    colorMap.put("slategray", 0XFF708090);
    colorMap.put("slategrey", 0XFF708090);
    colorMap.put("snow", 0XFFFFFAFA);
    colorMap.put("springgreen", 0XFF00FF7F);
    colorMap.put("steelblue", 0XFF4682B4);
    colorMap.put("tan", 0XFFD2B48C);
    colorMap.put("teal", 0XFF008080);
    colorMap.put("thistle", 0XFFD8BFD8);
    colorMap.put("tomato", 0XFFFF6347);
    colorMap.put("turquoise", 0XFF40E0D0);
    colorMap.put("violet", 0XFFEE82EE);
    colorMap.put("wheat", 0XFFF5DEB3);
    colorMap.put("white", 0XFFFFFFFF);
    colorMap.put("whitesmoke", 0XFFF5F5F5);
    colorMap.put("yellow", 0XFFFFFF00);
    colorMap.put("yellowgreen", 0XFF9ACD32);
    colorMap.put("transparent", 0x00000000);
  }


  public static int getColor(String color) {
    return getColor(color, Integer.MIN_VALUE);
  }

  public static int getColor(String color, int defaultColor) {
    if (TextUtils.isEmpty(color)) {
      return defaultColor;
    }
    color = color.trim(); //remove non visible codes

    int resultColor = defaultColor;
    try {
      ColorConvertHandler[] handlers = ColorConvertHandler.values();
      Integer convertedColor;
      for (ColorConvertHandler handler : handlers) {
        convertedColor = handler.handle(color);
        if (convertedColor != null) {
          resultColor = convertedColor;
          break;
        }
      }
    } catch (Exception e) {
      WXLogUtils.e("WXResourceUtils getColor failed: " + color);
    }
    return resultColor;
  }

  enum ColorConvertHandler {
    NAMED_COLOR_HANDLER {
      @Override
      Integer handle(String rawColor) {
        return colorMap.get(rawColor);
      }
    },
    RGB_HANDLER {
      @Override
      Integer handle(String rawColor) {
        if (RGB_PATTERN.matcher(rawColor).matches()) {
          if (rawColor.length() == 4) {
            //#eee, #333
            int result = 0;
            for (int i = 1; i < 4; i++) {
              result = (result << 8) + 17 * Character.digit(rawColor.charAt(i), 16);
            }
            return result | 0xff000000;
          } else if (rawColor.length() == 7 || rawColor.length() == 9) {
            //#eeeeee, #333333
            return Color.parseColor(rawColor);
          } else {
            throw new IllegalArgumentException("ColorConvertHandler invalid color: " + rawColor);
          }
        }
        return null;
      }
    },
    FUNCTIONAL_RGBA_HANDLER {
      @Override
      Integer handle(String rawColor) {
        return convertFunctionalColor(rawColor);
      }
    };

    /**
     * Parse a functional RGB to #RRGGBB or functional RGBA to #AARRGGBB
     * @param raw functional RGB or functional RGBA
     * @return #RRGGBB or #AARRGGBB
     */
    private static Integer convertFunctionalColor(String raw) {
      Matcher matcher = FUNCTION_RGBA_PATTERN.matcher(raw);
      if (matcher.matches()) {
        boolean alpha = matcher.group(1).startsWith("rgba");
        String[] gradients = new String [alpha ? 4 : 3];
        gradients[0] = matcher.group(2);
        gradients[1] = matcher.group(3);
        if (alpha) {
          gradients[2] = matcher.group(5);
          gradients[3] = matcher.group(6);
        } else {
          gradients[2] = matcher.group(6);
        }
        return parseRGBA(gradients);
      }
      return null;
    }

    /**
     * Parse Functional RGB to RRGGBB mode
     * @param gradients gradients of functional RGB
     * @return RRGGBB color
     */
    private static Integer parseRGBA(String[] gradients) {
      int[] digits = new int[4];
      if (gradients.length == 3) {
        digits[3] = 0xff;
      }
      int percent_loc;
      int value;
      String gradient;
      for (int i = 0; i < gradients.length; i++) {
        gradient = gradients[i].trim();
        if ((percent_loc = gradient.lastIndexOf("%")) != -1) {
          gradient = gradient.substring(0, percent_loc);
          value = (int) (Float.parseFloat(gradient) / 100 * 255);
        } else {
          float temp = Float.parseFloat(gradient);
          if (0f < temp && temp <= 1f && i == 3) {
            value = (int) (temp * 255);
          } else {
            value = (int) temp;
          }
        }
        if (value < 0 || value > 255) {
          throw new IllegalArgumentException("ColorConvertHandler invalid gradient: " + gradient);
        }
        digits[i] = value;
      }

      int result = digits[3];
      for (int i = 0; i < 3; i++) {
        result = (result << 8) + digits[i];
      }
      return result;
    }

    /**
     * Parse color to #RRGGBB or #AARRGGBB. The parsing algorithm depends on sub-class.
     * @param rawColor color, maybe functional RGB(RGBA), #RGB, keywords color or transparent
     * @return #RRGGBB or #AARRGGBB
     */
    abstract Integer handle(String rawColor);
  }
}
