/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import com.taobao.weex.utils.WXInterception;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WXHack {
    private static AssertionFailureHandler sFailureHandler;

    private WXHack() {
    }

    public static <T> HackedClass<T> into(Class<T> clazz) {
        return new HackedClass<T>(clazz);
    }

    public static <T> HackedClass<T> into(String class_name) throws HackDeclaration.HackAssertionException {
        try {
            return new HackedClass(Class.forName(class_name));
        }
        catch (ClassNotFoundException e) {
            WXHack.fail(new HackDeclaration.HackAssertionException(e));
            return new HackedClass(null);
        }
    }

    private static void fail(HackDeclaration.HackAssertionException e) throws HackDeclaration.HackAssertionException {
        if (sFailureHandler == null || !sFailureHandler.onAssertionFailure(e)) {
            throw e;
        }
    }

    public static void setAssertionFailureHandler(AssertionFailureHandler handler) {
        sFailureHandler = handler;
    }

    public static class HackedClass<C> {
        protected Class<C> mClass;

        public HackedClass(Class<C> clazz) {
            this.mClass = clazz;
        }

        public HackedField<C, Object> staticField(String name) throws HackDeclaration.HackAssertionException {
            return new HackedField(this.mClass, name, 8);
        }

        public HackedField<C, Object> field(String name) throws HackDeclaration.HackAssertionException {
            return new HackedField(this.mClass, name, 0);
        }

        public HackedMethod staticMethod(String name, Class<?> ... arg_types) throws HackDeclaration.HackAssertionException {
            return new HackedMethod(this.mClass, name, arg_types, 8);
        }

        public HackedMethod method(String name, Class<?> ... arg_types) throws HackDeclaration.HackAssertionException {
            return new HackedMethod(this.mClass, name, arg_types, 0);
        }

        public HackedConstructor constructor(Class<?> ... arg_types) throws HackDeclaration.HackAssertionException {
            return new HackedConstructor(this.mClass, arg_types);
        }

        public Class<C> getmClass() {
            return this.mClass;
        }
    }

    public static class HackedConstructor {
        protected Constructor<?> mConstructor;

        HackedConstructor(Class<?> clazz, Class<?>[] arg_types) throws HackDeclaration.HackAssertionException {
            try {
                if (clazz == null) {
                    return;
                }
                this.mConstructor = clazz.getDeclaredConstructor(arg_types);
            }
            catch (NoSuchMethodException e) {
                HackDeclaration.HackAssertionException hae = new HackDeclaration.HackAssertionException(e);
                hae.setHackedClass(clazz);
                WXHack.fail(hae);
            }
        }

        public Object getInstance(Object ... arg_types) throws IllegalArgumentException {
            Object obj = null;
            this.mConstructor.setAccessible(true);
            try {
                obj = this.mConstructor.newInstance(arg_types);
            }
            catch (Exception e) {
                WXLogUtils.e("", e);
            }
            return obj;
        }
    }

    public static class HackedMethod {
        protected final Method mMethod;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HackedMethod(Class<?> clazz, String name, Class<?>[] arg_types, int modifiers) throws HackDeclaration.HackAssertionException {
            Method method = null;
            try {
                if (clazz == null) {
                    return;
                }
                method = clazz.getDeclaredMethod(name, arg_types);
                if (modifiers > 0 && (method.getModifiers() & modifiers) != modifiers) {
                    WXHack.fail(new HackDeclaration.HackAssertionException(method + " does not match modifiers: " + modifiers));
                }
                method.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                HackDeclaration.HackAssertionException hae = new HackDeclaration.HackAssertionException(e);
                hae.setHackedClass(clazz);
                hae.setHackedMethodName(name);
                WXHack.fail(hae);
            }
            finally {
                this.mMethod = method;
            }
        }

        public Object invoke(Object receiver, Object ... args) throws IllegalArgumentException, InvocationTargetException {
            Object obj = null;
            try {
                obj = this.mMethod.invoke(receiver, args);
                return obj;
            }
            catch (IllegalAccessException e) {
                WXLogUtils.e("", e);
                return obj;
            }
        }

        public Method getMethod() {
            return this.mMethod;
        }
    }

    public static class HackedField<C, T> {
        private final Field mField;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HackedField(Class<C> clazz, String name, int modifiers) throws HackDeclaration.HackAssertionException {
            Field field = null;
            try {
                if (clazz == null) {
                    return;
                }
                field = clazz.getDeclaredField(name);
                if (modifiers > 0 && (field.getModifiers() & modifiers) != modifiers) {
                    WXHack.fail(new HackDeclaration.HackAssertionException(field + " does not match modifiers: " + modifiers));
                }
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                HackDeclaration.HackAssertionException hae = new HackDeclaration.HackAssertionException(e);
                hae.setHackedClass(clazz);
                hae.setHackedFieldName(name);
                WXHack.fail(hae);
            }
            finally {
                this.mField = field;
            }
        }

        public <T2> HackedField<C, T2> ofGenericType(Class<?> type) throws HackDeclaration.HackAssertionException {
            if (this.mField != null && !type.isAssignableFrom(this.mField.getType())) {
                WXHack.fail(new HackDeclaration.HackAssertionException(new ClassCastException(this.mField + " is not of type " + type)));
            }
            return this;
        }

        public HackedField<C, T> ofType(String type_name) throws HackDeclaration.HackAssertionException {
            try {
                return this.ofType(Class.forName(type_name));
            }
            catch (ClassNotFoundException e) {
                WXHack.fail(new HackDeclaration.HackAssertionException(e));
                return this;
            }
        }

        public <T2> HackedField<C, T2> ofType(Class<T2> type) throws HackDeclaration.HackAssertionException {
            if (this.mField != null && !type.isAssignableFrom(this.mField.getType())) {
                WXHack.fail(new HackDeclaration.HackAssertionException(new ClassCastException(this.mField + " is not of type " + type)));
            }
            return this;
        }

        public void hijack(C instance, WXInterception.InterceptionHandler<?> handler) {
            T delegatee = this.get(instance);
            if (delegatee == null) {
                throw new IllegalStateException("Cannot hijack null");
            }
            Class<?>[] interfaces = delegatee.getClass().getInterfaces();
            this.set(instance, WXInterception.proxy(delegatee, handler, interfaces));
        }

        public T get(C instance) {
            try {
                Object value = this.mField.get(instance);
                return (T)value;
            }
            catch (IllegalAccessException e) {
                WXLogUtils.e("", e);
                return null;
            }
        }

        public void set(C instance, Object value) {
            try {
                this.mField.set(instance, value);
            }
            catch (IllegalAccessException e) {
                WXLogUtils.e("", e);
            }
        }

        public Field getField() {
            return this.mField;
        }
    }

    public static abstract class HackDeclaration {

        public static class HackAssertionException
        extends Throwable {
            private static final long serialVersionUID = 1L;
            private Class<?> mHackedClass;
            private String mHackedFieldName;
            private String mHackedMethodName;

            public HackAssertionException(String e) {
                super(e);
            }

            public HackAssertionException(Exception e) {
                super(e);
            }

            @Override
            public String toString() {
                return this.getCause() != null ? this.getClass().getName() + ": " + this.getCause() : super.toString();
            }

            public Class<?> getHackedClass() {
                return this.mHackedClass;
            }

            public void setHackedClass(Class<?> mHackedClass) {
                this.mHackedClass = mHackedClass;
            }

            public String getHackedMethodName() {
                return this.mHackedMethodName;
            }

            public void setHackedMethodName(String methodName) {
                this.mHackedMethodName = methodName;
            }

            public String getHackedFieldName() {
                return this.mHackedFieldName;
            }

            public void setHackedFieldName(String fieldName) {
                this.mHackedFieldName = fieldName;
            }
        }
    }

    public static interface AssertionFailureHandler {
        public boolean onAssertionFailure(HackDeclaration.HackAssertionException var1);
    }
}

