/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.wrapper;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import java.util.Stack;

public class BounceRecyclerView
extends BaseBounceView<WXRecyclerView> {
    private RecyclerViewBaseAdapter adapter = null;
    private Stack<View> headerViewStack = new Stack();
    private Stack<WXCell> headComponentStack = new Stack();

    public BounceRecyclerView(Context context, int orientation) {
        super(context, orientation);
    }

    public BounceRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs, 1);
    }

    public void setAdapter(RecyclerViewBaseAdapter adapter) {
        this.adapter = adapter;
        if (this.getInnerView() != null) {
            ((WXRecyclerView)((Object)this.getInnerView())).setAdapter(adapter);
        }
    }

    public RecyclerViewBaseAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public WXRecyclerView setInnerView(Context context) {
        WXRecyclerView wxRecyclerView = new WXRecyclerView(context);
        wxRecyclerView.initView(context, 1, this.getOrientation());
        return wxRecyclerView;
    }

    @Override
    public void onRefreshingComplete() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onLoadmoreComplete() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifyStickyShow(WXCell component) {
        if (component == null) {
            return;
        }
        if (this.headComponentStack.isEmpty()) {
            this.headComponentStack.push(component);
            this.showSticky();
            return;
        }
        WXCell oldCom = this.headComponentStack.pop();
        if (!oldCom.getRef().equals(component.getRef())) {
            this.headComponentStack.push(oldCom);
            this.headComponentStack.push(component);
            this.showSticky();
            return;
        }
        this.headComponentStack.push(oldCom);
    }

    public void notifyStickyRemove(WXCell component) {
        if (component == null) {
            return;
        }
        if (!this.headComponentStack.isEmpty() && !this.headerViewStack.isEmpty()) {
            this.removeSticky(component);
        }
    }

    private void showSticky() {
        WXCell headComponent = this.headComponentStack.pop();
        this.headComponentStack.push(headComponent);
        ViewGroup headerView = headComponent.getRealView();
        if (headerView == null) {
            return;
        }
        this.headerViewStack.push((View)headerView);
        headComponent.removeSticky();
        ((ViewGroup)this.getParent()).addView((View)headerView);
    }

    private void removeSticky(WXComponent component) {
        WXCell headComponent = this.headComponentStack.pop();
        if (!component.getRef().equals(headComponent.getRef())) {
            this.headComponentStack.push(headComponent);
            return;
        }
        View headerView = this.headerViewStack.pop();
        ((ViewGroup)this.getParent()).removeView(headerView);
        headComponent.recoverySticky();
    }

    public void clearSticky() {
        int size = this.headComponentStack.size();
        while (size > 0 && this.headerViewStack.size() == size) {
            WXCell headComponent = this.headComponentStack.pop();
            View headerView = this.headerViewStack.pop();
            ((ViewGroup)this.getParent()).removeView(headerView);
            headComponent.recoverySticky();
        }
    }
}

