/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.wrapper;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.ui.view.refresh.core.WXSwipeLayout;

public abstract class BaseBounceView<T extends View>
extends FrameLayout {
    private int mOrientation = 1;
    protected WXSwipeLayout swipeLayout;
    private T innerView;

    public BaseBounceView(Context context, int orientation) {
        this(context, null, orientation);
    }

    public BaseBounceView(Context context, AttributeSet attrs, int orientataion) {
        super(context, attrs);
        this.mOrientation = orientataion;
        this.init(context);
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    private void init(Context context) {
        this.createBounceView(context);
    }

    boolean isVertical() {
        return this.mOrientation == 1;
    }

    public void setOnRefreshListener(WXSwipeLayout.WXOnRefreshListener onRefreshListener) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setOnRefreshListener(onRefreshListener);
        }
    }

    public void setOnLoadingListener(WXSwipeLayout.WXOnLoadingListener onLoadingListener) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setOnLoadingListener(onLoadingListener);
        }
    }

    public void finishPullRefresh() {
        if (this.swipeLayout != null) {
            this.swipeLayout.finishPullRefresh();
        }
    }

    public void finishPullLoad() {
        if (this.swipeLayout != null) {
            this.swipeLayout.finishPullLoad();
        }
    }

    private WXSwipeLayout createBounceView(Context context) {
        this.swipeLayout = new WXSwipeLayout(context);
        this.swipeLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.innerView = this.setInnerView(context);
        if (this.innerView == null) {
            return null;
        }
        this.swipeLayout.addView((View)this.innerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.swipeLayout, -1, -1);
        return this.swipeLayout;
    }

    public T getInnerView() {
        return this.innerView;
    }

    public abstract T setInnerView(Context var1);

    public void setHeaderView(View headerView) {
        this.setRefreshEnable(true);
        if (this.swipeLayout != null && this.swipeLayout.getHeaderView() != null) {
            this.swipeLayout.getHeaderView().setRefreshView(headerView);
        }
    }

    public void setFooterView(View footerView) {
        this.setLoadmoreEnable(true);
        if (this.swipeLayout != null && this.swipeLayout.getFooterView() != null) {
            this.swipeLayout.getFooterView().setRefreshView(footerView);
        }
    }

    public void setRefreshEnable(boolean enable) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setPullRefreshEnable(enable);
        }
    }

    public void setLoadmoreEnable(boolean enable) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setPullLoadEnable(enable);
        }
    }

    public WXSwipeLayout getSwipeLayout() {
        return this.swipeLayout;
    }

    public abstract void onRefreshingComplete();

    public abstract void onLoadmoreComplete();
}

