/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview.adapter;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import java.lang.ref.WeakReference;

public class WXRecyclerViewOnScrollListener
extends RecyclerView.OnScrollListener {
    protected LAYOUT_MANAGER_TYPE layoutManagerType;
    private int[] lastPositions;
    private int lastVisibleItemPosition;
    private int currentScrollState = 0;
    private WeakReference<IOnLoadMoreListener> listener;

    public WXRecyclerViewOnScrollListener(IOnLoadMoreListener listener) {
        this.listener = new WeakReference<IOnLoadMoreListener>(listener);
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        this.currentScrollState = newState;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        int visibleItemCount = layoutManager.getChildCount();
        int totalItemCount = layoutManager.getItemCount();
        if (visibleItemCount != 0) {
            int bottomOffset = (totalItemCount - this.lastVisibleItemPosition - 1) * recyclerView.getHeight() / visibleItemCount;
            if (visibleItemCount > 0 && this.currentScrollState == 0 && this.listener != null && this.listener.get() != null) {
                ((IOnLoadMoreListener)this.listener.get()).onLoadMore(bottomOffset);
            }
        }
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        ((IOnLoadMoreListener)this.listener.get()).onBeforeScroll(dx, dy);
        if (this.layoutManagerType == null) {
            if (layoutManager instanceof LinearLayoutManager) {
                this.layoutManagerType = LAYOUT_MANAGER_TYPE.LINEAR;
            } else if (layoutManager instanceof GridLayoutManager) {
                this.layoutManagerType = LAYOUT_MANAGER_TYPE.GRID;
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.layoutManagerType = LAYOUT_MANAGER_TYPE.STAGGERED_GRID;
            } else {
                throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
            }
        }
        switch (this.layoutManagerType) {
            case LINEAR: {
                this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                ((IOnLoadMoreListener)this.listener.get()).notifyAppearStateChange(((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition(), this.lastVisibleItemPosition, dx, dy);
                break;
            }
            case GRID: {
                this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case STAGGERED_GRID: {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                if (this.lastPositions == null) {
                    this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                }
                staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                this.lastVisibleItemPosition = this.findMax(this.lastPositions);
            }
        }
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static enum LAYOUT_MANAGER_TYPE {
        LINEAR,
        GRID,
        STAGGERED_GRID;

    }
}

